/* getfile2.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <scry_anima.h>


/* get_one_file:  read an input file's Anima footer
   get_footer:  combine two Anima file's footers */


/* read an input file's Anima footer */

get_one_file (a_file,a_filename,a_count,a_bytes)

FILE **a_file ;
char *a_filename ;
int *a_count ;		/* number of frames in file read */
int *a_bytes ;		/* number of bytes to footer in file read */

{
    char iff_id[80] ;
    char anima_id[80] ;
    int i ;

    if(*a_file != NULL)
        fclose(*a_file);

    if((*a_file = fopen(a_filename, "r")) == NULL)
    {
        perror("bad input file");
        return(0) ;
    }

    fscanf (*a_file,"%s\n",iff_id) ;
    if (strcmp(iff_id,"ncaa") != 0)
    {
        perror ("not an iff file\n") ;
        return (0) ;
    }

	/* Check if the file contains an Anima footer */
    fseek(*a_file, -5L, 2);
    Fread(&anima_id[0], 5, 1, *a_file);
    anima_id[5] = 0;

    if(strcmp(anima_id, "anima") == 0)
    {
            /* Read the no. of frames in the file */
        fseek(*a_file, -35L, 2);
        fscanf(*a_file, "number of frames=%12ld\n",a_count) ;
            /* Read no. of bytes of data in the file */
        fseek(*a_file, -65L, 2);
        fscanf(*a_file, "bytes to footer =%12ld\n",a_bytes) ;
        fseek(*a_file, 0L, 0);
    }
    else			/* Anima footer not present */
    {
        fprintf (stderr,"footer non-present\n") ;
        return(0) ;
    }
    return (1) ;
}




/* combine the information in two Anima file footers */

get_footer (file1,file2,count1,count2,bytes1,bytes2)

FILE *file1 ;
FILE *file2 ;
int count1 ;	/* number of frames in first file */
int count2 ;	/* number of frames in second file */
int bytes1 ;	/* number of bytes to footer in first file */
int bytes2 ;	/* number of bytes to footer in second file */

{
    int frame ;		/* frame number */
    int i ;

    if((S_a_index = Calloc(count1+count2, struct footer)) == NULL)
    {
        perror("frame index array");
        return(0) ;
    }

    fseek(file1, bytes1+3, 0) ;
        /* Read the footer image sequence information */
    for (i = count1-1 ; i >= 0 ; i--)
        fscanf(file1,"%ld %ld %ld\n",&frame,
               &(S_a_index[i].buf_total),&(S_a_index[i].offset)) ;
    fseek(file1,0,0) ;

    fseek(file2, bytes2+3, 0);
	/* Read the footer image sequence information */
    for (i = count2-1 ; i >= 0 ; i--)
        fscanf(file2,"%ld %ld %ld\n",&frame,
               &(S_a_index[i+count1].buf_total),&(S_a_index[i+count1].offset)) ;
    fseek(file2, 0L, 0);
}
