/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/* grot.c - 	to rotate a 3-D graph.
 *
 * 
 * usage:	grot [ x [ y [ z ]]]
 * 
 * defaults:	x,y,z...=0.0 degrees
 *
 *
 * To load:	cc -o grot grot.c  -lhipl
 *
 * Yoav Cohen 11/15/82
 *  added missing line: double atof();    -LBL
 *
 */

#include <stdio.h>
#include <math.h>
#include <hipl_format.h>
char *Progname;

#define PI 3.141592653589793238

double 	sh_v[3],rot_m[3][3],r[3][3],tv[3];
double atof();

double xf,yf,zf;

main(argc,argv)

char *argv[];

{
	struct header hd;
	int nf,i,j,k,flags,inbytes;
	char buf[FBUFLIMIT];

	Progname = strsave(*argv);
	/* parse arguments */

	xf=yf=zf=0.0;

	if(argv[argc-1][0]=='-' && argv[argc-1][1]=='D')argc--;
	if(argc<2||argc>4) perror("arguments?");
	if(argc>=2)zf=atof(argv[1]);
	if(argc>=3)yf=atof(argv[2]);
	if(argc==4)xf=atof(argv[3]);

	/* is there a file input ? */
	if(system("test -t 0")!=0) {
		read_header(&hd);
		if (hd.pixel_format != PLOT3D)
			perror("input must be in PLOT3D format");
		if (hd.num_frame <= 0)
			perror("no. of frames must be positive ");
		nf=hd.num_frame;
		update_header(&hd,argc,argv);
		write_header(&hd);
		fix_rot();
		for(i=0;i<nf;i++) {
			inbytes=read_frame(0,buf,FBUFLIMIT,&flags,sh_v,rot_m);
			mulm3(r,rot_m,rot_m);
			for(j=0;j<3;j++) {
				tv[j]=0.0;
				for(k=0;k<3;k++)
					tv[j] += sh_v[k]*r[j][k];
			}
			for(j=0;j<3;j++)
				sh_v[j]=tv[j];
			write_frame(1,buf,inbytes,sh_v,rot_m);
		}
	}
	else
		perror("no input file");

	return(0);
}

fix_rot()
{
	double xa,ya,za,a[3][3],b[3][3],c[3][3],t[3][3];
	double tv[3];
	int i,j;

	xa=PI/180.*xf;
	ya=PI/180. *yf;
	za=PI/180. *zf;

	a[0][0]=a[1][1]=cos(xa); a[0][1]= -(a[1][0] = sin(xa) );
	a[0][2]=a[1][2]=a[2][0]=a[2][1]=0.0;
	a[2][2]=1.;

	b[0][0]=b[2][2]=cos(ya);
	b[2][0]=sin(ya); b[0][2]= -b[2][0];
	b[0][1]=b[1][0]=b[1][2]=b[2][1]=0;
	b[1][1]=1.0;

	c[0][0]=1;
	c[0][1]=c[0][2]=c[1][0]=c[2][0]=0.;
	c[1][1]=c[2][2]=cos(za);
	c[2][1]=sin(za); c[1][2]= -c[2][1];

	mulm3(b,a,t); mulm3(c,t,r); 

	return;
}


mulm3(a,b,c) 
double a[3][3],b[3][3],c[3][3];
{
double t[3][3];
int	i,j,k;
	
	for(i=0;i<3;i++)
	for(j=0;j<3;j++) {
		t[i][j]=0.0;
		for(k=0;k<3;k++)
			t[i][j]+= a[i][k]*b[k][j];
	}
	for(i=0;i<3;i++)
	    for(j=0;j<3;j++)
		c[i][j]=t[i][j];
	return;
}
