/*

	testhf

	compile with:

	cc -o testhf testhf.c -lm [-lc_s]

------------------------------------------------------------------------

	testhf

	

	Copyright (C) 1992 by Lawrence K. Coffin
	All rights reserved.

	This software may be freely copied, modified, and redistributed
	provided that this copyright notice is preserved on all copies.
 
	You may not distribute this software, in whole or in part, as part of
	any commercial product without the express consent of the authors.
  
	There is no warranty or other guarantee of fitness of this software
	for any purpose.  It is provided solely "as is".

   This program creates a simple heightfield for use with the object testing
scene file "objs.ray".

*/
	


#include <stdio.h>
#include <math.h>

main(){

	FILE *fp;
	long int size;
	float al;
	int x, y;

	if ((fp = fopen("testobj.hf","wb")) == NULL){
		fprintf(stderr,"Unable to open testobj.hf for writing\n");
		exit (1);
	}

	size = 10;

	fwrite(&size,sizeof(long int),1,fp);

	for (y = 0; y < size; y++){
		for (x = 0; x < size; x++){
			al = sin(((float)(x*x) + (float)(y*y))/(float)(size*2))/4.0;
			fwrite(&al,sizeof(float),1,fp);
		}
	}

	fclose(fp);
}
