/*
 * $Id: rle_global.c,v 3.0 90/08/03 15:20:54 spencer Exp $
 */

#include <stdio.h>
#include "u_put.h"
#include "u_.h"

extern int	RunSetup( ARB_ARGS ),
		RunSkipBlankLines( ARB_ARGS ),
		RunSetColor( ARB_ARGS ),
		RunSkipPixels( ARB_ARGS ),
		RunNewScanLine( ARB_ARGS ),
		Runputdata( ARB_ARGS ),
		Runputrun( ARB_ARGS ),
		RunputEof( ARB_ARGS );

extern int	DefaultBlockHook( ARB_ARGS );
extern void	NullputEof( ARB_ARGS );

struct rle_dispatch_tab rle_DTable[] = {
    {
	" OB",
	RunSetup,
	RunSkipBlankLines,
	RunSetColor,
	RunSkipPixels,
	RunNewScanLine,
	Runputdata,
	Runputrun,
	DefaultBlockHook,
	RunputEof
    },
};

static int bg_color[3] = { 0, 0, 0 };

rle_hdr rle_dflt_hdr = {
    RUN_DISPATCH,		/* dispatch value */
    3,				/* 3 colors */
    bg_color,			/* background color */
    0,				/* (alpha) if 1, save alpha channel */
    2,				/* (background) 0->just save pixels, */
				/* 1->overlay, 2->clear to bg first */
    0, 511,			/* (xmin, xmax) X bounds to save */
    0, 511,			/* (ymin, ymax) Y bounds to save */
    0,				/* ncmap (if != 0, save color map) */
    8,				/* cmaplen (log2 of length of color map) */
    NULL,			/* pointer to color map */
    NULL,			/* pointer to comment strings */
    stdout,			/* output file */
    { 7 }			/* RGB channels only */
    /* Can't initialize the union */
};

/* ARGSUSED */
void
NullputEof(the_hdr)
rle_hdr * the_hdr;
{
				/* do nothing */
}
