/*
 *  hftopgm is a program to convert files to hf (rayshade height field) 
 *          pgm (pbmplus gray scale) format.
 *
 *          It was written by Mark Dyer (markd@tdd.sj.nec.com)
 *
 *          It works for Mark on a sun sparcstation, but it's never been
 *          tested anywhere else. It's a pretty simple minded program, so I
 *          don't think there'll be much trouble compiling it on other
 *          machines.
 *
 *          Enjoy.
 */

#include <pgm.h>
#include <fcntl.h>
#include <stdio.h>

float step = 0.0;
float datamax = 0.0;
float datamin = 0.0;
gray maxval = 0;

FILE *out_fp = stdout;
gray** image = NULL;

main(argc, argv)
     int argc;
     char *argv[];
{
   char *infile = NULL;

   pgm_init(&argc, argv);

   if(argc < 2) {
      fprintf(stderr,"Usage: %s infile [outfile]\n", argv[0]);
      exit(1);
   }
   infile = argv[1];

   if(argc > 2) {
      out_fp = fopen(argv[2], "w");
      if(!out_fp) {
	 fprintf(stderr, "Can't open %s for output!\n",argv[2]);
	 exit(1);
      }
   }

   step = 1 / (float)(PGM_MAXMAXVAL);

   ReadHeightFile(infile);

}


gray ScaleData(d)
     float d;
{
   gray p = 0;

   if(PGM_MAXMAXVAL > 255) {
      p = (gray) d;
   }
   else {
      p = (gray)
	((d - datamin) / step);
   }

   return p;
}

ReadHeightFile(fname)
     char *fname;
{
   int fd = 0;
   int size = 0;
   float *data;
   int r, c;
   gray g;

   fd = open(fname, O_RDONLY);
   if(fd == -1) {
      fprintf(stderr, "Can't open \"%s\"\n", fname);
      exit (1);
   }

   read (fd, &size, sizeof(int));
   printf("%s: %d x %d\n",
	  fname,
	  size, size);

   image = pgm_allocarray(size, size);



   data = (float*)malloc(size * size * sizeof(float));

   read (fd, data, size * size * sizeof(float));

   close(fd);

   for(r=0 ; r<size; r++) {
      for(c = 0; c < size; c++) {
	 if( *(data + (r * size) + c) == 0.0 ) continue;

	 g  = ScaleData( *(data +(r*size) + c));
	 if(g > maxval) maxval = g;

	 image[(size-1)-(r)][c] = g;
      }
   }

   pgm_writepgm(out_fp, image, size, size, maxval, 0);

   free(data);
}
