struct vector 
  {
  double x;
  double y;
  double z;
  double l;
  double xzl;
  };

struct ray 
  {
  struct vector org;
  struct vector dir;
  };

struct sphere_data 
  {
  struct vector cent;
  double rad;
  };

struct facet_data
  {
  struct vector pt1, pt2, pt3;
  };

union obj_data
  {
  struct sphere_data sphere;
  struct facet_data facet;
  };

struct object_data 
  {
  double ior;
  double rfr;
  double rfl;
  double dif;
  double amb;
  char type;
  union obj_data object;
  };

struct mat 
  {
  struct vector x;  /* first !row! */
  struct vector y;  /*second !row! */
  struct vector z;}; /* third !row! */

struct obj_link 
  {     /* LINKS FROM SEAD OR PREVIOUS LINK POINTS TO AN OBJECT */
  struct object_data *the_object;
  struct obj_link  *next_obj, *ptr;
  };

main()
{
  struct object_data t;

  t.object.sphere.rad = 3.4;
  t.object.sphere.cent.x = 3.5;
  printf("%f, %f\n", t.object.sphere.rad, t.object.sphere.cent.x);
  t.object.facet.pt1.x = 5.7;
  t.object.facet.pt2.y = 7.7;
  printf("%f %f\n", t.object.facet.pt1.x, t.object.facet.pt2.y);
}

