/* zbuf.h,v 1.1.1.1 1995/02/27 07:38:46 explorer Exp */

#ifndef ZBUF_H
#define ZBUF_H

#include "libcommon/common.h"
#ifndef FILE
#include <stdio.h>
#endif

#define ZBUF_HF		1
#define ZBUF_RLE	2
#define ZBUF_TXT	3
#define ZBUF_TXT3	4
#define DEFAULT_ZBUF_TYPE	ZBUF_HF

#define ZBUF_INF    ((Float) -1000.0)	/* Infinity; same as HF_UNSET in
					 * libray/libobj/hf.h */
/*
 * Z-buffer
 */
typedef struct {
  FILE *fzbuf;		       /* Zbuf file pointer */
  char *rayfile;	       /* Name of .ray input file */
  char *outfile;	       /* Name of output file */
  Float **array;	       /* Array of minimum distances from all pixels
			        * in the current window */
  char **argv;		       /* Write args as comment in text file */
  int pad;		       /* Number of pad values in heightfield output */
} RSZbuf;

typedef int HEIGHTFIELD_SIZE;  /* Same size as libray/libobj/hf.c */

extern RSZbuf z_buffer;
extern void ZbufPrint _PROTO((void));
extern void ZbufAdd _PROTO((Float, Float, Float));
extern void ZbufSetup _PROTO((void));

#endif
