/* funcdefs.h,v 1.1.1.1 1995/02/27 07:38:46 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef FUNCDEFS_H
#define FUNCDEFS_H

#ifdef STDC_HEADERS
#include <string.h>
#else
#include <strings.h>
#endif

/*
 * Misc. routines.
 */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else
extern void free(), exit();
#endif

#include "libsurf/surface.h"  /* for Surface definition */

extern void RSReadInputFile _PROTO((void));
extern void OpenStatsFile _PROTO((void));
extern void RLerror _PROTO((/* int, char *, char *, char *, char * */));
extern void RSGetCpuTime _PROTO((Float *, Float *));
extern Geom *GeomGetNamed _PROTO((char *));
extern void GeomAddToDefined _PROTO((Geom *));
extern Geom *GeomCopyNamed _PROTO((char *));
extern void WorldSetup _PROTO((void));
extern int  TraceRay _PROTO((Ray *, HitList *, Float, Float *));

/*
 * in setup.c
 */
extern void RSSetup _PROTO((void));
extern void RSCleanup _PROTO((void));
extern void RSStartFrame _PROTO((int));
extern void RSInitialize _PROTO((int, char *[]));

/*
 * in shade.c
 */
extern void ShadeRay _PROTO((HitList *, Ray *, Float,
			     Color *, Color *, Color *));
/*
 * in surfdef.c
 */
extern Surface *SurfaceGetNamed _PROTO((char *));
extern Surface *SurfaceFetchNamed _PROTO((char *));
extern void    SurfaceAddToDefined _PROTO((Surface *));

/*
 * part of the application using this library.  Defined here so we don't
 * have to pull a header file out of the application -- libray and libshade
 * are intertwined enough without adding a third directory...
 */
extern void VersionPrint _PROTO((void));

#endif /* FUNCDEFS_H */
