/* texture.h,v 1.2 1995/03/30 07:13:21 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef TEXTURE_H
#define TEXTURE_H

#include "libobj/geom.h"
#include "libsurf/surface.h"
#include "mapping.h"

/*
 * Surface properties
 */
#ifndef AMBIENT /* Check for GL definitions, and DON'T overwrite
			-- for rayview */
#define COLOR		0	/* AMBIENT, DIFFUSE, SPECULAR and BODY */
#define AMBIENT		1
#define DIFFUSE		2
#define SPECULAR	3
#define BODY		4
#define REFLECT		5
#define TRANSP		6
#define SPECPOW		7
#define BUMP		8
#define INDEX		9
#endif /* GL check */

#define TextPointToModel(p)	PointTransform(p, &model2text.itrans)
#define TextPointToPrim(p)	PointTransform(p, &prim2text.itrans)
#define TextPointToWorld(p)	PointTransform(p, &world2text.itrans)
#define TextRayToModel(p)	RayTransform(r, &model2text.itrans)
#define TextRayToPrim(r)	RayTransform(r, &prim2text.itrans)
#define TextRayToWorld(r)	RayTransform(r, &world2text.itrans)
#define TextNormToModel(n)	NormalTransform(n, &model2text.trans)
#define TextNormToPrim(n)	NormalTransform(n, &prim2text.trans)
#define TextNormToWorld(n)	NormalTransform(n, &world2text.trans)

#define ModelPointToText(p)	PointTransform(p, &model2text.trans)
#define ModelNormToText(n)	NormalTransform(n, &model2text.itrans)
#define ModelRayToText(r)	RayTransform(r, &model2text.trans)

typedef char *TextRef;

/*
 * Texture structure
 */
typedef struct Texture {
  TextRef data;			/* Texturing info */
  void	(*method)();		/* method */
  Trans	*trans;			/* transformation info */
  short	animtrans;		/* is the transformation animated? */
  struct Texture *next;		/* next in list */
} Texture;

/*
 * in texture.c
 */
extern Texture	*TextCreate _PROTO((TextRef, void (*)()));
extern void	TextApply _PROTO((Texture *, Geom *, Ray *, Vector *, Vector *,
				  Vector *, Surface *, Trans *, Trans *));
extern void     TextToUV _PROTO((Mapping *, Geom *, Vector *, Vector *,
				 Float *, Float *, Vector *, Vector *));
extern Texture  *TextAppend _PROTO((Texture *, Texture *));

/*
 * in noise.c
 */
extern void	DNoise3 _PROTO((Vector *, Vector *));
extern Float	Noise3 _PROTO((Vector *));
extern void     NoiseInit _PROTO((void));

/*
 * I have no idea where this is...
 */
extern Float    Noise2 _PROTO(());

/*
 * in textaux.c
 */
extern void	VfBm _PROTO((Vector *, Float, Float, int, Vector *));
extern void	Windy _PROTO((Vector *, Float, Float, Float, int,
			      Float, Float, Float, Vector *));
extern void	Wrinkled _PROTO((Vector *, Float, Float, int, Vector *));
extern Float    PAChaos _PROTO((Vector *, int));
extern Float    Chaos _PROTO((Vector *, int));
extern Float    Marble _PROTO((Vector *));
extern Float    fBm _PROTO((Vector *, Float, Float, int));
extern int	TileValue _PROTO((Float, Float, Float, Float));
Color		*ColormapRead _PROTO((char *));

extern Trans	model2text, prim2text, world2text;

#endif /* TEXTURE_H */
