/* triangle.h,v 1.1.1.1 1995/02/27 07:38:37 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef TRIANGLE_H
#define TRIANGLE_H

#define FLATTRI		0
#define PHONGTRI	1

#define GeomTriangleCreate(t,a,b,c,d,e,f,g,h,i,s)  GeomCreate( \
		(GeomRef)TriangleCreate(t,a,b,c,d,e,f,g,h,i,s), TriangleMethods())

/*
 * Triangle
 */
typedef struct {
  Vector  nrm;		/* triangle normal */
  Vector  p[3];		/* vertices */
  Vector  e[3];		/* "edge" vectors (scaled) */
  Vector  *vnorm;	/* Array of vertex normals */
  Vector  *dpdu, *dpdv;	/* U and V direction vectors */
  Float	  d;		/* plane constant  */
  Float   b[3];		/* Array of barycentric coordinates */
  Vec2d	  *uv;		/* Array of UV coordinates of vertices */
  char    index;	/* Flag used for shading/intersection test. */
  char    type;		/* type (to detect if phong or flat) */
} Triangle;

extern GeomRef  TriangleCreate _PROTO((int,
					Vector *, Vector *, Vector *,
					Vector *, Vector *, Vector *,
					Vec2d *, Vec2d *, Vec2d *,
					int));
extern Methods	*TriangleMethods METHODS_PROTO;
extern int	TriangleIntersect INTERSECT_PROTO;
extern int      TriangleNormal NORMAL_PROTO;
extern void     TriangleUV UV_PROTO;
extern void	TriangleBounds BOUNDS_PROTO;
char		*TriangleName NAME_PROTO;
extern void	TriangleStats STATS_PROTO;
extern void     TriangleMethodRegister _PROTO((UserMethodType));

#endif /* TRIANGLE_H */
