/* rotspline.h,v 1.1.1.1 1995/02/27 07:38:36 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef ROTSPLINE_H
#define ROTSPLINE_H

#define GeomRotsplineCreate(a,r1,d1,b,r2,d2,c) GeomCreate((GeomRef)RotsplineCreate(a,r1,d1,b,r2,d2,c), \
					RotsplineMethods())

#define EvalSpline(c, x) (c[3]*x*x*x + c[2]*x*x + c[1]*x + c[0])

/*
 * Rotspline
 */
typedef struct rotspline {
  Float *k;
  Float w;
  Trans trans;
} Rotspline;

extern GeomRef   RotsplineCreate _PROTO((Vector *, Float, Float, Vector *,
					  Float, Float, Float *));
extern int	 RotsplineIntersect INTERSECT_PROTO;
extern int       RotsplineNormal NORMAL_PROTO;
extern void	 RotsplineBounds BOUNDS_PROTO;
extern void      RotsplineStats STATS_PROTO;
extern void      RotsplineUV UV_PROTO;
extern char	 *RotsplineName NAME_PROTO;
extern Methods	 *RotsplineMethods METHODS_PROTO;

#endif /* ROTSPLINE_H */
