/* box.h,v 1.1.1.1 1995/02/27 07:38:31 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef BOX_H
#define BOX_H

#define GeomBoxCreate(a,b) GeomCreate((GeomRef)BoxCreate(a,b), BoxMethods())

/*
 * Box
 */
typedef struct box {
  Float bounds[2][3];
} Box;

extern GeomRef  BoxCreate _PROTO((Vector *, Vector *));
extern Methods	*BoxMethods METHODS_PROTO;
extern int	BoxIntersect INTERSECT_PROTO;
extern int      BoxNormal NORMAL_PROTO;
extern int      BoxEnter ENTER_PROTO;
extern void	BoxBounds BOUNDS_PROTO;
extern char	*BoxName NAME_PROTO;
extern void     BoxStats STATS_PROTO;
extern void     BoxMethodRegister _PROTO((UserMethodType));

#endif /* BOX_H */
