/* sampling.h,v 1.1.1.1 1995/02/27 07:38:26 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef SAMPLING_H
#define SAMPLING_H

/*
 * # of subsamples to take within each of the totsamples slots when
 * computing 'animated' bounding boxes.
 */
#define TIME_SUB_SAMPLES	10

typedef struct SampleInfo {
  int	totsamples;	/* # of samples/pixel */
  int	sidesamples;	/* sqrt(samples) */
  int	gaussian;	/* gaussian filter? */
  int	framenum;	/* current frame numer */
  int	timemagic;	/* # of time samples per screen... */
  Float	weight;		/* 1. / totsamples */
  Float	spacing;	/* 1. / sidesamples  */
  Float	filterwidth;	/* total width of filter */
  Float	filterdelta;	/* filterwidth * spacing */
  Float	**filter;	/* pixel filter, sidesamp by sidesamp */
  Float	starttime;	/* start time */
  Float	shutter;	/* length of time shutter is open */
} SampleInfo;

extern SampleInfo Sampling;

extern void	SamplingSetOptions _PROTO((int, int, Float));
extern void     SamplingSetTime _PROTO((Float, Float, int));
extern void     UnitCirclePoint _PROTO((Vector *, int));

#endif /* SAMPLING */
