/* ray.h,v 1.1.1.1 1995/02/27 07:38:26 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef RAY_H
#define RAY_H
/* 
 * Ray types 
 */
#define EYE_RAY         1
#define SHADOW_RAY      2
#define REFLECT_RAY     3
#define REFRACT_RAY     4

/* 
 * Ray
 */
typedef struct Ray {
	Vector	pos,			/* Origin */
		dir;			/* Direction */
	int 	depth,			/* depth in ray tree */
		sample;			/* current sample # */
	Float	time;
        Vector  viewpoint;              /* ray viewpoint */
        int     type;                   /* EYE_RAY, SHADOW_RAY, ... */
        Float   viewdist,               /* for pixelsize computation */
	        width,
                stretch;                /* amount the ray is stretched by transformations */

	struct Medium *media;		/* Medium ray is passing through */
} Ray;
#endif
