#include <RpFillConstant.h>
#include <RpSampledImage.h>
#include <assert.h>


RpSampledImage::RpSampledImage( void )
{
   _pFiller = new RpFillConstant( (float)0.0 );
   _area.x = 0;
   _area.y = 0;
   _area.z = 1;
   _area.c = 1;   
   _area.width = 0;
   _area.height = 0;
   return;
}

RpSampledImage::~RpSampledImage( void )
{   
   if ( _pFiller )
      _pFiller->unregisterReference();
      
   if( getManPointer() )
      (* getManPointer() ).flushCache( this );
      
   return;
}


void
RpSampledImage::setArea( const RpImageArea& setArea )
{
   _area = setArea;
   return;
}


void
RpSampledImage::setFillStrategy( RpFillStrategy *pStrategy )
{
   if ( pStrategy != _pFiller )
   {
      if ( _pFiller )
	 _pFiller->unregisterReference();
      _pFiller = pStrategy;
      if ( _pFiller )
	 _pFiller->registerReference();
   }
   return;
}


int
RpSampledImage::applyFillStrategy( RpImageTile *pWriteHere )
{
   int	iRet = 0;
   
   if ( pWriteHere && _pFiller )
      iRet = _pFiller->fillTile( this, pWriteHere );

   return ( iRet );
}

// ************************************************************************

RpImageTile *
RpSampledImage::newTile( const RpImageArea& area )
{
   RpImageMan *pManager;
   RpImageTile *pTile = 0;

   pManager = getManPointer();
   if ( pManager )
      pTile = pManager->newTile( this, area );

   return( pTile );
}
