#include <RpSampledImage.h>
#include <RpImageMan.h>
#include <RpImageTile.h>

#include <RpMiniMan.h>
#include <RpSoftPullMan.h>

#include <assert.h>

// ************************************************************************
//
// default settings at application startup:
//

#define  DEF_RAMBOUND           ( 2048 * 2048 ) // 4MB
#define	 DEF_TILEBOUND		( 64 * 64 ) // 4096 pixels


RpImageMan *RpManReference::_pManager = 0;
unsigned RpManReference::_uReferences = 0;

RpImageMan::Type RpManReference::_type = RpImageMan::Mini;
unsigned long RpManReference::_ulRAM = DEF_RAMBOUND;
unsigned long RpManReference::_ulPixels = DEF_TILEBOUND;
// ************************************************************************


void
RpManReference::realloc( void )
{
   if ( _pManager )
      delete _pManager;
   
   switch( _type )
   {
      default:
      case( RpImageMan::Mini ):
         _pManager = new RpMiniMan( _ulRAM, _ulPixels );
         break;
     case( RpImageMan::SoftPull ):
         _pManager = new RpSoftPullMan( _ulRAM, _ulPixels );
         break;        
   };
   
   return;
}



RpManReference::RpManReference( void )
{
   if ( !_pManager )
      realloc( );

   if ( _pManager )
      _uReferences++;
   return;
}


RpManReference::~RpManReference( void )
{
   if ( _pManager )
   {
      _uReferences--;

      if ( !_uReferences )
      {
         delete _pManager;
         _pManager = 0;
      }  
   }

   return;
}


RpImageMan *
RpManReference::setManagerType( RpImageMan::Type setType )
{
   if ( _type != setType )
   {
      _type = setType;
      
      if ( _pManager )
      {
	 _ulRAM = _pManager->getRAMBound();
	 _ulPixels = _pManager->getTileBound();      

	 delete _pManager;
	 _pManager = 0;
      }
   
      realloc();
   }
   
   return ( _pManager );
}

// ************************************************************************

unsigned long
RpImageMan::getRAMBound( void ) const
{
   return ( _lRAMBound );
}

void
RpImageMan::setRAMBound( unsigned long ulBytes )
{
   _lRAMBound = ulBytes;
   return;
}

unsigned long
RpImageMan::getTileBound( void ) const
{
   return( _lTileBound );
}

void
RpImageMan::setTileBound( unsigned long ulTileBound )
{
   _lTileBound = ulTileBound;
   return;
}


RpImageMan::RpImageMan( unsigned long ulSetRAMBound, unsigned long ulSetTileBound )
{
   setTileBound( ulSetTileBound );
   setRAMBound( ulSetRAMBound );
   return;
}


RpImageMan::~RpImageMan( void )
{
   return;
}
