#include <RpImageArea.h>
#include <assert.h>

RpImageArea
intersect( const RpImageArea& area1, const RpImageArea& area2 )
{
   RpImageArea		ret;   
   register signed	iVal1, iVal2, x0, y0;
   
   if (( area1.z == area2.z ) && ( area1.c == area2.c ))
   {
      ret.z = area1.z ;
      ret.c = area1.c ;
      
      // ret.x = max ( area1.x, area2.x );
      ret.x = ( area1.x > area2.x ) ? ( area1.x ) : ( area2.x );

      // ret.y = max ( area1.y, area2.y );
      ret.y = ( area1.y > area2.y ) ? ( area1.y ) : ( area2.y );
      
      // x0 = min ( (area1.x + area1.width), (area2.x + area2.width ));
      iVal1 = (area1.x + area1.width);
      iVal2 = (area2.x + area2.width);
      x0 = ( iVal1 < iVal2 ) ? ( iVal1 ) : ( iVal2 );
      
      // y0 = min( (area1.y + area1.height),(area2.y + area2.height) );
      iVal1 = (area1.y + area1.height);
      iVal2 = (area2.y + area2.height);
      y0 = (iVal1 < iVal2) ? ( iVal1 ) : ( iVal2 );
      
      ret.width = ( x0 > ret.x ) ? ( x0 - ret.x ) : ( 0 );
      ret.height = ( y0 > ret.y ) ? ( y0 - ret.y ) : ( 0 );
      
   } else 
   {
      ret.x = 0 ;
      ret.y = 0;
      ret.c = 0;
      ret.z = 0;
      ret.width = 0;
      ret.height = 0;
   }
   
   return ( ret );
}


void
difference ( RpImageArea writeHere[8], const RpImageArea& area, const RpImageArea& minusThis )
{
   unsigned 		uLoop;
   RpImageArea		temp;


   if (( area.c == minusThis.c ) && ( area.z == minusThis.z ))
   {
      temp = intersect( area, minusThis );
      
      if ( temp.width && temp.height )
      {   

	 writeHere[ 0 ].x = area.x;
	 writeHere[ 0 ].y = area.y;
	 if( temp.x >= area.x )
            writeHere[ 0 ].width = temp.x - area.x;
	 else
            writeHere[ 0 ].width = 0;
	 if( temp.y >= area.y )
            writeHere[ 0 ].height = temp.y - area.y;
	 else
            writeHere[ 0 ].height = 0;

	 writeHere[ 1 ].x = writeHere[ 0 ].x;
	 writeHere[ 1 ].y = temp.y;
	 writeHere[ 1 ].width = writeHere[ 0 ].width;
	 writeHere[ 1 ].height = temp.height;

	 writeHere[ 2 ].x = writeHere[ 0 ].x;
	 writeHere[ 2 ].y = temp.y + temp.height;
	 writeHere[ 2 ].width = writeHere[ 0 ].width;
	 if ( (area.y + (signed)area.height ) >= writeHere[2].y )
            writeHere[ 2 ].height = (area.y + (signed)area.height) - writeHere[ 2 ].y;
	 else
            writeHere[ 2 ].height = 0;

	 writeHere[ 3 ].x = temp.x;
	 writeHere[ 3 ].y = writeHere[ 0 ].y;
	 writeHere[ 3 ].width = temp.width;
	 writeHere[ 3 ].height = writeHere[ 0 ].height;

	 writeHere[ 4 ].x = writeHere[ 3 ].x;
	 writeHere[ 4 ].y = writeHere[ 2 ].y;
	 writeHere[ 4 ].width = writeHere[ 3 ].width;
	 writeHere[ 4 ].height = writeHere[ 2 ].height;

	 writeHere[ 5 ].x = temp.x + temp.width;
	 writeHere[ 5 ].y = writeHere[ 0 ].y;
	 if( (area.x + (signed)area.width) >= writeHere[5].x )
            writeHere[ 5 ].width = (area.x + (signed)area.width) - writeHere[ 5 ].x;
	 else
            writeHere[ 5 ].width = 0;
	 writeHere[ 5 ].height = writeHere[ 0 ].height;

	 writeHere[ 6 ].x = writeHere[ 5 ].x;
	 writeHere[ 6 ].y = writeHere[ 1 ].y;
	 writeHere[ 6 ].width = writeHere[ 5 ].width;
	 writeHere[ 6 ].height = writeHere[ 1 ].height;

	 writeHere[ 7 ].x = writeHere[ 5 ].x;
	 writeHere[ 7 ].y = writeHere[ 2 ].y;
	 writeHere[ 7 ].width = writeHere[ 5 ].width;
	 writeHere[ 7 ].height = writeHere[ 2 ].height;
      }  else
      {
         writeHere[ 0 ] = area;
         for ( uLoop=1; uLoop<8; uLoop++ )
         {
            writeHere[ uLoop ].x = writeHere[ uLoop ].y = 0;
            writeHere[ uLoop ].width = writeHere[ uLoop ].height = 0;
         }
      }
                    
      uLoop = 8;
      while ( uLoop )
      {
         --uLoop;
         writeHere[ uLoop ].z = area.z;
         writeHere[ uLoop ].c = area.c;
      }
            
   } else
      for ( uLoop=0; uLoop<8; uLoop++ )
      {
         writeHere[ uLoop ].x = 0;
	 writeHere[ uLoop ].y = 0;
	 writeHere[ uLoop ].width = 0;
	 writeHere[ uLoop ].height = 0;
	 writeHere[ uLoop ].z = 0;
	 writeHere[ uLoop ].c = 0;
      }
     
   return;
}
