#include <RpContraster.h>
#include <RpType.h>

#include <assert.h>

RpContraster::RpContraster( RpInputImage *pIn, float rLumFactor, float rGrey )
{
   _pHost = pIn;
   if ( _pHost )
   {
      _pHost->registerReference();
      
      if ( precedence( _pHost->getType() ) > precedence( RpFilm ) )
         setType( RpFloat );
      else
         setType( RpFilm );      
   }

   _rLumFactor = rLumFactor;
   _rGrey = rGrey;
   
   return;
}


RpContraster::~RpContraster( void )
{
   if ( _pHost )
      _pHost->unregisterReference();
   return;
}



int
RpContraster::fillTile( RpImageTile *pWriteHere )
{
   int			iRet = 0;
   RpImageTile		*pTile;
   
   if ( _pHost && pWriteHere )
   {
      pTile = _pHost->newTile( pWriteHere->getArea() );
      if ( pTile )
      {
         assert( getType() == pWriteHere->getType() );
         // or safer & slower : pWriteHere->alloc( pWriteHere->getArea(), RpFloat );
         assert(( getType() == RpFilm )||( getType() == RpFloat ));
         
         if ( getType() == RpFilm )
            contrastFilm( pWriteHere, pTile );
         else
            contrastFloat( pWriteHere, pTile );
                           
         pTile->deleteTile();         
         
      } else
         iRet = -1;
         
   } else
      iRet = -1;
   
   return ( iRet );
}




void
RpContraster::contrastFloat( RpImageTile *pWriteHere, RpImageTile *pSource )
{
   unsigned long	lLoop;   
   register float	*pSrc;
   register float	*pDest;

   assert( pSource && pWriteHere );
   
   pSource->typecast( RpFloat );
   pSrc = (float *) pSource->getBuffer();
   pDest = (float *) pWriteHere->getBuffer();
   
   lLoop = pWriteHere->getArea().width * pWriteHere->getArea().height;
   while ( lLoop )
   {
      lLoop--;
      *pDest = _rGrey + (( *pSrc - _rGrey ) * _rLumFactor );
      pDest++;
      pSrc++;
   }

   return;
}



void
RpContraster::contrastFilm( RpImageTile *pWriteHere, RpImageTile *pSource )
{
   unsigned long		lLoop;   
   register float		rValue;
   
   register float		*pSrc;
   register unsigned short	*pDest;

   assert( pSource && pWriteHere );
   
   pSource->typecast( RpFloat );   
   pSrc = (float *) pSource->getBuffer();
   pDest = (unsigned short *) pWriteHere->getBuffer();
   
   lLoop = pWriteHere->getArea().width * pWriteHere->getArea().height;
   while ( lLoop )
   {
      lLoop--;
      rValue = _rGrey + (( *pSrc - _rGrey ) * _rLumFactor );      
      
      rValue *= RpFilmWhite - RpFilmBlack;
      rValue += RpFilmBlack;
      
      rValue = ( rValue > RpFilmMax ) ? ( RpFilmMax ) : ( rValue );
      rValue = ( rValue < RpFilmMin ) ? ( RpFilmMin ) : ( rValue );

      *pDest = (unsigned short) rValue;
      pDest++;
      pSrc++;
   }

   return;
}

