#ifndef RpTypeCaster_CLASS
#define RpTypeCaster_CLASS

#include <RpInputImage.h>
#include <RpSampledImage.h>
#include <RpImageArea.h>

// ************************************************************************
// CLASS: RpTypeCaster
// DESC:
//    This class executes no image processing operation.
//    It should be used sparingly in order to strategically
//    cache data - possibly storing it in a given data format.
// ************************************************************************

class RpTypeCaster : public RpSampledImage {
   public:   
      RpTypeCaster( RpInputImage *pImage, const RpImageArea& , RpType );
      RpTypeCaster( RpSampledImage *pImage, RpType );
      
      ~RpTypeCaster( void );
      
      int
      fillTile( RpImageTile *pWriteHere );
      
   protected:
   
      RpInputImage	*_pHost;      
};


#endif
