#ifndef RpSGIWriter_CLASS
#define RpSGIWriter_CLASS

#include <RpReferenced.h>

#include <RpType.h>
#include <RpInputImage.h>
#include <RpSampledImage.h>
#include <RpImageTile.h>
#include <RpTypeCaster.h>

#include <fstream.h>

// ************************************************************************
// CLASS: RpSGIWriter
// DESC:
//    Writes an uncompressed SGI image
// NOTE:
//    Upon instantiation, this operator begins execution of the
//    processing graph and writes the file.
// NOTE:
//    It is okay to base output operators on this model for the short
//    term, but eventually a file format management mechanism will be
//    constructed.
//
class RpSGIWriter : public RpReferenced {
   public:
      RpSGIWriter( const char *cpOutFilename, RpSampledImage *pInput );
      RpSGIWriter( const char *cpOutFilename, RpSampledImage *pInput, RpType setType ); 
      RpSGIWriter( const char *cpOutFilename, RpInputImage *pInput, const RpImageArea& setArea, RpType setType = RpUShort );

      ~RpSGIWriter( void ) { }
      
      int
      isOkay( void ) const
      { return( _iOK ); }
      
   protected:   
      RpTypeCaster	_source;
      int		_iOK;
      
      int
      writeSGIFile( const char *cpFilename );
      
      int
      validateFile( ofstream& outfile, const RpImageArea& area, const RpType setType );
      
      int
      writeRows( ofstream& outfile, RpType fileType );
      
      void
      _commit( ofstream& outfile, void *vpBuffer, unsigned uPixels, RpType setType );
      
      void
      castFromShort( unsigned char *cp, unsigned short sWord)
      { cp[0] = ( sWord >> 8 ) & 0xFF; cp[1] = sWord & 0xFF; }
      
      void
      castFromLong( unsigned char *cp, unsigned long lWord )
      { cp[0] = ( lWord >> 24 ) & 0xFF; cp[1] = ( lWord >> 16 ) & 0xFF; cp[2] = ( lWord >> 8 ) & 0xFF; cp[3] = ( lWord & 0xFF ); }
      
};

#endif

