#ifndef RpReferenced_CLASS
#define RpReferenced_CLASS

// *******************************************************************
// FILE: RpReferenced.h
//
// DESCRIPTION:
//    Tracking references helps an object to manage its own
//    deallocation.
// NOTE:
//    Never call <operator delete> on a referenced object.
//    Use RpReferenced::unregisterReference();
//


class RpReferenced {
   public:
      RpReferenced(void)		{ _uReferences = 1; }
      
      void
      registerReference()		{ _uReferences++; }
      
      void
      unregisterReference();
      
      unsigned
      countReferences()			{ return (_uReferences);}
      
  protected:
     virtual
     ~RpReferenced(void)		{ }
     
  private:
     unsigned _uReferences;     
};


#endif
