#ifndef RpConvolver_CLASS
#define RpConvolver_CLASS

#include <RpSampledImage.h>
#include <RpImageTile.h>

// ************************************************************************
// CLASS: RpConvolver
// DESC:
//    Implements the operation of convolution.
// NOTE:
//    In order to insure quality, this operation may cast up the data type.
//
class RpConvolver : public RpSampledImage {
   public:
      RpConvolver( RpSampledImage *pSource, RpImageTile *pKernel );
      RpConvolver( RpInputImage *pSource, const RpImageArea& area, RpImageTile *pKernel );
      ~RpConvolver( void );
      
      float
      getCostEstimate( const RpImageArea& area );
      
      // ------------------------------------------------------------------
      // post: returns a non-zero on error.
      //
      int
      fillTile( RpImageTile *pWriteHere );
      
      // ------------------------------------------------------------------
      // convenience functions for managing kernels:
      //
      static RpImageTile *
      newKernel( const float *fpRowsThenColumns, unsigned uWidth, unsigned uHeight );
      
      static void
      deleteKernel( RpImageTile *p )
      { p->deleteTile(); }
      
   protected:
      RpInputImage			*_pSource;
      RpImageTile			*_pKernel;
      
      void
      setSourceArea( RpImageArea& sourceArea, const RpImageArea& kernelArea, const RpImageArea& destArea );

      void
      doConvFloat( RpImageTile *pWriteHere, const RpImageTile *pSource );

      void
      doConvFilm( RpImageTile *pWriteHere, const RpImageTile *pSource );
};

#endif
