#ifndef RpCompositer_CLASS
#define RpCompositer_CLASS

#include <RpInputImage.h>

// ************************************************************************
// CLASS: RpCompositer
// DESC:
//    Implements image overlay, suitable for alpha-channel compositing
// 
class RpCompositer : public RpInputImage {
   public:
      RpCompositer( RpInputImage *pForeground, RpInputImage *pBackground, RpInputImage *pMatte, unsigned uChannelIndex, unsigned uChannelCount = 1 );
      ~RpCompositer( void );
      
      int
      fillTile( RpImageTile *pWriteHere );
      
   protected:         
      RpInputImage	*_pForeground;
      RpInputImage	*_pBackground;
      RpInputImage	*_pMatte;
      
      unsigned		_uChannelIndex;
      unsigned		_uChannelCount;
      
      void
      doComposite( RpImageTile *pWriteHere, RpImageTile *pFore, RpImageTile *pBack, RpImageTile *pMatte );
};

#endif

