#ifndef RpCachable_CLASS
#define RpCachable_CLASS

#include <RpImageMan.h>

// ************************************************************************
// CLASS: RpCachable
// DESC:
//    Abstracts cache-related requirements that an cache-qualifying 
//    image should satisfy.
//
class RpCachable {
   public:
      RpCachable( void ) { }
      
      virtual
      ~RpCachable( void ) { }
      
      // ------------------------------------------------------------------
      // desc:
      //    returns an estimation of the computational cost of calculating
      //    the given area.
      // note:
      //    For consistency, try to uphold these conventions
      //       floating point multiply	costs 1.0 unit
      //       floating point divide          3.0 unit
      //       floating point add/sub         0.3 unit
      //       disk access                    1.0 unit/pixel
      //    Obviously, this isn't 100% accurate for all platforms.
      // note:
      //    This method is used by the image manager to optimize
      //    and prioritize image tiles in the cache.
      //      
      virtual float
      getCostEstimate( const RpImageArea& area )
      { return ( (float)( area.width * area.height )); }
      
   protected:
   
      // ------------------------------------------------------------------
      // desc:
      //    convenience method for use within derived classes.
      //
      RpImageMan *
      getManPointer( void )
      { return ( _manager.getPointer() ); }             
   
   private:
      RpManReference	_manager;   
};


#endif
