#ifndef lint
static       char    rcsid[] = "$Header: options.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	options.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * get optional properties from the DXF file
 * if any optional property is found, return 1, else 0
 */

INT	OptionsDxfParse(options)
OPTIONS	**options;
{
	switch (Group->code) {
	case 6:
		/*
		 * linetype name (if not "BYLAYER")
		 * the special ame "BYBLOCK" indicates a floating linetype
		 */

		 if (*options == NULL)
		 	*options = Malloc(OPTIONS, 1);

		if ((*options)->linetypeset != 0)
			DXFERR("duplicated optional linetype %s", "\n");

		(*options)->linetypeset = 1;

		/*
		 * linetype is not used here
		 *
		 * (*options)->linetype = Malloc(CHAR, strlen(Group->string) + 1);
		 * (VOID) strcpy((*options)->linetype, Group->string);
		 */

		return(1);

	case 38:
		/*
		 * elevation (if nonzero). output only if system variable
		 * FLATLAND is set to 1. otherwise, Z coordinates are supplied
		 * as 3x-groups as parts of each of the entity's defining
		 * points.
		 *
		 * note: in a 3D DXF file, this should not exist.
		 */

		DXFERR("optional elevation group should not occur in a 3D DXF file %s", "\n");

	case 39:
		/*
		 * thickness (if nonzero)
		 */

		 if (*options == NULL)
		 	*options = Malloc(OPTIONS, 1);

		if ((*options)->thicknessset != 0)
			DXFERR("duplicated optional thickness %s", "\n");

		(*options)->thicknessset = 1;
		(*options)->thickness = Group->fltnum;
		return(1);

	case 62:
		/*
		 * color number (if not "BYLAYER")
		 * zero indicates the "BYBLOCK" (floating) color
		 */

		 if (*options == NULL)
		 	*options = Malloc(OPTIONS, 1);

		if ((*options)->colornumberset != 0)
			DXFERR("duplicated optional color number%s", "\n");

		(*options)->colornumberset = 1;

		/*
		 * color number is not used here
		 *
		 * (*options)->colornumber = Group->integer;
		 */

		return(1);

	case 210:
		/*
		 * extrusion direction if it is not parallel to the
		 * World Z axis.
		 */

		 if (*options == NULL)
		 	*options = Malloc(OPTIONS, 1);

		if ((*options)->extrusionset != 0)
			DXFERR("duplicated extrusion direction %s", "\n");

		(*options)->extrusionset = 1;
		(*options)->extrusion = Malloc(FLOAT, 3);

		CoordDxfParse(200, (*options)->extrusion);

		/*
		 * should the extrusion direction be normalized ?
		 *
		 * VecNormalize((*options)->extrusion);
		 */

		return(1);

	default:
		return(0);
	}
}

/*
 * check if having thickness property
 * reture 1 if true, else 0
 */

INT	OptionsThickness(options, thickness)
OPTIONS	*options;
FLOAT	*thickness;
{
	if (options == NULL)
		return(0);

	if (options->thicknessset == 0)
		return(0);

	if (fabs(options->thickness) < TOE)
		return(0);

	*thickness = options->thickness;
	return(1);
}

/*
 * check if having extrusion direction property
 * if true, reture a pointer to the extrusion direction, else NULL
 */

FLOAT	*OptionsExtrusion(options)
OPTIONS	*options;
{
	if (options == NULL)
		return(ZAxis);

	if (options->extrusionset == 0)
		return(ZAxis);

	/*
	 * more checks
	 */

	if (options->extrusion == NULL)
	 	return(ZAxis);

	if (VecLength(options->extrusion) < TOE)
		return(ZAxis);

	return(options->extrusion);
}

/*
 * calculate an extrusion vector
 * if found, return 1, else 0
 */

INT	OptionsExtrusionVector(options, vector)
OPTIONS	*options;
FLOAT	vector[3];
{
	FLOAT	*extrusion;

	if (options == NULL)
		return(0);

	if (options->thicknessset == 0)
		return(0);

	if (fabs(options->thickness) < TOE)
		return(0);

	extrusion = OptionsExtrusion(options);

	VecScale(options->thickness, extrusion, vector);

	return(1);
}
