/* $Header: extern.h,v 1.2 90/12/12 15:30:21 zhang Exp $ */

/*
 * $Log:	extern.h,v $
 * 
 * Revision 1.1  90/03/13  23:25:04  zhang
 * Initial revision
 *
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#ifndef	_EXTERN

extern	CHAR	*ProgName;		/* name of the program */

extern	CHAR	*DxfFileName;		/* current DXF file name */

extern	INT	DxfAscOrBin;		/* 0 if current DXF file is ASCII */
					/* 1 if it is BINARY */
extern	INT	DxfFileLine;		/* current DXF file line counter */
					/* for ASCII DXF file parsing */
extern	INT	DxfFileByte;		/* current DXF file byte counter */
					/* for BINARY DXF file parsing */
extern	VOID	(*GlobleGetNextGroup[]) ();
					/* globle GetNextGroup functions for */
					/* parsing ASCII and BINARY DXF files */
extern	INT	OutFileType;		/* output file type, 0 for DEF, */
					/* 1 for NFF, 2 for DXF, -1 for none */

extern	FILE	*OutFile;		/* output file handler */

extern	GROUP	*Group;			/* global group of code and value */

extern	NAME	*NameList;		/* list of object name for output */

extern	BLOCK	*BlockList;		/* list of blocks defined in BLOCKS */
					/* or defined in block libaries */

extern	ENTITY	*EntityList;		/* list of entities defined in */
					/* ENTITIES section */

extern	LAYER	*LayerList;		/* list of layers defined in */
					/* ENTITIES section */

extern	FLOAT	MinCircleRadius;	/* min circle radius for circle/arc */
					/* tesselation */

extern	FLOAT	XAxis[];		/* default X axis direction */

extern	FLOAT	YAxis[];		/* default Y axis direction */

extern	FLOAT	ZAxis[];		/* default Z axis direction */

extern	STACK	*CurrentStack;		/* current stack for handling a block */

extern	CHAR	*JoinStr;		/* string linking block name and */
					/* layer name, default "_" */

extern	CHAR	*PrefixStr;		/* string as prefix of a name */
					/* starting with non-alpha char */
					/* default "_" */

extern	INT	JoinMode;		/* method for linking block name */
					/* and layer name, default 1 for */
					/* block name + layer name, 0 for */
					/* layer name only */

extern	INT	RadId;			/* for unique id in RAD file */

extern	ENTITYPROCS	EntityProcs[];	/* functions processing entities */

#define	_EXTERN
#endif
