/* vertex.c */

#include "vertex.h"
#include "Memory.h"
#include "debug.h"

#ifdef BETTER_MEMMAN
static STORAGE *vertexStor = (STORAGE *)NULL;
#define NEWVERTEX()  	(VERTEX *)New(sizeof(VERTEX), &vertexStor)
#define DISPOSEVERTEX(ptr) Dispose((unsigned char *)(ptr), &vertexStor)
#else /*BETTER_MEMMAN*/
#define NEWVERTEX()	(VERTEX *)Alloc(sizeof(VERTEX))
#define DISPOSEVERTEX(ptr) Free((char *)ptr, sizeof(VERTEX))
#endif /*BETTER_MEMMAN*/

static int TotalVertices = 0;

int GetNumberOfVertices(void)
{
	return TotalVertices;
}

VERTEX *VertexCreate(POINT *point, VECTOR *normal, PATCHLIST *patches, RGB *color)
{
	VERTEX *v;

	v = NEWVERTEX();
	v->point = point;
	v->normal = normal;
	v->patches = patches;
	v->color = *color;

	TotalVertices++;

	return v;
}

void VertexDestroy(VERTEX *vertex)
{
	PatchListDestroy(vertex->patches);
	DISPOSEVERTEX(vertex);
	TotalVertices--;
}

void VertexPrint(FILE *out, VERTEX *vertex)
{
	fprintf(out, "("); PointPrint(out, *(vertex->point)); fprintf(out, ")");
	if (vertex->normal) {
		fprintf(out, "/("); VectorPrint(out, *(vertex->normal)); fprintf(out, ") ");
	} else
		fprintf(out, "/(geen normaal) ");

	fprintf(out, "color = ("); COLORPrint(out, vertex->color); fprintf(out, "), ");

	fprintf(out, "patches: "); 
	PatchListIterate1B(vertex->patches, PatchPrintID, out);
	fprintf(out, "\n");
}


