/* tvertelim.h: T vertex eliminatie */

#ifndef _TVERTELIM_H_
#define _TVERTELIM_H_

#include "vertex.h"

typedef struct TPATCH {
	struct VERTEX *tvertex[3];
} TPATCH;

#include "List.h"

typedef struct TPATCHLIST {
	struct TPATCH *tpatch;
	struct TPATCHLIST *next;
} TPATCHLIST;

#define TPatchListCreate	(TPATCHLIST *)ListCreate

#define TPatchListAdd(tpatchlist, tpatch)	\
        (TPATCHLIST *)ListAdd((LIST *)tpatchlist, (void *)tpatch)

#define TPatchListCount(tpatchlist) \
        ListCount((LIST *)tpatchlist)

#define TPatchListGet(tpatchlist, index) \
        (TPATCH *)ListGet((LIST *)tpatchlist, index)

#define TPatchListDuplicate(tpatchlist) \
        (TPATCHLIST *)ListDuplicate((LIST *)tpatchlist)

#define TPatchListNext(ptpatchlist) \
        (TPATCH *)ListNext((LIST **)ptpatchlist)

#define TPatchListMerge(tpatchlist1, tpatchlist2) \
        (TPATCHLIST *)ListMerge((LIST *)tpatchlist1, (LIST *)tpatchlist2);

#define TPatchListRemove(tpatchlist, tpatch) \
        (TPATCHLIST *)ListRemove((LIST *)tpatchlist, (void *)tpatch)

#define TPatchListIterate(tpatchlist, proc) \
        ListIterate((LIST *)tpatchlist, (void (*)(void *))proc)

#define TPatchListIterate1A(tpatchlist, proc, data) \
        ListIterate1A((LIST *)tpatchlist, (void (*)(void *, void *))proc, (void *)data)

#define TPatchListIterate1B(tpatchlist, proc, data) \
        ListIterate1B((LIST *)tpatchlist, (void (*)(void *, void *))proc, (void *)data)

#define TPatchListDestroy(tpatchlist) \
        ListDestroy((LIST *)tpatchlist)

#define TPatchListPrint(fp, tpatchlist) \
        TPatchListIterate1B(tpatchlist, TPatchPrint, fp);

extern void TPatchDestroy(TPATCH *tpatch);

#include <stdio.h>
extern void TPatchPrint(FILE *fp, TPATCH *tpatch);

#include "patch.h"
extern void PatchElimTVertices(struct PATCH *patch);

extern void EliminateTVertices(void);
extern void SetTVertexElimination(int bool);
extern int GetTVertexElimination(void);

#endif /* _TVERTELIM_H_ */
