/* pex.h */

#ifndef _pex_H_
#define _pex_H_

#include <stdio.h>
#include <math.h>
#include <X11/PEX5/PEXlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xlib.h>

/* Version and subset macros. */
#define VERSION_5_0( info ) \
    ( (info)->major_version == 5 && (info)->minor_version == 0)

#define VERSION_5_1( info ) \
    ( (info)->major_version == 5 && (info)->minor_version == 1)

#define STRUCTURE_SPT( info ) \
    (   ( VERSION_5_0( info ) && \
	( ((info)->subset_info & 0xFFFF) == PEXCompleteImplementation ) ) \
     || ( VERSION_5_1( info ) && \
	( ((info)->subset_info & 0xFFFF) == PEXCompleteImplementation \
	    || (info)->subset_info & PEXStructureMode ) ) \
    )

#define IMMED_MODE_SPT( info ) \
    ( ((info)->subset_info & 0xFFFF) == PEXCompleteImplementation \
	    || (info)->subset_info & PEXImmediateMode )
	
#define SET_COLOR( r, g, b, c ) { \
	(c).rgb.red = (r); \
	(c).rgb.green = (g); \
	(c).rgb.blue = (b);}

/* HLHSR capabilities: */
#define HLHSR_ZBUFFER		1
#define HLHSR_PAINTERS		2
#define HLHSR_SCANLINE		4
#define HLHSR_HIDDENLINEONLY	8
#define HLHSR_ZBUFFERID	       16

#define VIEW_INDEX	1
#endif /*_pex_H_*/




