/* hrefine.h: hierarchical refinement */

#ifndef _HREFINE_H_
#define _HREFINE_H_

#include "interaction.h"

/* stel een bepaalde orakel funcite in: deze functie geeft TRUE terug als
 * de fout die gemaakt wordt door lichttransport over de gegeven interactie 
 * te berekenen aanvaardbaar is en FALSE indien niet. In dat laatste geval
 * wordt de interactie verder verfijnd. */
extern void SetOracle(int (*Oracle)(INTERACTION *));

/* verfijnt alle interacties van de patch (en zijn subpatches - recursief) */
extern void PatchRefineInteractions(PATCH *P);

/* deze functie gaat in tegenstelling tot ToplevelLink() (in radiance.c) wel na of 
 * de patches nog niet gelinked zijn. */
extern INTERACTION *Link(PATCH *P, PATCH *Q);

#endif /*_HREFINE_H_*/

