/* error.h: afdrukken van waarschuwingen, fouten, fatale fouten  */

#ifndef _ERROR_H_
#define _ERROR_H_

/* stel toestand "geen fouten gebeurd" in */
extern void ErrorReset(void);

/* geeft FALSE terug als er geen fouten zijn gebeurd, TRUE anders */
extern int ErrorOccured(void);

/* drukt een foutenboodschap af.
 * argumenten: naam van de routine waar de fout gebeurde, of NULL indien niet
 * relevant en de rest zoals printf */
extern void Error(char *routine, char *text, ...);

/* drukt een waarschuwing af */
extern void Warning(char *routine, char *text, ...);

/* 
 * Drukt een fatale foutenboodschap af en beeindigt het programma. 
 * eerste argument is een foutencode waarmee het programma verlaten moet 
 * worden. Conventie: errcode < 0 ===> fout in het programma.
 * 
 * Foutencodes:
 *	-1: een onmogelijke situatie doet zich voor 
 *	-2: een datastructuur lijkt om zeep 
 *
 *       1: fouten bij het (re)alloceren van geheugen
 */
extern void Fatal(int errcode, char *routine, char *text, ...);

/* geeft FALSE terug indien er geen fouten gebeurd zijn sinds de laatste
 * oproep naar deze funtie en TRUE anders. */
extern int ErrorOccurred(void);

#endif /*_ERROR_H_*/
