.\" @(#)popi.man 1.2 91/12/30
.\"OPTIONS man
.TH POPI 1L "30 December 1991"
.tr @"
.\"These macros always explicitly return to font 1, rather than the
.\"previous font, because previous may have been altered.
.de C
.\" Start constant width
.sp 0.5
.nf
.po +2c
.ft CW
..
.\" End constant width
.de E
.sp 0.5
.po
.ft 1
.fi
..
.de CW
\&\f(CW\\$1\&\f1\\$2\&
..
.ie t .ds Mu \(mu
.el .ds Mu x
.ie t .ds +- \(+-
.el .ds +- +-
.\"-------------------------------------------------------------------------
.SH NAME
popi \- perform interactive digital image transformations
.SH SYNOPSIS
.B "popi [option] ... [file] ..."
.SH DESCRIPTION
.I Popi
is a program which allows arbitrary transformations to be
interactively applied to digital images.
It is based on the program described in "Beyond Photography
\- The Digital Darkroom" by Gerald J. Holzmann.
.P
The meanings of the available command line options are as follows:
.TP
.BI \-a\-
Turn auto-display off.
Equivalent to the
.CW ":display \-"
command.
Images can still be displayed explicitly with the
.CW ":display \f2image\fP"
command.
.TP
.BI \-a+
Turn auto-display on.
After each image transformation, the image will be displayed.
Equivalent to the
.CW ":display +"
command (default).
.TP
.BI \-C
Display results in color (RGB). Assumes a color screen otherwise results
will be displayed in monochrome by half-toning. If the color screen is only
8 bits deep, then the RGB image is appropriately dithered.
Equivalent to the
.CW :color
command (default).
.TP
.BI \-D [debugfile]
Enable debugging information to the named file, or stderr if no name is
given.
.TP
.BI \-G
Display results in grayscale. Assumes a color screen otherwise results will
be displayed in monochrome by half-toning.
Equivalent to the
.CW :grayscale
command.
.TP
.BI \-i
Start up the graphics window iconically (if appropriate).
.TP
.BI \-l [logfile]
Enables logging of all input, error messages, and some
responses.
Logging is done on the named file, or the file "popi.log" if no
name is given.
The
.CW ":logfile"
command may also be used to turn logging on and off.
.TP
.BI \-M
Display results in monochrome via half-toning.
Equivalent to the
.CW :monochrome
command.
.TP
.BI \-O
Overwrite image to screen (that is, don't clear the screen at the start)
(supported on HP).
.TP
.BI \-o
Save images to disk in the old popi format.
.TP
.BI \-p [ncpus]
On a Sequent multiprocessor, use the specified number of cpus
to perform the transform.
If this option is given without a number, the maximum number
available is used.
This option has no effect on uniprocessor computers.
.TP
.BI \-r+
Set the range checking flag on.
Do range checking (default).
.TP
.BI \-r-
Set the range checking flag off.
Don't do range checking.
.TP
.BI \-s+
Set the signed I/O flag on.
Do signed I/O.
.TP
.BI \-s-
Turn the signed I/O flag off.
Do unsigned I/O (default).
.TP
.BI \-t+
Set the trig caching flag on.
Cache trig values in /usr/tmp/popi.X.Y, where X and Y are the size
limits for the current popi run.
(This speeds up the first use of polar co-ordinates in each run.)
.TP
.BI \-t-
Turn the trig caching flag off.
Don't do trig caching (default).
.TP
.BI \-V
Print program version identification message and exit.
.TP
.BI \-v+
Set the verbose flag on.
Be chatty about a number of things.
.TP
.BI \-v\-
Turn the verbose flag off.
Be silent about everything except error messages (default).
.TP
.BI \-X Xoffset
Offset the image by
.I Xoffset
from the left edge of the screen (supported on HP driver).
.TP
.BI \-x Width
Set the initial image width (number of pixels per scanline) to
.I Width
(default 512). Note that this will adjust if larger images are read in.
.TP
.BI \-Y Yoffset
Offset the image by
.I Yoffset
from the top edge of the screen (supported on HP driver).
.TP
.BI \-y Height
Set the initial image height (number of scanlines) to
.I Height
(default 512). Note that this will adjust if larger images are read in.
.TP
.BI \-z Depth
Set the image depth (number of brightness levels) to
.I Depth
(default 256).
.SH SYNTAX
.P
An image transform is described by a transform statement.
The statement basically takes the form
.C
\f2dest\fP = \f2expression\fP
.E

where
.I dest
indicates the new image and
.I expression
describes a transformation.
This statement is executed over the range of image
coordinates.
For a 512 \*(Mu 512 image, it will be executed 262144 times.
An image is normally referenced in a statement by its name
and an index.
A cartesian index is specified by using the x and y
coordinates in square brackets after the image name.
Thus
.CW dmr[0,0]
is the top left pixel in the image named
.CW dmr .
Polar coordinates may be specified by giving a radius and
angle (in degrees) in curly brackets.
Thus
.CW dmr{0,0}
refers to the centre pixel in the
image.
The symbols
.CW x
and
.CW y
may appear in the transform statement.
These take on values corresponding to a different pixel each
time the transform is executed.
Internally the algorithm is as follows
.sp 0.5
.nf
for y varying from 0 to Y
    for x varying from 0 to X
        execute transform statement
.sp 1.5
.fi

where
.CW Y
is the maximum y coordinate and
.CW X
is the maximum x coordinate.
The image size can be set on the command line as described
later.
.P
The value of a pixel varies from 0 to 255 in the current
implementation.
Any value outside this range is treated as modulo 256 when
being stored in an image (ie. it wraps around).
Low numeric values represent dark colours, while large values
represent light colours.
A simple transform statement to set an image to completely
black would be
.C
new[x,y] = 0        ; set image to black
.E

The name
.CW new
is one of the two default images always maintained internally.
The other is
.CW old .
The images referred to by these names are swapped after each
operation, so a succession of transforms may modify the "old"
image to produce a "new" image.
Thus the statement
.C
new[x,y] = old[x,y] / 2      ; darken image
.E

will reduce all the pixel intensity values by a half,
darkening the existing image.
The semicolon (`;') character introduces a comment.
Anything from this to the end of the line is ignored.
.P
All the standard arithmetic, relational and boolean operators
from the C language are available, with precedence generally
as per the C language.
Some additional operators, predefined variables and math
functions are also available.
.P
Here is a listing of the available symbols and their
meanings.
.TP
\f2name\fP
Refers to an image name.
If not followed by index brackets, the index
.CW "[x,y]"
is assumed.
The currently available names are those shown by the
.CW :list
display, and also
.CW old
and
.CW new .
.TP
.CW $\f2n\fP
Where \f2n\fP is a digit, this is an alternative method of
referring to an image.
In fact this may be the only method if the image name contains
punctuation characters.
The
.CW :list
command shows the correspondence between image names and this
form of reference.
.TP
.CW X
The maximum x coordinate value.
This is one less than the number of pixels per scanline
(image width), which may be set with the
.B \-x
command line option.
.TP
.CW Y
The maximum y coordinate value.
This is one less than the number of scanlines (the height of
the image), which may be set with the
.B \-y
command line option.
.TP
.CW x
The current cartesian x coordinate.
Varies from 0 (left of image) to 
.CW X
(right of image).
.TP
.CW y
The current cartesian y coordinate.
Varies from 0 (top of image) to
.CW Y
(bottom of image).
.TP
.CW r
The radius component of the polar coordinate which corresponds to the
current cartesian (x,y) coordinate.
This is equivalent to
.CW "sqrt(x*x + y*y)"
with a translation of the origin.
.TP
.CW a
The angle component of the polar coordinate which corresponds to the
current cartesian (x,y) coordinate.
This is equivalent to (and a shorthand for)
.CW "atan(y/x)" .
.sp
Note that the first time in a popi session you use an expression with either
.CW r
or
.CW a
in it, you may notice an extra delay before the image
transformation begins.
This is due to precalculation of an array of polar coordinates
that happens the first time you use one.
.TP
.CW R
The maximum radius value of a polar coordinate.
.TP
.CW A
The maximum angle value of a polar coordinate (this is just 360).
.TP
.CW Z
The maximum intensity value of a pixel (corresponding to white).
Currently, this is always 255.
.TP
.CW **
The exponentiation (raise to the power) operator.
The expression
.CW "x ** 2"
means x squared (x * x).
.TP
.CW *
The multiplication operator.
This has a higher precedence than division to avoid underflow
in expressions with multiplication and division, since normally
expressions are evaluated as integers.
.TP
.CW /
Integer division.
If the divisor is 0, the result is set to Z.
.TP
.CW %
Modulo.
If the divisor (right hand operand) is 0, the result is set to 0.
.TP
.CW "+"
Addition.
.TP
.CW "\-"
Subtraction.
This may be a unary or a binary operator.
.TP
.CW "<<"
Left shift.
The left operand is shifted left the number of bits specified by the
right operand.
.TP
.CW ">>"
Right shift.
The left operand is shifted right the number of bits specified by the
right operand.
.TP
.CW ">"
Greater than.
As with all the relational operators, if the specified relation between
the operands is true, the result is 1, otherwise the result is 0.
.TP
.CW "<"
Less than.
.TP
.CW ">="
Greater than or equal to.
.TP
.CW "<="
Less than or equal to.
.TP
.CW "=="
Test for equality.
.TP
.CW "!="
Not equal to.
.TP
.CW "&"
Bitwise (arithmetic) AND operator.
.TP
.CW "^"
Bitwise exclusive OR (XOR) operator.
.TP
.CW "|"
Bitwise (arithmetic) OR operator.
.TP
.CW "&&"
Logical AND operator.
The result is 1 if both of the operands are true (non-zero);
otherwise the result is 0.
Unlike the && operator of the C language, this operator is currently not
conditional.
Both operands are always evaluated.
.TP
.CW "||"
Logical OR operator.
The result is 1 if both either (or both) of the operands are true
(non-zero); otherwise the result is 0.
Unlike the || operator of the C language, this operator is currently not
conditional.
Both operands are always evaluated.
.TP
.CW sin(\f2expr\fP)
This gives the value of the trigonometric sine of the expression,
multiplied by Z.
This is required because all operations are performed with integers.
.TP
.CW cos(\f2expr\fP)
This gives the value of the trigonometric cosine of the expression,
multiplied by Z.
This is required because all operations are performed with integers.
.TP
.CW atan(\f2y-expr\fP,\f2x-expr\fP)
This returns the trigonometric arctangent (inverse tangent) of
.I y-expr/x-expr
in degrees (ie the value returned will be between 0 and 360).
.TP
.CW hypot(\f2x\fP,\f2y\fP)
This returns the hypotenuse (x*x + y*y).
.TP
.CW log(\f2expr\fP)
Returns the natural logarithm of the expression.
.TP
.CW sqrt(\f2expr\fP)
Returns the square root of the expression.
.TP
.CW abs(\f2expr\fP)
Returns the absolute value of the expression.
.TP
.CW rand()
Returns a positive random number.
This will usually be used with the modulo or bitwise AND
operator to restrict the range of the result.
For example,
.C
new[x,y] = old[x,y] + rand() % 20 \- 10
.E

will adjust the brightness levels of each pixel in the old image by a
random amount (up to 10 levels brighter or darker).
.\".TP
.\".CW rand(\f2expr\fP)
.\"Returns a positive random number between 0 and the value of
.\"the parameter.
.\"This is provided as a more efficient alternative to
.\".CW "rand() % \f2expr\fP"
.\"The previous example could thus be rewritten as:
.\".C
.\"new[x,y] = old[x,y] + rand(20) \- 10
.\".E
.SH SPECIAL COMMANDS
Popi supports a number of special commands, each starting with a
.CW :
character.
The current set of commands includes:
.I color,
.I debug,
.I display,
.I free,
.I genepson,
.I genps,
.I grayscale,
.I help,
.I list,
.I logfile,
.I matte,
.I melt,
.I monochrome,
.I ofmt,
.I oil,
.I read,
.I shear,
.I signed,
.I slice,
.I tile,
.I truncate,
.I undo,
.I verbose,
.I version,
and
.I write.
They may be abbreviated to the minimum unambiguous length (e.g., :r).
Their definitions follow:
.TP
.CW ":read @\f2filename\fP@ \f1[\fP\f2image-name\fP\f1]\fP"
Read a raw data file into the named image.
If no image name is specified, the name is derived from the base name
component of the filename.
If the name already exists, that image is overwritten in memory,
otherwise a new image is created.
If the filename does not exist, but the same name with a ".Z"
suffix does exist, it is assumed that the file is compressed
and the "zcat" program is used to read the compressed image.

Note that when the image name defaults to the file name, only
the basename (portion after the last '/' character, if any) is
used to name the image.
If this resulting name starts with a digit, or contains any
characters other than alphabetic, digits and the underscore,
you will not be able to reference the image by name, but will
have to use the alternative "$n" syntax.
.TP
.CW ":write @\f2filename\fP@ \f1[\fP\f2image-name\fP\f1]\fP"
Write a raw data file from the named image.
The image name is optional, and
if not specified, image "old" is used.
If the first character of the filename is `|', the rest of the filename
is interpreted as a command to be run, with the raw image data being fed
to it as standard input.
.TP
.CW ":list"
All the named images (other than "old" and "new" are listed).
.TP
.CW ":genps @\f2filename\fP@ \f1[\fP\f2image-name\fP\f1]\fP"
Generate postscript to produce the image.
The image name is optional, and
if not specified, image "old" is used.
The image will be scaled to fit whatever paper size is being used.
As with the
.CW :write
command, if the first character of the filename is a `|' symbol, the
rest of the string will be treated as a command to be executed, with the
postscript being piped to its standard input.
This is convenient for printing images on a PostScript printer.
.TP
.CW :undo
The
.CW old
and
.CW new
images are swapped.
This has the effect of restoring the image that existed
before the last transformation.
.TP
.CW ":genepson @\f2filename\fP@ \f1[\fP\f2image-name\fP\f1]\fP"
Generate data for an Epson (or compatible) printer to produce
the image.
The image name is optional, and if not specified, image "old" is used.
Under MSDOS, the device name can be used directly (eg "PRN").
.sp
The existing code is for a 24-pin printer such as the LQ-500.
To generate data for an 8-pin printer requires a couple of
minor modifications to function
.CW genepson()
in file
.CW special.c .
.TP
.CW ":display \f2image-name\fP"
The named image will be displayed.
This is the fastest way to display an image, and works regardless of the
state of auto-display.
.TP
.CW ":display +"
Turn auto-display on (equivalent to the command-line option
.B \-a+ ).
.TP
.CW ":display \-"
Turn auto-display off (equivalent to the command-line option
.B \-a\- ).
.TP
.CW :color
Display results in color from now on (assuming this is a color screen).
.TP
.CW :grayscale
Display results in grayscale from now on (assuming this is a color screen).
.TP
.CW :monochrome
Display results in monochrome from now on, using half-toning.
.TP
.CW ":truncate +"
All assignments to an image with values outside the range
.CW 0
to
.CW Z
will be truncated to the appropriate boundary, instead of
wrapping as described in the book.
An example of using this feature would be for a simplistic
lightening of an image by adding a constant value.
Normally, very white areas would wrap around and become black,
but enabling truncation prevents this.
.TP
.CW ":truncate \-"
All assignments to an image will be done modulo
.CW "(Z+1)" .
This is the default.
.TP
.CW ":truncate"
Report whether truncation is currently in effect or not.
.TP
.CW ":verbose +"
Turn on verbose mode.
Equivalent to the
.CW "\-v+" command line option.
Certain warning messages will be printed.
This turns on the "percent done" feature of some drivers (on
others it is always active).
.TP
.CW ":verbose \-"
Turn off verbose mode.
Equivalent to the
.CW "\-v\-" command line option.
.TP
.CW ":verbose"
Report the state of the verbose flag.
.TP
.CW ":signed +"
All file I/O is done in signed (2's complement) mode.
.TP
.CW ":signed \-"
All file I/O is done in unsigned mode.
This is the default.
.TP
.CW ":signed"
Report the state of the signed I/O flag.
.TP
.CW ":ofmt +"
The old popi format is used for output files.
.TP
.CW ":ofmt \-"
The new popi format is used for output files.
This is the default.
.TP
.CW ":ofmt"
Report the state of the output format flag.
.TP
.CW ":logfile +"
Enable logging on the current log file (default "popi.log").
If logging is already enabled, the file is closed and re-opened
with a new timestamp appended.
.TP
.CW ":logfile \-"
Disable logging"
.TP
.CW ":logfile @\f2filename\fP@"
Enable logging on the specified file.
.sp
Whenever a log file is opened, it is always opened in append
mode, so existing data is never truncated.
Upon opening a log file, a timestamp is written.
All user input is logged, along with error messages and some
program responses.
.TP
.CW ":free \f2imagename\fP"
The memory associated with the named image is freed.
Any further access to this image becomes impossible.
This command may be useful in situations where memory is very
limited, such as a PC.
.SH TRANSFORMATIONS
.P
The remaining special commands are used to obtain special built-in
transformations, as described in Chapter 6 of "Beyond Photography".
In each of these cases, the image name is optional, and defaults to
"old".
In each case (except for
.CW :melt ),
the result is stored in "new", and then "old" and "new" are swapped as
usual.
In the case of
.CW :melt ,
the transformation is done in place and no swap occurs.
.TP
.CW ":oil [\f2image-name\fP]"
.TP
.CW ":shear [\f2image-name\fP]"
.TP
.CW ":slice [\f2image-name\fP]"
.TP
.CW ":tile [\f2image-name\fP]"
.TP
.CW ":melt [\f2image-name\fP]"
.TP
.CW ":matte [\f2image-name\fP [\f2gamma\fP]]"
In this case,
.I gamma
is an optional floating point number (defaults to 7.5).
See the book for details.
.SH DIFFERENCES
There are a number of differences between the Pico interpreter, for
which the examples in the book are written, and the Popi interpreter as
implemented here.
.P
Integer evaluation stack.
The current version of the interpreter has an integer evaluation stack.
For this reason, the
.CW sin()
and
.CW cos()
functions, have their results multiplied by Z automatically in order to
be significant.
A future version of the interpreter will provide the option for a
floating point stack, and a syntax which will handle both cases.
.P
Polar coordinates.
In the book, both cartesian and polar coordinates are specified with
square brackets.
The decision of whether to interpret the indices as polar or cartesian
is based on context;
if the symbols
.CW r
and
.CW a
are used in the index expressions, the coordinates are interpreted as
polar, otherwise they are interpreted as rectangular.
Thus, in order to use a radius or angle in a cartesian coordinate
expression, it must be cast, as is done on page 48 of the book.
By providing a separate syntax for polar and cartesian coordinate
references, the problem never occurs.
.SH EXAMPLES
These examples are mainly taken from the book, with syntax modifications
where required.
The images in the book are usually 1000 \*(Mu 1000 pixels.
To produce the same results on a smaller image, you may need to multiply
any occurences of
.CW x ,
.CW y
and
.CW r
by an appropriate scaling factor.
The first example image generation in the book is
.C
new[x,y] = x + y  ; page 17 (3.1)
.E

which produces a number of diagonal stripes, each fading from black to
white.
On a 512 \*(Mu 512 image, to get the same number of stripes, use the
transform
.C
new[x,y] = x*2 + y*2
.E


A series of ripples can be produced with
.C
new[x,y] = (x * y) % (Z + 1)  ; page 18 (3.2)
.E

or more simply, because all brightness values are inherently modulo
.CW "(Z + 1)"
unless truncation is turned on
.C
new[x,y] = x * y
.E


A single smooth transition can be accomplished with
.C
new[x,y] = (Z * x * y) / ((X\-1) * (Y\-1))  ; page 18 (3.3)
.E


The transformation
.C
new[x,y] = x % y
.E

is the same as
.CW "new[x,y] = x"
when
.CW "x < 0"
(ie in the lower left triangle of the image, with a different effect in
the upper right half.
.P
The trig functions allow transforms such as
.C
new[x,y] = y + sin(x) / 2  ; page 19 (3.5)
.E

which produce a series of sine waves (remember that the range of
.CW "sin(x)"
is
.CW "\*(+-Z" .
.P
An image reminiscent of a radar sweep can be produced by
.C
new[x,y] = atan(y \- Y/2, x \- X/2) * Z / 360  ; page 19 (3.6)
.E


The
.CW atan()
function has a range of 0 .. 360, so the
.CW "*Z/360"
rescales to 0 ..
.CW Z .
This transform is overall providing an intensity relative to the angle
of a point in polar coordinates.
The transform language provides the current angle as the variable
.CW a ,
so this statement can be rewritten as
.C
new[x,y] = a * Z / 360
.E


Polar coordinates can be used to produce an image which varies from
black in the centre to white on the outside
.C
new[x,y] = r * Z / R  ; page 21 (3.11)
.E

or a spiraling effect
.C
new[x,y] = (((a + r) % 16) \- 8) * Z / 16 + Z/2  ; page 21 (3.12)
.E


The conditional operator can be used to provide a filled black circle
.C
new[x,y] = r > R/2 ? 0 : Z
.E

or black and white patterns such as
.C
new[x,y] = ((x % (5 + y/25)) > 5) ? 0 : Z  ; page 20 (3.9)
new[x,y] = (Z * abs(x % sin(y)) > 10) ? 0 : Z  ; page 20 (3.10)
.E


.P
We can also modify existing images using these transforms.
The previous image can always be referred to as
.CW old ,
or an explicitly named image can be used.
We can read an image (eg of Dennis Ritchie) using
.C
:read "dmr"  ; read the image in the file "dmr" and name it dmr.
.E

and then use it in a transform, such as
.C
new[x,y] = Z \- dmr[x,y]  ; page 22 (3.13)
.E

This produces a negative, which can be written to a file with
.C
:write "dmr_neg"
.E

or converted to PostScript and printed with
.C
:genps "| lp \-dalw"
.E


Since the
.CW new
image built during a transformation becomes the
.CW old
image of the following transform,
the negative image can be re-reversed to produce the original with
.C
new[x,y] = Z \- old[x,y]  ; reverse the process
.E


In the following examples, we will use
.CW old
in most of the transforms, rather than a particular image name.
In practice, you would probably use a specifically named image instead.
.P
Provide a circular frame for an image
.C
new[x,y] = r > R/2 ? 0 : old[x,y]
.E


A solarisation process, that fades in from left to right
.C
new[x,y] = (old[x,y] > (Z*x) / (2 * X)) ? old[x,y] : Z\-old[x,y]  ; page 22 (3.16)
.E


Generate a relief map
.C
new[x,y] = old[x,y] + (Z/2 \- old[x+2,y+2])  ; page 24 (3.19)
.E


Shrink an image
.C
new[x,y] = old[x*2,y*2]  ; page 25 (3.24)
.E


.P
An interesting caricature is produced by
.C
new[x,y] = old{sqrt(r * R),a}  ; page 34
.E


Note the use of polar coordinates.
The reverse transform gives a fisheye lens effect:
.C
new[x,y] = old{(r*r)/R, a}  ; page 60
.E


The following transform illustrates how an expression can be used for
the indices of the destination matrix.
.C
new[x, y\-old[x,y]/4] = old[x,y]  ; page 40
.E


An image can be swirled about the centre with
.C
new[x,y] = old{r, a + r/3}
.E


The following transform uses polar coordinate values in a cartesian
reference, resulting in something that looks like what you'd see in a
cylindrical mirror
.C
new[x,y] = old[a * X/A, r * Y/R]  ; page 48
.E


The image generated by
.C
new[x,y] = old{ (r/16)*16, (a/16)*16 }  ; page 72
.E

is very interesting, in that it is completely unrecognisable
when viewed up close, but from a distance of a few metres it
will resolve into the original.
.C
new[x,y] = old{r, a + old{r,a}/8}  ; page 68
.E


This image is a swirl, but with the skew dependant on the
brightness of the current point.
.C
new[x,y] = x < X/2 ? old[x,y] : old[X-x,y]
new[x,y] = x > X/2 ? old[x,y] : old[X-x,y]
.E


These transformations do a horizontal mirror reversal about the
centre of the image.
Because faces are usually close to, but not exactly, centered,
this transform of a face can be interesting.
.C
new[x,y] = old[x+(x%32)-16, y]  ; page 58
new[x,y] = old[x+((a+r/10)%32)-16, y]
.E

These transforms applied to a face produce what looks like
someone peering through a bathroom window.
.tr @@
.SH DRIVERS
.TP
.CW nulldev
The null device driver is mainly for people with no graphics
display device for which a driver exists.
Using this device, data for a PostScript or Epson printer can
still be generated.
.TP
.CW atariterm
The atari driver is for use with "TERM", a multiplexing
terminal program for the Atari ST, written by Peter Collinson
of the University of Kent at Canterbury.
It is not a driver for running native on an atari.
.TP
.CW kermit
This is a driver for MS-Kermit 2.32 on an IBM PC, which is capable of
emulating a Tektronix 4010. This provides three levels of contrast
(nothing, normal and bold).
.TP
.CW MGR
This driver is for the Bell Core MGR window system. It is visually
identical to the SunView version, but is currently hardwired to
monochrome.
.TP
.CW NeWS
This is the driver that will work with NeWS v1.1 and OpenWindows v1.0.
It is also visually identical to the SunView version.
.TP
.CW pcturbo
This is a driver for running popi native on a PC with
Borland's Turbo C compiler.
It uses the graphics library supplied with Turbo C, which
auto-detects most types of graphics display.
No attempt at using a colourmap is done \- a single display
dot is used for each image pixel, with simple dithering.
Only directly accesible memory is used, which drastically
restricts the size of images that can be handled.
.TP
.CW SunView
This driver works with the SunView graphics package available on Sun
workstations. This uses a scrollable command window which allows
line editing, cutting and pasting. The image canvas is a separate
window on the correct size. The output is in colour on 24-bit colour
machines, in 256 grayscale on 8-bit colour machines,
and an 8\*(Mu8 dither on monochrome screens.
.TP
.CW X11
This driver is the initial version to work with MIT's X11 window system.
This currently has minimal functionality. The output is in 256
grayscales on colour machines, and an 8\*(Mu8 dither on monochrome screens.
.TP
.CW XView
A conversion of the original SunView graphics driver to use the XView X11
toolkit. This driver is visually identical to the X11 version. This driver
will be rewritten to be identical with the new SunView graphics driver.
.SH IMAGE FORMAT
.I popi
use the portable graymap file format for the grayscale images, and the portable
pixmap file format for its color images. These image formats are an integral
part of the
.I PBMPLUS
extended portable bitmap toolkit distributed by Jef Poskanzer. See the
.I README
file, for the copyright notices associated with this package.
.LP
.I popi
will automagically read images in the old format, but if you have any such
images, it is recommended that they be converted to pgm files using the small
.I popitopgm
filter included with this package, as this format may no longer be supported
in future releases. It is also recommended that you get a copy of the
.I PBMPLUS
toolkit.
.I popitopgm
takes an old popi image on standard input, and writes a pgm file to standard
output. There are two command line options that might be applicable for your
image conversion:
.sp 0.5
.nf
-x nnn  -  the width of the image in pixels.
-y nnn  -  the height of the image in pixels.
.sp 1.5
.fi
The program defaults these values to 512 if they aren't given.
.LP
The definition of the portable graymap format is as follows:
.IP - 2
A "magic number" for identifying the file type.
A pgm file's magic number is the two characters "P2".
.IP - 2
Whitespace (blanks, TABs, CRs, LFs).
.IP - 2
A width, formatted as ASCII characters in decimal.
.IP - 2
Whitespace.
.IP - 2
A height, again in ASCII decimal.
.IP - 2
Whitespace.
.IP - 2
The maximum gray value, again in ASCII decimal.
.IP - 2
Whitespace.
.IP - 2
Width * height gray values, each in ASCII decimal, between 0 and the specified
maximum value, separated by whitespace, starting at the top-left
corner of the graymap, proceding in normal English reading order.
A value of 0 means black, and the maximum value means white.
.IP - 2
Characters from a "#" to the next end-of-line are ignored (comments).
.IP - 2
No line should be longer than 70 characters.
.PP
Here is an example of a small graymap in this format:
.PP
.nf
P2
# feep.pgm
24 7
15
0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
0  3  3  3  3  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15 15 15 15  0
0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0 15  0
0  3  3  3  0  0  0  7  7  7  0  0  0 11 11 11  0  0  0 15 15 15 15  0
0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0  0  0
0  3  0  0  0  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15  0  0  0  0
0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
.fi
.PP
Programs that read this format should be as lenient as possible,
accepting anything that looks remotely like a graymap.
.PP
There is also a variant on the format, available
by setting the RAWBITS option at compile time.  This variant is
different in the following ways:
.IP - 2
The "magic number" is "P5" instead of "P2".
.IP - 2
The gray values are stored as plain bytes, instead of ASCII decimal.
.IP - 2
No whitespace is allowed in the grays section.
.IP - 2
The files are smaller and many times faster to read and write.
.PP
Note that this raw format can only be used for maxvals less than
or equal to 255.
.LP
The definition of the portable pixmap format is as follows:
.IP - 2
A "magic number" for identifying the file type.
A ppm file's magic number is the two characters "P3".
.IP - 2
Whitespace (blanks, TABs, CRs, LFs).
.IP - 2
A width, formatted as ASCII characters in decimal.
.IP - 2
Whitespace.
.IP - 2
A height, again in ASCII decimal.
.IP - 2
Whitespace.
.IP - 2
The maximum color-component value, again in ASCII decimal.
.IP - 2
Whitespace.
.IP - 2
Width * height pixels, each three ASCII decimal values between 0 and the
specified maximum value, starting at the top-left
corner of the pixmap, proceding in normal English reading order.
The three values for each pixel represent red, green, and blue, respectively;
a value of 0 means that color is off, and the maximum value means that color
is maxxed out.
.IP - 2
Characters from a "#" to the next end-of-line are ignored (comments).
.IP - 2
No line should be longer than 70 characters.
.PP
Here is an example of a small pixmap in this format:
.PP
.nf
P3
# feep.ppm
4 4
15
 0  0  0    0  0  0    0  0  0   15  0 15
 0  0  0    0 15  7    0  0  0    0  0  0
 0  0  0    0  0  0    0 15  7    0  0  0
15  0 15    0  0  0    0  0  0    0  0  0
.fi
.PP
Programs that read this format should be as lenient as possible,
accepting anything that looks remotely like a pixmap.
.PP
There is also a variant on the format, available
by setting the RAWBITS option at compile time.  This variant is
different in the following ways:
.IP - 2
The "magic number" is "P6" instead of "P3".
.IP - 2
The pixel values are stored as plain bytes, instead of ASCII decimal.
.IP - 2
Whitespace is not allowed in the pixels area.
.IP - 2
The files are smaller and many times faster to read and write.
.PP
Note that this raw format can only be used for maxvals less than
or equal to 255.
.SH SEE ALSO
ipscript(1L), imavg(1L).
.SH AUTHOR
Gerald J. Holzmann, AT&T Bell Laboratories, Murray Hill, New
Jersey.
.sp
Modifications and additional functionality, Atari, PC, PostScript,
Epson and null drivers by
Stephen Frede, Softway Pty Ltd, Australia.
.sp
Popi maintainance, SunView, X11, NeWS, MGR and XView graphics drivers by
Rich Burridge, Sun Microsystems, Australia.
.sp
Kermit graphics driver by
Frank Crawford, Q.H. Tours.
.sp
Amiga graphics driver by
Peter Chubb, Softway Pty Ltd, Australia.
.sp
Apollo driver by
Tim Lambert, University of New South Wales.
.sp
HP driver by Eric Haines, 3D/Eye Inc, Ithaca, NY.
.sp
Popi efficiency changes and improvements to the PC driver by Russ Nelson,
Clarkson University.
.sp
Color support, signed/unsigned i/o and 24 bit SunView support by Rich Morin,
Canta Forda Computer Laboratory.
.sp
Popi yacc grammar based on the yacc grammar used by Byron Rakitzis in his pico
implementation.
.sp
Dithering code taken from xloadimage, which is copyright (c) 1989-1990 by
Kirk L. Johnson, Jim Frost and Steve Losen. See the README file for the
copyright notices associated with this code.
.sp
Popi image i/o routines are based on the PBM/PGM/PPM routines from the
PBMPLUS package, which is copyright (c) 1989 by Jef Poskanzer. See the
README file for the copyright notices associated with this code.
.SH BUGS
Functions which require popen() (ie auto reading of compressed
files and writing to pipes) don't work in the sequent multiprocessor version.
Reading of compressed images in the old format will no longer work, because
you can't seek on the pipe from zcat.
.sp
Probably more \- please notify richb@Aus.Sun.COM of any found, if it's not
already listed in the TODO file.
