#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of shell archive."
# Contents:  makefile polytest.c polyrun polyN00 polyN01 polyN02
#   polyN03 polyN04 polyN05 polyN06 polyN07 polyN08 polyN09 polyN10
#   polyN11 polyN12 polyN13 polyN14 polyN15 polyN16 polyN17 polyY01
#   polyY03 polyY04 polyY05
# Wrapped by hollasch@gamma on Thu Oct 22 09:54:46 1992
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f 'makefile' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'makefile'\"
else
echo shar: Extracting \"'makefile'\" \(64 characters\)
sed "s/^X//" >'makefile' <<'END_OF_FILE'
Xpolytest: polytest.c
X	cc -o polytest polytest.c
X
Xtest:
X	polyrun
END_OF_FILE
if test 64 -ne `wc -c <'makefile'`; then
    echo shar: \"'makefile'\" unpacked with wrong size!
fi
# end of 'makefile'
fi
if test -f 'polytest.c' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polytest.c'\"
else
echo shar: Extracting \"'polytest.c'\" \(3568 characters\)
sed "s/^X//" >'polytest.c' <<'END_OF_FILE'
X#include <stdio.h>
X#include <math.h>
X
X#define EPSILON 1e-15
X
X#define V2op2(X,op,Y) \
X    do { X[0] op Y[0]; X[1] op Y[1]; } while (0)
X
X#define V2op3(X,assign,Y,op,Z) \
X    do { X[0] assign Y[0] op Z[0]; X[1] assign Y[1] op Z[1]; } while (0)
X
X/*****************************************************************************
X**  This routine reads in a stream of 2D polygon coordinates from the input
X**  stream and returns 1 if the resulting closed polygon is convex, otherwise
X**  it returns 0.  The parameter `stream' is a currently open input stream.
X*****************************************************************************/
X
Xint ConvexP (stream)
X    FILE *stream;
X{
X    auto int    looking = 2;		/* Loop Termination Status */
X    auto int    factor = 0;		/* Turn Direction Factor */
X    auto double A[2], B[2], C[2];	/* Current Vertices */
X    auto double oldA[2], oldB[2];	/* First Two Vertices */
X    auto int    xdir, ydir;		/* Current Coordinate Direction */
X    auto int    xturns=0, yturns=0;	/* Coordinate Direction Changes */
X    auto double dot;			/* Dot Product of Edge Norm and Edge */
X    auto double U[2], V[2];		/* Edge Vectors AB and BC */
X
X    /* Read in the first two vertices. */
X
X    if (2 > fscanf (stream, "%lf%lf", B+0, B+1))  return 0;
X
X    do {
X	if (2 > fscanf (stream, "%lf%lf", C+0, C+1))  return 0;
X    } while ((B[0] == C[0]) && (B[1] == C[1]));
X
X    if (feof(stream)) return 0;
X
X    V2op2 (oldA,=,B);		/* Save the first two vertices. */
X    V2op2 (oldB,=,C);
X
X    V2op3 (V,=,C,-,B);		/* Calculate the edge vector V0V1. */
X
X    /* Set the X & Y coordinate directions if possible. */
X
X    xdir = (B[0] < C[0]) ? 1 : (B[0] > C[0]) ? -1 : 0;
X    ydir = (B[1] < C[1]) ? 1 : (B[1] > C[1]) ? -1 : 0;
X
X    do	/* Shift the last two vertices and read in the next vertex. */
X    {
X	V2op2 (A,=,B);
X	V2op2 (B,=,C);
X
X	do
X	{   switch (looking)
X	    {   case 2:
X		    if (2 > fscanf (stream, "%lf%lf", C+0, C+1))
X		    {   looking = 1;
X			V2op2 (C,=,oldA);
X		    }
X		    break;
X
X		case 1:
X		    looking = 0;
X		    V2op2 (C,=,oldB);
X		    break;
X		
X		case 0:
X		    return 1;
X	    }
X	} while ((C[0] == B[0]) && (C[1] == B[1]));
X
X	V2op2 (U,=,V);
X	V2op3 (V,=,C,-,B);	/* Calculate the edge vector from B to C. */
X
X	/* Get the dot product of the normal to edge AB and the vector BC.
X	** Compare this result with the previous dot products.  As long as
X	** the sign is the same as the previous ones (or zero), then
X	** everything's cool, otherwise we found a dent in the polygon, so
X	** return 0.  */
X
X	dot = (U[0] * V[1]) - (U[1] * V[0]);
X	if (fabs(dot) < EPSILON)
X	    dot = 0.0;
X	else
X	{   if (!factor)
X		factor = (dot < 0.0) ? -1 : 1;
X	    else if ((factor < 0) ^ (dot < 0.0))
X		return 0;
X	}
X
X	/* Check the X coordinate delta.  For a simple polygon, this can
X	** change sign (direction) twice, but no more. */
X
X#       define CHECK_DIRECTION(P,Q,dir,turns) \
X	    do { \
X		if (P < Q) \
X		{   if (dir == -1) \
X		    {   ++turns; \
X			if (dot == 0.0) return 0; \
X		    } \
X		    dir =  1; \
X		} \
X		else if (P > Q) \
X		{   if (dir ==  1) \
X		    {   ++turns; \
X			if (dot == 0.0) return 0; \
X		    } \
X		    dir = -1; \
X		} \
X	    } while (0)
X
X	CHECK_DIRECTION (B[0],C[0], xdir, xturns);
X	if (xturns > 2) return 0;
X
X	CHECK_DIRECTION (B[1],C[1], ydir, yturns);
X	if (yturns > 2) return 0;
X
X    } while (looking);
X
X    return 1;	/* All tests passed; polygon is simple and convex. */
X}
X
X
X
Xint main ()
X{
X    if (ConvexP (stdin))
X    {   printf ("Polygon is convex.\n");
X	exit (0);
X    }
X    else
X    {   printf ("Polygon is not convex.\n");
X	exit (1);
X    }
X}
END_OF_FILE
if test 3568 -ne `wc -c <'polytest.c'`; then
    echo shar: \"'polytest.c'\" unpacked with wrong size!
fi
# end of 'polytest.c'
fi
if test -f 'polyrun' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyrun'\"
else
echo shar: Extracting \"'polyrun'\" \(350 characters\)
sed "s/^X//" >'polyrun' <<'END_OF_FILE'
X#!/bin/csh
X
Xforeach file (polyN*)
X    echo ""
X    echo $file
X    polytest < $file
X    if ($status) then
X	echo "Pass.";
X    else
X	echo "Fail."
X	exit 1
X    endif
Xend
X
Xforeach file (polyY*)
X    echo ""
X    echo $file
X    polytest < $file
X    if ($status) then
X	echo "Fail.";
X	exit 1
X    else
X	echo "Pass."
X    endif
Xend
X
Xecho "=== All tests passed ==="
END_OF_FILE
if test 350 -ne `wc -c <'polyrun'`; then
    echo shar: \"'polyrun'\" unpacked with wrong size!
fi
chmod +x 'polyrun'
# end of 'polyrun'
fi
if test -f 'polyN00' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN00'\"
else
echo shar: Extracting \"'polyN00'\" \(25 characters\)
sed "s/^X//" >'polyN00' <<'END_OF_FILE'
X2 2 
X2 3
X0 0
X5 0
X5 5
X0 5
END_OF_FILE
if test 25 -ne `wc -c <'polyN00'`; then
    echo shar: \"'polyN00'\" unpacked with wrong size!
fi
# end of 'polyN00'
fi
if test -f 'polyN01' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN01'\"
else
echo shar: Extracting \"'polyN01'\" \(48 characters\)
sed "s/^X//" >'polyN01' <<'END_OF_FILE'
X0   0
X-1  4
X-2 -3
X 2  1
X-4  1
X 2 -3
X 1  2
X-4 -2
END_OF_FILE
if test 48 -ne `wc -c <'polyN01'`; then
    echo shar: \"'polyN01'\" unpacked with wrong size!
fi
# end of 'polyN01'
fi
if test -f 'polyN02' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN02'\"
else
echo shar: Extracting \"'polyN02'\" \(20 characters\)
sed "s/^X//" >'polyN02' <<'END_OF_FILE'
X0 0
X2 0
X2 2
X1 1
X0 2
END_OF_FILE
if test 20 -ne `wc -c <'polyN02'`; then
    echo shar: \"'polyN02'\" unpacked with wrong size!
fi
# end of 'polyN02'
fi
if test -f 'polyN03' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN03'\"
else
echo shar: Extracting \"'polyN03'\" \(60 characters\)
sed "s/^X//" >'polyN03' <<'END_OF_FILE'
X0 0
X1 0
X2 0
X3 0
X4 0
X5 0
X6 0
X7 0
X8 0
X9 0
X10 0
X10 10
X9 9
X0 10
END_OF_FILE
if test 60 -ne `wc -c <'polyN03'`; then
    echo shar: \"'polyN03'\" unpacked with wrong size!
fi
# end of 'polyN03'
fi
if test -f 'polyN04' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN04'\"
else
echo shar: Extracting \"'polyN04'\" \(60 characters\)
sed "s/^X//" >'polyN04' <<'END_OF_FILE'
X0 10
X9 9
X10 10
X10 0
X9 0
X8 0
X7 0
X6 0
X5 0
X4 0
X3 0
X2 0
X1 0
X0 0
END_OF_FILE
if test 60 -ne `wc -c <'polyN04'`; then
    echo shar: \"'polyN04'\" unpacked with wrong size!
fi
# end of 'polyN04'
fi
if test -f 'polyN05' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN05'\"
else
echo shar: Extracting \"'polyN05'\" \(20 characters\)
sed "s/^X//" >'polyN05' <<'END_OF_FILE'
X0 0
X5 0
X5 5
X1 2
X0 5
END_OF_FILE
if test 20 -ne `wc -c <'polyN05'`; then
    echo shar: \"'polyN05'\" unpacked with wrong size!
fi
# end of 'polyN05'
fi
if test -f 'polyN06' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN06'\"
else
echo shar: Extracting \"'polyN06'\" \(24 characters\)
sed "s/^X//" >'polyN06' <<'END_OF_FILE'
X0 2
X1 -3
X-2 0
X2 0
X-1 -3
END_OF_FILE
if test 24 -ne `wc -c <'polyN06'`; then
    echo shar: \"'polyN06'\" unpacked with wrong size!
fi
# end of 'polyN06'
fi
if test -f 'polyN07' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN07'\"
else
echo shar: Extracting \"'polyN07'\" \(29 characters\)
sed "s/^X//" >'polyN07' <<'END_OF_FILE'
X0 0
X-5 0
X5 5
X0 5
X2 1
X3 2
X2 4
END_OF_FILE
if test 29 -ne `wc -c <'polyN07'`; then
    echo shar: \"'polyN07'\" unpacked with wrong size!
fi
# end of 'polyN07'
fi
if test -f 'polyN08' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN08'\"
else
echo shar: Extracting \"'polyN08'\" \(29 characters\)
sed "s/^X//" >'polyN08' <<'END_OF_FILE'
X-5 0
X5 5
X0 5
X2 1
X3 2
X2 4
X0 0
END_OF_FILE
if test 29 -ne `wc -c <'polyN08'`; then
    echo shar: \"'polyN08'\" unpacked with wrong size!
fi
# end of 'polyN08'
fi
if test -f 'polyN09' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN09'\"
else
echo shar: Extracting \"'polyN09'\" \(20 characters\)
sed "s/^X//" >'polyN09' <<'END_OF_FILE'
X0 0
X2 1
X1 1
X2 1
X0 2
END_OF_FILE
if test 20 -ne `wc -c <'polyN09'`; then
    echo shar: \"'polyN09'\" unpacked with wrong size!
fi
# end of 'polyN09'
fi
if test -f 'polyN10' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN10'\"
else
echo shar: Extracting \"'polyN10'\" \(32 characters\)
sed "s/^X//" >'polyN10' <<'END_OF_FILE'
X0 0
X0 1
X1 1
X1 0
X0 0
X0 1
X1 1
X1 0
END_OF_FILE
if test 32 -ne `wc -c <'polyN10'`; then
    echo shar: \"'polyN10'\" unpacked with wrong size!
fi
# end of 'polyN10'
fi
if test -f 'polyN11' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN11'\"
else
echo shar: Extracting \"'polyN11'\" \(24 characters\)
sed "s/^X//" >'polyN11' <<'END_OF_FILE'
X0 0
X1 0
X1 2
X1 1
X1 2
X0 2
END_OF_FILE
if test 24 -ne `wc -c <'polyN11'`; then
    echo shar: \"'polyN11'\" unpacked with wrong size!
fi
# end of 'polyN11'
fi
if test -f 'polyN12' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN12'\"
else
echo shar: Extracting \"'polyN12'\" \(17 characters\)
sed "s/^X//" >'polyN12' <<'END_OF_FILE'
X0 0
X1 0
X0 1
X0 -1
END_OF_FILE
if test 17 -ne `wc -c <'polyN12'`; then
    echo shar: \"'polyN12'\" unpacked with wrong size!
fi
# end of 'polyN12'
fi
if test -f 'polyN13' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN13'\"
else
echo shar: Extracting \"'polyN13'\" \(25 characters\)
sed "s/^X//" >'polyN13' <<'END_OF_FILE'
X0 0
X1 0
X0 0
X0 1
X0 0
X0 -1
END_OF_FILE
if test 25 -ne `wc -c <'polyN13'`; then
    echo shar: \"'polyN13'\" unpacked with wrong size!
fi
# end of 'polyN13'
fi
if test -f 'polyN14' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN14'\"
else
echo shar: Extracting \"'polyN14'\" \(45 characters\)
sed "s/^X//" >'polyN14' <<'END_OF_FILE'
X0 0
X0 0
X1 0
X0 0
X0 0
X0 1
X0 0
X0 0
X0 -1
X0 0
X0 0
END_OF_FILE
if test 45 -ne `wc -c <'polyN14'`; then
    echo shar: \"'polyN14'\" unpacked with wrong size!
fi
# end of 'polyN14'
fi
if test -f 'polyN15' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN15'\"
else
echo shar: Extracting \"'polyN15'\" \(8 characters\)
sed "s/^X//" >'polyN15' <<'END_OF_FILE'
X0 0
X1 1
END_OF_FILE
if test 8 -ne `wc -c <'polyN15'`; then
    echo shar: \"'polyN15'\" unpacked with wrong size!
fi
# end of 'polyN15'
fi
if test -f 'polyN16' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN16'\"
else
echo shar: Extracting \"'polyN16'\" \(12 characters\)
sed "s/^X//" >'polyN16' <<'END_OF_FILE'
X1 1
X2 2
X3 3
END_OF_FILE
if test 12 -ne `wc -c <'polyN16'`; then
    echo shar: \"'polyN16'\" unpacked with wrong size!
fi
# end of 'polyN16'
fi
if test -f 'polyN17' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyN17'\"
else
echo shar: Extracting \"'polyN17'\" \(24 characters\)
sed "s/^X//" >'polyN17' <<'END_OF_FILE'
X0 0
X1 1
X0 0
X0 0
X0 0
X0 0
END_OF_FILE
if test 24 -ne `wc -c <'polyN17'`; then
    echo shar: \"'polyN17'\" unpacked with wrong size!
fi
# end of 'polyN17'
fi
if test -f 'polyY01' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyY01'\"
else
echo shar: Extracting \"'polyY01'\" \(12 characters\)
sed "s/^X//" >'polyY01' <<'END_OF_FILE'
X0 0
X1 1
X1 0
END_OF_FILE
if test 12 -ne `wc -c <'polyY01'`; then
    echo shar: \"'polyY01'\" unpacked with wrong size!
fi
# end of 'polyY01'
fi
if test -f 'polyY03' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyY03'\"
else
echo shar: Extracting \"'polyY03'\" \(16 characters\)
sed "s/^X//" >'polyY03' <<'END_OF_FILE'
X0 0
X0 1
X1 1
X1 0
END_OF_FILE
if test 16 -ne `wc -c <'polyY03'`; then
    echo shar: \"'polyY03'\" unpacked with wrong size!
fi
# end of 'polyY03'
fi
if test -f 'polyY04' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyY04'\"
else
echo shar: Extracting \"'polyY04'\" \(20 characters\)
sed "s/^X//" >'polyY04' <<'END_OF_FILE'
X0 0
X0 0
X1 0
X1 1
X0 1
END_OF_FILE
if test 20 -ne `wc -c <'polyY04'`; then
    echo shar: \"'polyY04'\" unpacked with wrong size!
fi
# end of 'polyY04'
fi
if test -f 'polyY05' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'polyY05'\"
else
echo shar: Extracting \"'polyY05'\" \(20 characters\)
sed "s/^X//" >'polyY05' <<'END_OF_FILE'
X0 0
X1 0
X1 1
X0 1
X0 0
END_OF_FILE
if test 20 -ne `wc -c <'polyY05'`; then
    echo shar: \"'polyY05'\" unpacked with wrong size!
fi
# end of 'polyY05'
fi
echo shar: End of shell archive.
exit 0
