#include "plplot.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plamiga.h"
#include <libraries/dosextens.h>

#define PLOKGAD    0
#define PLCAGAD    1
#define PLSTGAD    2

static UBYTE Gadget3SIBuff[80];
static struct StringInfo Gadget3SInfo =
{
    Gadget3SIBuff,		/* buffer where text will be edited */
    NULL,			/* optional undo buffer */
    0,				/* character position in buffer */
    80,				/* maximum number of characters to allow */
    0,				/* first displayed character buffer position */
    0, 0, 0, 0, 0,		/* Intuition initialized and maintained variables */
    0,				/* Rastport of gadget */
    0,				/* initial value for integer gadgets */
    NULL			/* alternate keymap (fill in if you set the flag) */
};

static struct Gadget Gadget3 =
{
    NULL,			/* next gadget */
    11, 30,			/* origin XY of hit box relative to window TopLeft */
    158, 9,			/* hit box width and height */
    NULL,			/* gadget flags */
    RELVERIFY + ENDGADGET + STRINGCENTER,	/* activation flags */
    STRGADGET + REQGADGET,	/* gadget type flags */
    NULL,			/* gadget border or image to be rendered */
    NULL,			/* alternate imagery for selection */
    NULL,			/* first IntuiText structure */
    NULL,			/* gadget mutual-exclude long word */
    (APTR) & Gadget3SInfo,	/* SpecialInfo structure */
    PLSTGAD,			/* user-definable data */
    NULL			/* pointer to user-definable data */
};

static SHORT BorderVectors1[] =
{
    0, 0,
    61, 0,
    61, 16,
    0, 16,
    0, 0
};
static struct Border Border1 =
{
    -1, -1,			/* XY origin relative to container TopLeft */
    1, 0, JAM1,			/* front pen, back pen and drawmode */
    5,				/* number of XY vectors */
    BorderVectors1,		/* pointer to XY vectors */
    NULL			/* next border in list */
};

static struct IntuiText IText1 =
{
    3, 0, JAM2,			/* front and back text pens, drawmode and fill byte */
    7, 4,			/* XY origin relative to container TopLeft */
    NULL,			/* font pointer or NULL for default */
    "CANCEL",			/* pointer to text */
    NULL			/* next IntuiText structure */
};

static struct Gadget Gadget2 =
{
    &Gadget3,			/* next gadget */
    110, 65,			/* origin XY of hit box relative to window TopLeft */
    60, 15,			/* hit box width and height */
    NULL,			/* gadget flags */
    RELVERIFY + ENDGADGET,	/* activation flags */
    BOOLGADGET + REQGADGET,	/* gadget type flags */
    (APTR) & Border1,		/* gadget border or image to be rendered */
    NULL,			/* alternate imagery for selection */
    &IText1,			/* first IntuiText structure */
    NULL,			/* gadget mutual-exclude long word */
    NULL,			/* SpecialInfo structure */
    PLCAGAD,			/* user-definable data */
    NULL			/* pointer to user-definable data */
};

static SHORT BorderVectors2[] =
{
    0, 0,
    61, 0,
    61, 16,
    0, 16,
    0, 0
};
static struct Border Border2 =
{
    -1, -1,			/* XY origin relative to container TopLeft */
    1, 0, JAM1,			/* front pen, back pen and drawmode */
    5,				/* number of XY vectors */
    BorderVectors2,		/* pointer to XY vectors */
    NULL			/* next border in list */
};

static struct IntuiText IText2 =
{
    3, 0, JAM2,			/* front and back text pens, drawmode and fill byte */
    24, 4,			/* XY origin relative to container TopLeft */
    NULL,			/* font pointer or NULL for default */
    "OK",			/* pointer to text */
    NULL			/* next IntuiText structure */
};

static struct Gadget Gadget1 =
{
    &Gadget2,			/* next gadget */
    10, 65,			/* origin XY of hit box relative to window TopLeft */
    60, 15,			/* hit box width and height */
    NULL,			/* gadget flags */
    RELVERIFY + ENDGADGET,	/* activation flags */
    BOOLGADGET + REQGADGET,	/* gadget type flags */
    (APTR) & Border2,		/* gadget border or image to be rendered */
    NULL,			/* alternate imagery for selection */
    &IText2,			/* first IntuiText structure */
    NULL,			/* gadget mutual-exclude long word */
    NULL,			/* SpecialInfo structure */
    PLOKGAD,			/* user-definable data */
    NULL			/* pointer to user-definable data */
};

#define GadgetList1 Gadget1

static SHORT BorderVectors4[] =
{
    0, 0,
    161, 0,
    161, 12,
    0, 12,
    0, 0
};
static struct Border Border4 =
{
    9, 28,			/* XY origin relative to container TopLeft */
    3, 0, JAM1,			/* front pen, back pen and drawmode */
    5,				/* number of XY vectors */
    BorderVectors4,		/* pointer to XY vectors */
    NULL			/* next border in list */
};

static SHORT BorderVectors3[] =
{
    0, 0,
    179, 0,
    179, 99,
    0, 99,
    0, 0
};
static struct Border Border3 =
{
    0, 0,			/* XY origin relative to container TopLeft */
    3, 0, JAM1,			/* front pen, back pen and drawmode */
    5,				/* number of XY vectors */
    BorderVectors3,		/* pointer to XY vectors */
    &Border4			/* next border in list */
};

#define BorderList1 Border3

static struct IntuiText IText3 =
{
    3, 0, JAM2,			/* front and back text pens, drawmode and fill byte */
    41, 17,			/* XY origin relative to container TopLeft */
    NULL,			/* font pointer or NULL for default */
    "IFF File Name",		/* pointer to text */
    NULL			/* next IntuiText structure */
};

#define IntuiTextList1 IText3

static struct Requester PLFileReq =
{
    NULL,			/* previous requester (filled in by Intuition) */
    5, 15,			/* requester XY origin relative to TopLeft of window */
    180, 100,			/* requester width and height */
    0, 0,			/* relative to these mouse offsets if POINTREL is set */
    &GadgetList1,		/* gadget list */
    &BorderList1,		/* box's border */
    &IntuiTextList1,		/* requester text */
    NULL,			/* requester flags */
    0,				/* back-plane fill pen */
    NULL,			/* leave these alone */
    NULL,			/* custom bitmap if PREDRAWN is set */
    NULL			/* leave this alone */
};

/* end of PowerWindows source generation */

char *
plfilereq(void)
{
    ULONG oldFlags;
    USHORT gadid;
    char *file;
    struct IntuiMessage *message;

    oldFlags = PLWindow->IDCMPFlags;
    ModifyIDCMP(PLWindow, GADGETUP);
    Request(&PLFileReq, PLWindow);
    Wait(1 << PLWindow->UserPort->mp_SigBit);
    message = (struct IntuiMessage *) GetMsg(PLWindow->UserPort);
    gadid = ((struct Gadget *) message->IAddress)->GadgetID;
    ReplyMsg((struct Message *) message);
    switch (gadid) {
    case PLOKGAD:
	if (Gadget3SIBuff[0] == NULL)
	    file = NULL;
	else
	    file = (char *) Gadget3SIBuff;
	break;
    case PLCAGAD:
	file = NULL;
	break;
    case PLSTGAD:
	if (Gadget3SIBuff[0] == NULL)
	    file = NULL;
	else
	    file = (char *) Gadget3SIBuff;
	break;
    default:
	break;
    }
    ModifyIDCMP(PLWindow, oldFlags);
    return (file);
}

