#include <stdio.h>

char *VersionStr = "Planet2d";

static int last = 0;

void alt_code_reset()
{
  last = 0;
}

void alt_encode(int alt, FILE *fp)
{
  static int lo;

  lo = alt-last+128;

  if (lo > 0 && lo < 256)
    fputc(lo, fp);
  else {
    fputc(0, fp);
    fwrite(&alt, sizeof(alt), 1, fp);
  }
  last = alt;
}

int alt_decode(FILE *fp)
{
  static int alt, c;

  c = fgetc(fp);
  if (c == 0)
    fread(&alt, sizeof(alt), 1, fp);
  else
    alt = last+c-128;

  last = alt;    

  return alt;
}

