/*
 menu.h: Toolbox menu structures and menu creation functions.

 $Header: menu.h,v 2.14 93/09/03 14:46:07 wet Exp $
 */

#define RADIO 1
#define TOGGLE 2
#define INSENSITIVE 3
#define SENSITIVE_NORMAL 4
#define SENSITIVE_SET 5 
#define MAX_LABEL 25

typedef struct _menu_struct
{
   char* name;                      /* name of the button */
   void (*func)();                  /* callback to be invoked */
   caddr_t data;                    /* data for the callback */
   struct _menu_struct *sub_menu;   /* data for submenu of this button */
   int n_sub_items;                 /* how many items in sub_menu */
   int flag_toggle;                 /* nonzero if button is a ToggleButton */
   char *sub_menu_title;            /* title of submenu */
   int state;                       /* menu button state */
   char *accelerator;               /* accelerator keysequence*/
   char *acctext;                   /* accelerator text in the button */
 } xs_menu_struct;

typedef struct _menu_w
{
  int items;                        /* items in the submenu */
  WidgetList menu_buttons;          /* button widgets */
  char (*button_labels)[MAX_LABEL]; /* button labels */
  struct _menu_w *next;             /* next struct in the linked list */
} menu_widgets;

menu_widgets *menu;

/*
 * Describe the File menu.
 */
static xs_menu_struct FileMenuData[] = {
  {"New...", file_new_callback, "New...", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
   "Ctrl<Key>n", "C-n"},
  {"Open...", file_open_callback, "Open...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Ctrl<Key>o", "C-o"},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Save", file_save_callback, "Save", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
     "Ctrl<Key>s", "C-s"},
  {"Save as...", file_saveas_callback, "Save as..", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Shift Ctrl<Key>s", "A-S"},
  {"Abandon", file_abandon_callback, "Abandon", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Ctrl<Key>a", "C-a"}, 
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Exit...", file_exit_callback, "Exit", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
   "Ctrl<Key>q", "C-q"} 
};
/*
 * Describe the Edit menu.
 */
static xs_menu_struct EditMenuData[] = {
  {"Can't undo", edit_undo_callback, "Can't undo", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Ctrl<Key>u", "C-u"},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Cut", edit_cut_callback, "Cut", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
   "Alt<Key>c", "A-c"},
  {"Delete", edit_delete_callback, "Delete", NULL, 0, 0 ,NULL,
     SENSITIVE_NORMAL, "Ctrl<Key>d", "C-d"},
  {"Copy", edit_copy_callback, "Copy", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
   "Ctrl<Key>c", "C-c"},
  {"Paste", edit_paste_callback, "Paste", NULL, 0, 0, NULL, SENSITIVE_NORMAL,
   "Ctrl<Key>p", "C-p"},
  {"Paste to toolbox...", edit_pastetool_callback, "Paste to toolbox...",
     NULL, 0, 0, NULL, SENSITIVE_NORMAL, "Alt<Key>p", "A-p"},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Select all", edit_select_callback, "Select all", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Alt<Key>s", "A-a"},
  {"Deselect all", edit_deselect_callback, "Deselect all", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, "Alt<Key>d", "A-d"}
};
/*
 * Create the Filter sub menu pane.
 */
static xs_menu_struct sub_menu_Filter[] = {
  {"Invert", image_invert_callback, "Invert", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Brighten...", image_brighten_callback, "Brighten...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Darken...", image_darken_callback, "Fade...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Soften...", image_soften_callback, "Soften...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Sharpen...", image_sharpen_callback, "Sharpen...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"User matrix...", image_matrix_callback, "User matrix...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"RGB-adjust...", image_RGB_adjust_callback, "RGB-adjust...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"HSV-adjust...", image_HSV_adjust_callback, "HSV-adjust...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Add noise", image_addnoise_callback, "Add noise", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
};
/*
 * Create the Transform sub menu pane.
 */
static xs_menu_struct sub_menu_Transform[] = {
  {"Resize...", image_resize_callback, "Resize...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Vertical flip", image_vflip_callback, "Vertical flip", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Horizontal flip", image_hflip_callback, "Horizontal flip", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Rotate...", image_rotate_callback, "Rotate...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Describe the Image menu.
 */
static xs_menu_struct ImageMenuData[] = {
  {"Filter", NULL, "Filter",  sub_menu_Filter,
      XtNumber(sub_menu_Filter), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Transform", NULL, "Transform",  sub_menu_Transform,
      XtNumber(sub_menu_Transform), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Add view...", image_addview_callback, "Add view...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Duplicate", image_duplicate_callback, "Duplicate", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}, 
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Zoom...", image_zoom_callback, "Zoom...", NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Create the Freehand sub menu pane.
 */
static xs_menu_struct sub_menu_Freehand[] = {
  {"Point", tool_callback, (caddr_t)POINT, NULL, 0, 0, NULL, SENSITIVE_NORMAL,
     NULL, NULL},
  {"Draw", tool_callback, (caddr_t)DRAW, NULL, 0, 0, NULL, SENSITIVE_NORMAL,
     NULL, NULL},
  {"Airbrush", tool_callback, (caddr_t)AIRBRUSH, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Create the Line sub menu pane.
 */
static xs_menu_struct sub_menu_Line[] = {
  {"Single", tool_callback, (caddr_t)LINE, NULL, 0, 0, NULL, SENSITIVE_NORMAL,
     NULL, NULL},
  {"Polyline", tool_callback, (caddr_t)POLYLINE, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Create the Object sub menu pane.
 */
static xs_menu_struct sub_menu_Object[] = {
  {"Rectangle", tool_callback, (caddr_t)RECTANGLE, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Circle", tool_callback, (caddr_t)CIRCLE, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Ellipse", tool_callback, (caddr_t)ELLIPSE, NULL, 0, 0, NULL, 
     SENSITIVE_NORMAL, NULL, NULL},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Perimeters", flag_callback, (caddr_t)PERIMETER, NULL, 0, TOGGLE, NULL,
     SENSITIVE_SET, NULL, NULL},
  {"Filled", flag_callback, (caddr_t)FILLED, NULL, 0, TOGGLE, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Create the Select sub menu pane.
 */
static xs_menu_struct sub_menu_Select[] = {
  {"Rectangle", tool_callback, (caddr_t)RECT_S, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Ellipse", tool_callback, (caddr_t)ELLIPSE_S, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Polygon", tool_callback, (caddr_t)POLY_S, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Lasso", tool_callback, (caddr_t)LASSO_S, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Color range", tool_callback, (caddr_t)COLOR_S, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Show mask", flag_callback, (caddr_t)SHOW_EDGE, NULL, 0, TOGGLE, NULL,
     SENSITIVE_SET, NULL, NULL}
};
/*
 * Describe the Tool menu.
 */
static xs_menu_struct ToolMenuData[] = {
  {"Freehand", NULL, "Freehand",  sub_menu_Freehand,
      XtNumber(sub_menu_Freehand), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Line", NULL, "Line",  sub_menu_Line,
      XtNumber(sub_menu_Line), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Object", NULL, "Object",  sub_menu_Object,
      XtNumber(sub_menu_Object), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Select", NULL, "Select",  sub_menu_Select,
      XtNumber(sub_menu_Select), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Flood fill", tool_callback, (caddr_t)FLOOD_FILL, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Describe the Color menu.
 */
static xs_menu_struct ColorMenuData[] = {
  {"Select...", color_select_callback, (caddr_t)PRIM, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Extract", tool_callback, (caddr_t)COLOR_EXT, NULL, 0, 0, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Create the Drawing mode sub menu pane.
 */
static xs_menu_struct sub_menu_Drawing_mode[] = {
  {"Replace", flag_callback, (caddr_t)REPLACE, NULL, 0, RADIO, NULL,
     SENSITIVE_SET, NULL, NULL},
  {"Add", flag_callback, (caddr_t)ADD, NULL, 0, RADIO, NULL, SENSITIVE_NORMAL,
     NULL, NULL},
  {"Substract", flag_callback, (caddr_t)SUB, NULL, 0, RADIO, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Everywhere", flag_callback, (caddr_t)EVERYWHERE, NULL, 0, RADIO, NULL,
     SENSITIVE_SET, NULL, NULL},
  {"Inside mask", flag_callback, (caddr_t)INSIDE, NULL, 0, RADIO, NULL,
     SENSITIVE_NORMAL, NULL, NULL},
  {"Outside mask", flag_callback, (caddr_t)OUTSIDE, NULL, 0, RADIO, NULL,
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Describe the Options menu.
 */
static xs_menu_struct OptionsMenuData[] = {
  {"Brush options...", options_brush_callback, "Brush options...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Airbrush options...", options_airbrush_callback, "Airbrush options...",
     NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Fill options...", options_fill_callback, "Fill options...", NULL, 0,
     0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Set hot spot...", options_hotspot_callback, "Set hot spot", NULL, 0,
     0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Range select options...", options_range_callback,
     "Range select options...", NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {NULL, NULL, NULL, NULL, 0, 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Drawing modes", NULL, "Drawing modes",  sub_menu_Drawing_mode,
      XtNumber(sub_menu_Drawing_mode), 0, NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Display options...", options_display_callback, "Display options...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL},
  {"Copy options...", options_copy_callback, "Copy options...", NULL, 0, 0,
     NULL, SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Describe the Help menu.
 */
static xs_menu_struct HelpMenuData[] = {
  {"About...", help_about_callback, "About...", NULL, 0, 0, NULL, 
     SENSITIVE_NORMAL, NULL, NULL}
};
/*
 * Describe the menu bar, giving only the names to appear in
 * the menu bar and pointers to each pulldown pane.
 */
static xs_menu_struct PulldownData[] = {
  {"File" , NULL,  NULL, 
    FileMenuData, XtNumber(FileMenuData), 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {"Edit" , NULL,  NULL,  
    EditMenuData, XtNumber(EditMenuData), 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {"Image" , NULL,  NULL,  
    ImageMenuData, XtNumber(ImageMenuData), 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {"Tool" , NULL,  NULL,
    ToolMenuData, XtNumber(ToolMenuData), 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {"Color" , NULL,  NULL,
    ColorMenuData, XtNumber(ColorMenuData), 0, NULL, SENSITIVE_NORMAL, NULL,
     NULL},
  {"Options" , NULL,  NULL,
    OptionsMenuData, XtNumber(OptionsMenuData), 0, NULL, SENSITIVE_NORMAL,
     NULL, NULL},
  {"Help" , NULL,  NULL,
    HelpMenuData, XtNumber(HelpMenuData), 0, NULL, SENSITIVE_NORMAL, 
     NULL, NULL}
};

void xs_create_menu_buttons(char *title, Widget cascade, 
			    xs_menu_struct *menulist, menu_widgets *menu_p,
			    int nitems);
menu_widgets *alloc_menu(void);
