
/* ****************************************************************** */
/* Function : NextElmList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Acces to the next element in a list.
 * 
 * Input parameters : List identifier (Ptr to 1st element).
 * 
 * Output parameter : Value of the next element. */
/* ****************************************************************** */

#include "ListeP.h"

long NextElmList (
#if NeedFunctionPrototypes
  Liste s_idlist		/* List identifier */
)
#else
s_idlist)
  Liste s_idlist;		/* List identifier */
#endif

{
  ty_list *p_firstelem;		/* pointer to the list */
  ty_node *p_curent;		/* Pointer to curent node */

#ifdef debug
  (void) fprintf (stderr, " Function : NextElmList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;
  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* Acces to the next element */
  Lst_TestPar (p_firstelem->p_first, "EMPTY LIST \n", ERRVI);
  p_curent = p_firstelem->p_cur;
  Lst_TestPar (p_curent->p_suiv, "NO MORE ELEMENTS \n", ERRVI);

  /* Tail none empty list */
  p_firstelem->p_cur = p_curent->p_suiv;	/* Update curent elemnt */

#ifdef debug
  (void) fprintf (stderr, " End of : NextElmList \n");
#endif

  return (p_firstelem->p_cur->s_elem);

}				/* End of NextElmList */
