/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : LineSegGradient
Type : int
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/LineRoutines

==============================================================================

Input parameters    : 

 StartCol		-- The column number of the start point of the line
 StartRow		-- The row number of the start point of the line
 EndCol		-- The column number of the end point of the line
 EndRow		-- The row number of the end point of the line 

Output result       : 

 -1 = gradient is infinite (ie line is vertical)
  0 = successful in calculating gradient

Output parameters   :

 Gradient		-- Gradient of the line 

Calling procedure:

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 double Gradient;

 LineSegGradient( StartCol,
  		 StartRow,
		 EndCol,
               EndRow,
		 &Gradient)

Functionality: 

This function finds the gradient of a line given any two points that lie along
the line. 

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

#ifndef HUGE
#define HUGE 999999999.0
#endif

int LineSegGradient(StartCol,
		   StartRow,
		   EndCol,
		   EndRow,
		   Gradient)

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 double *Gradient;

{

 double dx,dy; 

#ifdef debug
          fprintf(stderr," Start of function LineSegGradient \n");
#endif

  dx = EndCol - StartCol;
  dy = EndRow - StartRow;

    if (dx != 0) {		/* Line is not vertical */
	*Gradient = dy/dx; 
	return(0);
    }

  *Gradient = HUGE;   /* Line is vertical */
  return(-1);

#ifdef debug
          fprintf(stderr," End of function LineSegGradient \n");
#endif

}

