/*
   File: mpeg2audio.hh
   
   By: Alex Theo de Jong
   Created: Febraury 1996

   Description:
   MPEG2 Audio player. The class creates a threaded audio player that plays
   audio on the speaker, headphones, or line-out.

   Note:
   Should work on SUN Sparc 5 and SUN Sparc 10, and Sparc 20 or SGI Indigo
   and SGI Indy. It has been tested on SGI Indigo Impact and SGI Indy running
   Irix 5.3 and SUN Sparc 20 running Solaris 2.4 . 
*/

#ifndef __mpeg2audio_hh
#define __mpeg2audio_hh

#ifdef __GNUG__
#pragma interface
#endif

#include "astream.hh"
#include "crc.hh"
#include "header.hh"
#include "obuffer.hh"
#include "synthesis_filter.hh"
#include "subband.hh"
#include "subband_layer_1.hh"
#include "subband_layer_2.hh"

class Mpeg2Audio {
  AudioStream *stream;
  Synchronization* sync;
  Header *header;
  Crc16 *crc;
  Subband *subbands[32];
  SynthesisFilter *filter1, *filter2;
  Obuffer *buffer;

  char *filename;
  bool verbose_mode;
  bool filter_check;
  bool stdout_mode;
  enum e_channels which_channels;
  bool use_speaker;
  bool use_headphone;
  bool use_line_out;
  bool use_own_scalefactor;
  real scalefactor;

  // data extracted from header of first frame:
  uint32 layer;
  e_mode mode;
  e_sample_frequency sample_frequency;

  int argc;
  char** argv;
  athr_t thread_id;
  int terminate;  // action
  int terminated; // inidication
 protected:
  static void* player(Mpeg2Audio* base);
  static void* ac3_player(Mpeg2Audio* base);

  void usage(const char* name);
  int options();
 public:
  Mpeg2Audio(Mpeg2Buffer* input, Synchronization* s, int audio, int c, char** v);
  ~Mpeg2Audio();
  int play();
  int stop(){ terminate=1; return (terminated); }  // check when thread is done
};

#endif // __mpeg2audio_hh
