/*
 * file:     textObject.c
 * author:   Wes Barris
 * date:     5/05/92
 * purpose:  handles all text functions (drawing, creating, editing)
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <gl/glws.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <X11/extensions/shape.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include "PSutils.h"
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern UmscList	theList;
extern int	needtosave;
extern char	systype[10];
extern int	needtosave;
extern int	currentFrame;
extern int	extraFonts[N_EXT_FONTS];

static Widget		textPopup = NULL,
			selfw;
static int		c_or_e;
static GLXconfig glxConfig [] = {
    { GLX_NORMAL, GLX_RGB, TRUE },
    { 0, 0, 0 }
};

static GLXconfig glxOverlayConfig [] = {
    { GLX_NORMAL, GLX_RGB, TRUE },
    { GLX_OVERLAY, GLX_BUFSIZE, GLX_NOCONFIG },	/* use largest possible */
    { 0, 0, 0 }
};

TextInfo	currentInfo;
GenericInfo	defaultInfo;
TextInfo	selectedText;
int		psinited = NULL;
int		useOverlay;


/*
 * This routine is called once at the beginning of the program.  It is used
 * to initilize all font parameters that will be used as the default.
 */
void
InitFont(void)
{
/*
 * defaultInfo: Used for creating new objects (usually text).
 * selectedText: Used so that pulldown menus (font, style, size, etc.)
 *               show the selected text characteristics.
 */
   strcpy(defaultInfo.u.text.fontname, "Times-Roman");
   defaultInfo.u.text.font	= selectedText.font		= TIMES;
   defaultInfo.u.text.fontstyle	= selectedText.fontstyle	= ROMAN;
   defaultInfo.u.text.scale	= selectedText.scale		= 40;
   defaultInfo.u.text.justify	= selectedText.justify		= JUSTIFY_LEFT;
   defaultInfo.u.text.useShape	= selectedText.useShape		= 0;
   defaultInfo.u.text.cv[0]	= selectedText.cv[0]		= 201;
   defaultInfo.u.text.cv[1]	= selectedText.cv[1]		= 201;
   defaultInfo.u.text.cv[2]	= selectedText.cv[2]		=  41;
/*
 * This section will affect all objects.
 */
   defaultInfo.decoration	= 0;
   defaultInfo.dec_size		= 5;
   defaultInfo.dec[0]		= 0;
   defaultInfo.dec[1]		= 0;
   defaultInfo.dec[2]		= 0;
}


/*
 * This routine should be called before drawing any text to make sure the
 * correct font is loaded.
 */
void
LoadFont(TextInfo *thisText)
{
/*
 * Is this font available?
 */
   if (extraFonts[thisText->font] == 0) {
      printf("Font: %s is not available on this machine -- substituting Times.\n", thisText->fontname);
      thisText->font = TIMES;
      strcpy(thisText->fontname, MakeName(thisText->font, thisText->fontstyle));
      }
/*
 * Is this the same font as what is already loaded?
 */
   if (currentInfo.font      != thisText->font      ||
       currentInfo.fontstyle != thisText->fontstyle ||
       currentInfo.scale     != thisText->scale)     {
      if (psinited == NULL) {
         psinit(XtDisplay(desi.toplevel), desi.back.width, desi.back.height);
         psinited = 1;
         }
      psfindfont(thisText->fontname, thisText->scale);
      strcpy(currentInfo.fontname, thisText->fontname);
      currentInfo.font = thisText->font;
      currentInfo.fontstyle = thisText->fontstyle;
      currentInfo.scale = thisText->scale;
      }
}


/*
 *This routine (SetShapeMask) should be called whenever a text widget is
 * created or changed in any way.
 */
void
SetShapeMask(GenericInfo *thisObject)
{
   int    w, h;
/*
 * Get out-a-here if we're using the overlay planes.
 */
   if (useOverlay)
      return;
/*
 * Is it necessary to disable the shape mask?
 */
   if (!thisObject->u.text.useShape || thisObject->decoration == BORDER) {
      thisObject->u.text.useShape = 0;
      if (thisObject->u.text.shapeMask) {
         XFreePixmap(XtDisplay(thisObject->w), thisObject->u.text.shapeMask);
         thisObject->u.text.shapeMask = NULL;
         XShapeCombineMask(XtDisplay(thisObject->w),
                           XtWindow(XtParent(thisObject->w)),
                           ShapeBounding, 0, 0,
                           thisObject->u.text.shapeMask, ShapeSet);
         }
      return;
      }
/*
 * Each text object has its own shapeMask.
 */
   if (thisObject->u.text.shapeMask)
      XFreePixmap(XtDisplay(thisObject->w), thisObject->u.text.shapeMask);
   if (thisObject->decoration == DROP_SHADOW) {
      w = thisObject->width + thisObject->dec_size;
      h = thisObject->height + thisObject->dec_size;
      }
   else {
      w = thisObject->width;
      h = thisObject->height;
      }
   thisObject->u.text.shapeMask = XCreatePixmap(XtDisplay(thisObject->w),
                                XtWindow(thisObject->w), w, h, 1);
   /*XSetErrorHandler(0);*/
   LoadFont(&thisObject->u.text);
   if (thisObject->decoration == DROP_SHADOW)
      XFillRectangle(XtDisplay(thisObject->w), thisObject->u.text.shapeMask,
                     psgetbitmapgc(thisObject->u.text.shapeMask), 0, 0,
                     thisObject->width + thisObject->dec_size,
                     thisObject->height+ thisObject->dec_size);
/*
 * Postscript text is drawn into a one bit pixmap.  Next, copy the text
 * from the postscript pixmap to the pixmap to be used as the mask.
 */
   pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
   pscopypixmap(thisObject->u.text.shapeMask);
/*
 * If this text has drop shadows, another "drop shadow" pixmap must be
 * "or'ed" with this one.
 */
   if (thisObject->decoration == DROP_SHADOW)
      psorpixmap(thisObject->u.text.shapeMask, thisObject->dec_size);
/*
 * Test the bitmap to see if the bits were set properly.
 */
   /*if (0) {
      XImage *bitmap;
      short  cv[4];

      cv[0] = 255;
      cv[1] = 0;
      cv[2] = 255;
      bitmap = XGetImage(XtDisplay(thisObject->w), thisObject->u.text.shapeMask,
                         0, 0, thisObject->width, thisObject->height,
                         (unsigned long)0x01, XYPixmap);
      bitmap = psctxttobitmap();
      psbitmaptorle(bitmap, cv);
      }*/
/*
 * Let the shape extension do its thing.
 *
 * NOTE:  Normally one would think that the shapeMask should be applied to
 * the GLX widget -- yes?  Well, no.  As it turns out, to make this work,
 * the shapeMask must be appied to the GLX widgets parent -- in this case
 * that would be the selfmoving widget.
 */
   /*XShapeCombineMask(XtDisplay(thisObject->w),
                     XtWindow(thisObject->w),
                     ShapeBounding, 0, 0,
                     thisObject->u.text.shapeMask, ShapeSet);*/
   XShapeCombineMask(XtDisplay(thisObject->w),
                     XtWindow(XtParent(thisObject->w)),
                     ShapeBounding, 0, 0,
                     thisObject->u.text.shapeMask, ShapeSet);
}


Window overlayWindow(Widget w)
{
   Arg args[1];
   Window overlayWindow;

   XtSetArg(args[0], GlxNoverlayWindow, &overlayWindow);
   XtGetValues(w, args, 1);
   return (overlayWindow);
}


void
OverlayInitCB(Widget w, XtPointer client_data, char *call_data)
{
   GLXconfig	*config1, config2;
   int buffer;

   GLXwinset(XtDisplay(desi.toplevel), overlayWindow(w));
   viewport(0, (Screencoord)((GlxDrawCallbackStruct *)call_data)->width-1,
            0, (Screencoord)((GlxDrawCallbackStruct *)call_data)->height-1);
   myortho2(-0.5, (Coord)((GlxDrawCallbackStruct *)call_data)->width-0.5,
            -0.5, (Coord)((GlxDrawCallbackStruct *)call_data)->height-0.5);
   XSetWMColormapWindows(XtDisplay(desi.toplevel), XtWindow(desi.toplevel), &(((GlxDrawCallbackStruct *)call_data)->window), 1);
   color(0);
   clear();
   mapcolor (1, 255, 0, 255);
   mapcolor (2, 0, 255, 255);
   config1 = GLXgetconfig(XtDisplay(desi.toplevel), 0, glxOverlayConfig);
}


/*
 * This routine is called any time a text object needs to be re-drawn.
 */
void
DrawText(GenericInfo *thisObject)
{
   Arg			args[10];
   Dimension		dwidth, dheight;
   float		xl, xr, yu, yd;
   int			twidth, theight;
   int			n;
   short		cv[3], vert[2];

   XImage		*bitmap;
/*
 * Make sure the current font is correct?
 */
   LoadFont(&thisObject->u.text);
/*
 * We want to draw into the correct window.
 */
   GLXwinset(XtDisplay(desi.toplevel), XtWindow(thisObject->w));
/*
 * Get the size of this widget and compare it to the size required by
 * the text.
 */
   psgetblocksize(thisObject->u.text.text, &twidth, &theight);
   if (thisObject->decoration == DROP_SHADOW) {
      twidth += thisObject->dec_size;
      theight += thisObject->dec_size;
      }
   else if (thisObject->decoration == BORDER) {
      twidth += 2*thisObject->dec_size;
      theight += 2*thisObject->dec_size;
      }
   if (twidth != thisObject->width || theight != thisObject->height) {
      thisObject->width = twidth;
      thisObject->height = theight;
      }
   n = 0;
   XtSetArg(args[n], XmNwidth, &dwidth); n++;
   XtSetArg(args[n], XmNheight, &dheight); n++;
   XtGetValues(thisObject->w, args, n);
   if ((int)dwidth != thisObject->width || (int)dheight != thisObject->height) {
      n = 0;
      XtSetArg(args[n], XmNwidth, (Dimension)thisObject->width); n++;
      XtSetArg(args[n], XmNheight, (Dimension)thisObject->height); n++;
      XtSetValues(thisObject->w, args, n);
      viewport(0, (Screencoord)thisObject->width-1,
               0, (Screencoord)thisObject->height-1);
      myortho2(-0.5, (Coord)thisObject->width-0.5,
               -0.5, (Coord)thisObject->height-0.5);
      SetShapeMask(thisObject);
      }
   if (useOverlay)
      if (thisObject->decoration == DROP_SHADOW) {
         }
      else if (thisObject->decoration == BORDER) {
         }
      else {
         color(0);
         clear();
         /*pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         psbitmaptogl(0, 0, bitmap);*/
         }
/*
 * Draw text with drop shadow (shape).
 */
   else if (thisObject->u.text.useShape) {
      if (thisObject->decoration == DROP_SHADOW) {
         pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         c3s(thisObject->dec);
         psbitmaptogl(thisObject->dec_size, 0, bitmap);
         pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         c3s(thisObject->u.text.cv);
         psbitmaptogl(0, thisObject->dec_size, bitmap);
         }
/*
 * Draw text with border (shape).
 * Currently, this cannot happen.
 */
      /*else if (thisObject->decoration == BORDER) {
         c3s(thisObject->dec);
         rectangle(0,thisObject->width+2*thisObject->dec_size,
                   0,thisObject->height+2*thisObject->dec_size);
         pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         c3s(thisObject->dec);
         psbitmaptogl(thisObject->dec_size, 0, bitmap);
         pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         c3s(thisObject->u.text.cv);
         psbitmaptogl(0, thisObject->dec_size, bitmap);
         }*/
/*
 * Draw text without a drop shadow nor a border (shape).
 */
      else {
         c3s(thisObject->u.text.cv);	/* all I really need to do is clear */
         clear();			/* the shapeMask will do the rest */
         }
      }
   else {	/* don't useShape */
/*
 * Draw border for the text (no shape).
 */
      if (thisObject->decoration == BORDER) {
         c3s(thisObject->dec);
         rectangle(0,thisObject->width+2*thisObject->dec_size,
                   0,thisObject->height+2*thisObject->dec_size);
         pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
         bitmap = psctxttobitmap();
         c3s(thisObject->u.text.cv);
         psbitmaptogl(thisObject->dec_size, thisObject->dec_size, bitmap);
         }
      else {
/*
 * This nasty hunk of code determines the colors at the four corners of the
 * block of text and clears the text area so that it matches that of the
 * background.
 */
         xl = thisObject->x - desi.back.xoffset;
         xr = thisObject->x - desi.back.xoffset + thisObject->width - 1;
         yu = thisObject->y - desi.back.yoffset;
         yd = thisObject->y - desi.back.yoffset + thisObject->height - 1;
         bgnpolygon();
            getrgb(xl, yu, cv);	/* Upper Left */
            c3s(cv);
            vert[0]=0;                vert[1]=thisObject->height;v2s(vert);
            getrgb(xr, yu, cv);	/* Upper Right */
            c3s(cv);
            vert[0]=thisObject->width;vert[1]=thisObject->height;v2s(vert);
            getrgb(xr, yd, cv);	/* Lower Right */
            c3s(cv);
            vert[0]=thisObject->width;vert[1]=0;                  v2s(vert);
            getrgb(xl, yd, cv);	/* Lower Left */
            c3s(cv);
            vert[0]=0;                vert[1]=0;                  v2s(vert);
         endpolygon();
/*
 * Draw text with a drop shadow (no shape).
 */
         if (thisObject->decoration == DROP_SHADOW) {
            pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
            bitmap = psctxttobitmap();
            c3s(thisObject->dec);
            psbitmaptogl(thisObject->dec_size, 0, bitmap);
   
            pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
            bitmap = psctxttobitmap();
            c3s(thisObject->u.text.cv);
            psbitmaptogl(0, thisObject->dec_size, bitmap);
            }
/*
 * Draw text without a drop shadow nor a border (no shape).
 */
         else {
            pstexttoctxt(thisObject->u.text.text, thisObject->u.text.justify);
            bitmap = psctxttobitmap();
            c3s(thisObject->u.text.cv);
            psbitmaptogl(0, 0, bitmap);
            }
         }
      }
}



/*
 * This routine is called from the TextHandler if we are creating
 * or if we are editing and new text was specified.
 */
static GenericInfo*
ReadText(void)
{
   GenericInfo	*thisObject;
   int		width, height;
/*
 * Create space to hold this object.
 */
   if ((thisObject = (GenericInfo *)malloc(sizeof(GenericInfo))) == NULL) {
      fprintf(stderr, "ERROR -- Unable to get memory for text.\n");
      exit(1);
      }
   thisObject->u.text.text = XmTextGetString(XtNameToWidget(textPopup, "text"));
   if (strlen(thisObject->u.text.text) == 0) {
      free(thisObject);
      thisObject = NULL;
      return thisObject;
      }
   needtosave = 1;
   thisObject->selected = False;
   thisObject->frame = currentFrame;
   thisObject->objtype = TXTOBJ;
   strcpy(thisObject->u.text.fontname, defaultInfo.u.text.fontname);
   thisObject->u.text.font		= defaultInfo.u.text.font;
   thisObject->u.text.fontstyle		= defaultInfo.u.text.fontstyle;
   thisObject->u.text.scale		= defaultInfo.u.text.scale;
   thisObject->u.text.cv[0]		= defaultInfo.u.text.cv[0];
   thisObject->u.text.cv[1]		= defaultInfo.u.text.cv[1];
   thisObject->u.text.cv[2]		= defaultInfo.u.text.cv[2];
   thisObject->u.text.justify		= defaultInfo.u.text.justify;
   thisObject->u.text.useShape		= defaultInfo.u.text.useShape;
   thisObject->decoration		= defaultInfo.decoration;
   thisObject->dec_size			= defaultInfo.dec_size;
   thisObject->dec[0]			= defaultInfo.dec[0];
   thisObject->dec[1]			= defaultInfo.dec[1];
   thisObject->dec[2]			= defaultInfo.dec[2];
/*
 * I have to load the font here so I can get its size.
 */
   LoadFont(&thisObject->u.text);
/*
 * I have to set the current pointer to the last item in the list
 * so that the new node is placed at the end (after the current).
 */
   UmscListSetCurrent(theList, UmscLAST);
   UmscListInsert(theList, thisObject, UmscNEXT);
/*
 * Create an initial location for this text.
 */
   psgetblocksize(thisObject->u.text.text, &width, &height);
   if (thisObject->decoration == DROP_SHADOW) {
      thisObject->width = (Dimension)(width + thisObject->dec_size);
      thisObject->height = (Dimension)(height + thisObject->dec_size);
      }
   else if (thisObject->decoration == BORDER) {
      thisObject->width = (Dimension)(width + 2*thisObject->dec_size);
      thisObject->height = (Dimension)(height + 2*thisObject->dec_size);
      }
   else {
      thisObject->width = (Dimension)(width);
      thisObject->height = (Dimension)(height);
      }
   if (thisObject->width <= desi.back.width)
      thisObject->x = desi.back.xoffset + (desi.back.width - thisObject->width)/2;
   else
      thisObject->x = 0;
   if (thisObject->height <= desi.back.height)
      thisObject->y = desi.back.yoffset + (desi.back.height - thisObject->height)/2;
   else
      thisObject->y = 0;
   return thisObject;
}


/*
 * This routine is called when the OK button is clicked after:
 *	- creating new text
 *	- editing an existing text object
 */
static void
TextHandlerCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   GenericInfo	*thisObject;
   int		found;

   if (c_or_e == CREATING) {
      thisObject = ReadText();
      if (thisObject)
         CreateText(thisObject);
      }
   else { /* if EDITING */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      found = 0;
      while (!found) {
         if (!thisObject->w)
            thisObject = UmscListGetNext(theList);
         else if (XtParent(thisObject->w) != selfw)
            thisObject = UmscListGetNext(theList);
         else
            found = 1;
         }


      free(thisObject->u.text.text);
      thisObject->u.text.text = XmTextGetString(XtNameToWidget(textPopup, "text"));
      if (strlen(thisObject->u.text.text) == 0)
         CutCB((Widget)0, (XtPointer)0, (char *)0);
      else {
         selectedText.text = thisObject->u.text.text;
         DrawText(thisObject);
         }
      }
}


/*
 * This routine creates the text input box.
 */
static void
TextInfoPanelInit(void)
{
   int		n;
   Arg		args[10];
   Widget	text,
		rc,
		b1,
		b2;
/*
 * Let the user type in the text.
 */
   n = 0;
   textPopup = XmCreateFormDialog(desi.toplevel, "textPopup", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   text = XtCreateManagedWidget("text", xmTextWidgetClass, textPopup, args, n);
   n = 0;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, textPopup, args, n);
   n = 0;
   b1 = XtCreateManagedWidget("b1", xmPushButtonWidgetClass, rc, args, n);
   n = 0;
   b2 = XtCreateManagedWidget("b2", xmPushButtonWidgetClass, rc, args, n);
/*
 * Set the initial focus of the popup to be the text input field.
 * NOTE: This will not work until Motif 1.2
 */
   /*n = 0;
   XtSetArg(args[n], XmNinitialFocus, text, XmDIALOG_TEXT)); n++;
   XtSetValues(text, args, n);*/

   XtAddCallback(b1, XmNactivateCallback, (XtCallbackProc)TextHandlerCB, NULL);
   XtAddCallback(b1, XmNactivateCallback, (XtCallbackProc)unmanageCB, (XtPointer)textPopup);
   XtAddCallback(b2, XmNactivateCallback, (XtCallbackProc)unmanageCB, (XtPointer)textPopup);
}


/*
 * This routine is called:
 *	- by ObjectMenuInit when the menu item is selected.
 *	- by SelfCB when a text object is double clicked.
 */
void
GetTextInfoCB(w, client_data, call_data)
Widget				w;
int				client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   Arg		args[10];
   GenericInfo	*thisObject;
   int		n;
   short	found;

   c_or_e = client_data;
   if (textPopup == NULL)
      TextInfoPanelInit();
/*
 * If we are editing text, stuff the text of the selected object into
 * prompt dialog area.
 */
   if (c_or_e == EDITING) {
      selfw = w;	/* this is the sm widget that was double clicked */
/*
 * Find this object in the list.
 */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      found = 0;
      while (!found) {
         if (!thisObject->w)
            thisObject = UmscListGetNext(theList);
         else if (XtParent(thisObject->w) != selfw)
            thisObject = UmscListGetNext(theList);
         else
            found = 1;
         }
/*
 * Set the text in the text popup to match that of the object.
 */
      /*n = 0;
      XtSetArg(args[n], XmNvalue,
               XmStringCreateSimple(thisObject->u.text.text)); n++;
      XtSetValues(XtNameToWidget(textPopup, "text"), args, n);*/
      XmTextSetString(XtNameToWidget(textPopup, "text"), thisObject->u.text.text);
      }
   else
      XmTextSetString(XtNameToWidget(textPopup, "text"), NULL);
   XtManageChild(textPopup);
}


/*
 * This routine is used to create a text object.
 */
void
CreateText(GenericInfo *thisObject)
{
   Arg		args[10];
   Widget	selfMoving = CreateSelfM();
   int		n;
   if (!strncmp(&systype[4], "XG", 2))
      useOverlay = 0; /*1*/
   else
      useOverlay = 0;
/*
 * Remove the corner handles from the self moving widget.
 */
   n = 0;
   XtSetArg(args[n], XtNnorthEastHandle, HrSIZING_HANDLE); n++;
   XtSetArg(args[n], XtNnorthWestHandle, HrSIZING_HANDLE); n++;
   XtSetArg(args[n], XtNsouthEastHandle, HrSIZING_HANDLE); n++;
   XtSetArg(args[n], XtNsouthWestHandle, HrSIZING_HANDLE); n++;
   XtSetArg(args[n], XtNborderColor, 200); n++;
   XtSetValues(selfMoving, args, n);
/*
 * Create a glx widget for the text.
 */
   n = 0;
   if (useOverlay) {
      XtSetArg(args[n], GlxNglxConfig, glxOverlayConfig); n++;
      XtSetArg(args[n], GlxNuseOverlay, TRUE); n++;
      }
   else
      XtSetArg(args[n], GlxNglxConfig, glxConfig); n++;
   XtSetArg(args[n], XmNwidth, thisObject->width); n++;
   XtSetArg(args[n], XmNheight, thisObject->height); n++;
   thisObject->w = GlxCreateMDraw(selfMoving, "text", args, n);
   /*thisObject->w = XmCreateDrawingArea(selfMoving, name, args, n);*/
/*
 * Add some callbacks.
 */
   XtAddCallback(selfMoving, XtNselectCallback, (XtCallbackProc)SelectCB, (XtPointer)thisObject);
   XtAddCallback(selfMoving, XtNunselectCallback, (XtCallbackProc)UnselectCB, (XtPointer)thisObject);
   XtAddCallback(selfMoving, XtNdoubleClickCallback, (XtCallbackProc)GetTextInfoCB, (char *)EDITING);
   XtAddCallback(selfMoving, XtNendResizeCallback, (XtCallbackProc)SelfCB, (char *)TXTOBJ);
   XtAddCallback(selfMoving, XtNendMoveCallback, (XtCallbackProc)SelfCB, NULL);

   XtAddCallback(thisObject->w, GlxNginitCallback, (XtCallbackProc)GLInitCB, NULL);
   XtAddCallback(thisObject->w, GlxNginitCallback, (XtCallbackProc)OverlayInitCB, NULL);
   XtAddCallback(thisObject->w, useOverlay?GlxNoverlayExposeCallback:GlxNexposeCallback, (XtCallbackProc)DrawObjectCB, NULL);
   /*XtAddCallback(thisObject->w, XmNexposeCallback, GlDrawCB, NULL);*/
/*
 * Position the text.
 */
   n = 0;
   XtSetArg(args[n], XtNxChild, thisObject->x); n++;
   XtSetArg(args[n], XtNyChild, thisObject->y); n++;
   XtSetValues(selfMoving, args, n);
/*
 * Create the shape mask.
 */
   XtManageChild(thisObject->w);
   XtManageChild(selfMoving);
   thisObject->u.text.shapeMask = NULL;
   SetShapeMask(thisObject);
}
