/*
 * file:     imageObject.c
 * author:   Wes Barris
 * date:     5/05/92
 * purpose:  handles all image functions (drawing, creating, editing)
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <gl/gl.h>
#include <gl/image.h>
/*#include "/usr/people/4Dgifts/iristools/include/izoom.h"*/
#include <X11/Xirisw/GlxMDraw.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"
/*
 * Prototypes for libimage.
 */
IMAGE* iopen(char*, char*);
void iclose(IMAGE*);
unsigned long* longimagedata(char*);
/*
 * Old zooming declarations.
 */
/*void getrow(IMAGE*, short*, int, int);*/
/*void getzoomrow(zoom*, short*, int);*/
/*zoom* newzoom(void(), int, int, int, int, int, double);*/
/*void freezoom(zoom*);*/

void fastzoom(unsigned long*, unsigned long*, int, int, int, int);

extern DESI		desi;
extern UmscList		theList;
extern int	needtosave;
extern int	currentFrame;
extern GenericInfo defaultInfo;
extern int	dumppending;

static Widget	isb = NULL,
		xtxt,
		ytxt,
		dw;
static int	isimage;
static int	c_or_e;
static int	globalz;
static IMAGE	*aimage;
static GLXconfig glxConfig [] = {
    { GLX_NORMAL, GLX_RGB, TRUE },
    { 0, 0, 0 }
};


/*
 * This routine is only called from DrawImage when an SGI image is scaled.
 */
/*static void
getimgrow(buf,y)
short *buf;
int y;
{
   getrow(aimage,buf,y,globalz);
}*/


/*
 * This routine is called any time an image object needs to be re-drawn.
 */
void
DrawImage(GenericInfo *thisObject)
{
   Arg			args[10];
   Dimension		wwidth, wheight;
   FILE			*pixin;
   char			cmd[128], *periodP;
   double		xscale, yscale;
   float		xl, xr, yu, yd;
   int			i, bufsiz, n, extra;
   short		cv[3];
/*
 * We want to draw into the correct window.
 */
   GLXwinset(XtDisplay(desi.toplevel), XtWindow(thisObject->w));
   if (thisObject->decoration == DROP_SHADOW)
      extra = thisObject->dec_size;
   else if (thisObject->decoration == BORDER)
      extra = 2*thisObject->dec_size;
   else
      extra = 0;
   viewport(0, (Screencoord)(thisObject->width+extra-1),
            0, (Screencoord)(thisObject->height+extra-1));
   myortho2(-0.5, (Coord)(thisObject->width+extra-0.5),
            -0.5, (Coord)(thisObject->height+extra-0.5));
/*
 * Get the size of the image widget and compare it to the size required
 * by thisObject to see if we have to adjust for decorations.
 */
   n = 0;
   XtSetArg(args[n], XmNwidth, &wwidth); n++;
   XtSetArg(args[n], XmNheight, &wheight); n++;
   XtGetValues(thisObject->w, args, n);
   if (thisObject->width+extra != (int)wwidth  ||
       thisObject->height+extra != (int)wheight) {
/*
 * The difference in size must be accounted for by the decoration.
 */
      n = 0;
      XtSetArg(args[n],XmNwidth,thisObject->width+extra);n++;
      XtSetArg(args[n],XmNheight,thisObject->height+extra);n++;
      XtSetValues(thisObject->w, args, n);
      viewport(0, (Screencoord)(thisObject->width+extra-1),
               0, (Screencoord)(thisObject->height+extra-1));
      myortho2(-0.5, (Coord)(thisObject->width+extra-0.5),
               -0.5, (Coord)(thisObject->height+extra-0.5));
      }
/*
 * Do we need to scale?
 */
   periodP = strrchr(thisObject->u.image.filename,46);
   if ((thisObject->width == thisObject->u.image.orig_width) &&
       (thisObject->height == thisObject->u.image.orig_height)) {
      if (!strcmp(periodP,".rle"))
         sprintf(cmd, "rletoraw -r %s", thisObject->u.image.filename);
      else if (!strcmp(periodP,".gif"))
         sprintf(cmd, "giftorle %s | rletoraw -r", thisObject->u.image.filename);
      else if (!strcmp(periodP,".jpg"))
         sprintf(cmd, "djpeg -R %s | rletoraw -r", thisObject->u.image.filename);
      else if (!strcmp(periodP,".sgi") || !strcmp(periodP,".rgb"))
         sprintf(cmd, "iristorle %s | rletoraw -r", thisObject->u.image.filename);
      }
/*
 * Determine scale factors.
 */
   else {
      xscale = (double)thisObject->width / thisObject->u.image.orig_width;
      yscale = (double)thisObject->height / thisObject->u.image.orig_height;
      if (!strcmp(periodP,".rle"))
         sprintf(cmd, "fant -p 0 0 -s %11.8f %11.8f %s | rletoraw -r",
                          xscale, yscale, thisObject->u.image.filename);
      else if (!strcmp(periodP,".gif"))
         sprintf(cmd, "giftorle %s | fant -p 0 0 -s %11.8f %11.8f | rletoraw -r",
                          thisObject->u.image.filename, xscale, yscale);
      else if (!strcmp(periodP,".jpg"))
         sprintf(cmd, "djpeg -R %s | fant -p 0 0 -s %11.8f %11.8f | rletoraw -r",
                          thisObject->u.image.filename, xscale, yscale);
      else if (!strcmp(periodP,".sgi") || !strcmp(periodP,".rgb"))
         sprintf(cmd, "iristorle %s | fant -p 0 0 -s %11.8f %11.8f | rletoraw -r",
                          thisObject->u.image.filename, xscale, yscale);
      }
/*
 * Draw the drop shadow?
 */
   if (thisObject->decoration == DROP_SHADOW) {
      c3s(thisObject->dec);
      rectangle(thisObject->dec_size, thisObject->width+thisObject->dec_size,
                0, thisObject->height-1);
/*
 * Fill in those little rectangles in the upper right and lower left corners.
 */
      xr = thisObject->x - desi.back.xoffset +
           thisObject->width - 1 + thisObject->dec_size;
      yu = thisObject->y - desi.back.yoffset;
      getrgb(xr, yu, cv);
      c3s(cv);
      rectangle(thisObject->width-1, thisObject->width  + thisObject->dec_size,
                thisObject->height-1,thisObject->height + thisObject->dec_size);

      xl = thisObject->x - desi.back.xoffset;
      yd = thisObject->y - desi.back.yoffset +
           thisObject->height - 1 + thisObject->dec_size;
      getrgb(xl, yd, cv);
      c3s(cv);
      rectangle(0,thisObject->dec_size,0,thisObject->dec_size);
      }
   else if (thisObject->decoration == BORDER) {
/*
 * Draw a rectangle that is "dec_size" larger than the image all the way around.
 */
      c3s(thisObject->dec);
      rectangle(0,thisObject->width+extra,0,thisObject->height+extra);
      }
/*
 * Draw the image:
 *
 * If the imgbuf has not been allocated, it needs to be done here.  Once
 * allocated, the image buffer will be saved so that images will quickly
 * refresh.  When an image is scaled, the imgbuf will be freed (in SelfCB)
 * and a new one allocated here.
 */
      if (!thisObject->u.image.imgbuf) {
/*
 * If this is an SGI RGB image I use the fastzoom function provided by
 * Paul Haeberli.  This zooming function is much faster than the one
 * used in the following files:
 *
 *	- /usr/people/4Dgifts/iristools/imgtools/ipastelrw.c
 *	- /usr/people/4Dgifts/iristools/libgutil/izoom.c
 */
         if ((!strcmp(periodP,".sgi") || !strcmp(periodP,".rgb"))) {
            if((thisObject->width == thisObject->u.image.orig_width) &&
              (thisObject->height == thisObject->u.image.orig_height))
               thisObject->u.image.imgbuf =
                  (unsigned long *) longimagedata(thisObject->u.image.filename);
            else {
               /*int		x, y;
               short		*shortbuf;
               unsigned long	onelong, *yP, mask;
               zoom		*z;

               thisObject->u.image.imgbuf =
                (unsigned long *)malloc(thisObject->width*thisObject->height*4);
               aimage = iopen(thisObject->u.image.filename, "r");
               shortbuf = (short *)malloc(thisObject->width*sizeof(short));
               z = newzoom(getimgrow,thisObject->u.image.orig_width,
                                     thisObject->u.image.orig_height,
                                     thisObject->width,
                                     thisObject->height,
                                     TRIANGLE,1.0);
               for(globalz=0; globalz<3; globalz++)
                  for(y=0; y<thisObject->height; y++) {
                     yP = &thisObject->u.image.imgbuf[y*thisObject->width];
                     getzoomrow(z,shortbuf,y);
                     mask = 0xFFFFFFFF - (0xFF << globalz*8);
                     for (x=0; x<thisObject->width; x++) {
                        onelong = shortbuf[x] << globalz*8;
                        yP[x] = yP[x] & mask;
                        yP[x] = yP[x] | onelong;
                        }
                     }
               freezoom(z);
               free(shortbuf);*/
               unsigned long *abuf;

               abuf = (unsigned long *)longimagedata(thisObject->u.image.filename);
               thisObject->u.image.imgbuf = (unsigned long *)malloc(thisObject->width*thisObject->height*sizeof(long));
               fastzoom(abuf,thisObject->u.image.imgbuf,
                        thisObject->u.image.orig_width,
                        thisObject->u.image.orig_height,
                        thisObject->width,
                        thisObject->height);
               }
            }
/*
 * Scale using the command set up for the Utah Raster Toolkit.
 */
         else {
            bufsiz = thisObject->width*thisObject->height*4;
            thisObject->u.image.imgbuf = (unsigned long *) malloc(bufsiz);
            if ((pixin = popen(cmd, "r")) == NULL)
               fprintf(stderr, "Cannot open pipe.\n");
            for (i=0; i<bufsiz/4; i++) {
               if ((fread(&thisObject->u.image.imgbuf[i], 3, 1, pixin)) != 1) {
                  fprintf(stderr, "Cannot get data from URT command.\n");
                  exit(1);
                  }
               thisObject->u.image.imgbuf[i] =
                              (thisObject->u.image.imgbuf[i] & 0xFFFFFF00) >> 8;
               }
            pclose(pixin);
            }
         }
/*
 * This buffer (imgbuf) will be freed if:
 *    - the image is resized (SelfCB)
 *    - the image is cut (CutCB)
 */
      lrectwrite((thisObject->decoration == BORDER?thisObject->dec_size:0),
                 (thisObject->decoration == 0?0:thisObject->dec_size),
                  thisObject->width-1 +
                 (thisObject->decoration == BORDER?thisObject->dec_size:0),
                  thisObject->height-1 +
                 (thisObject->decoration == 0?0:thisObject->dec_size),
                    thisObject->u.image.imgbuf);
/*
 * If this image completely fills the background and the window is being
 * dumped to an image file, the desi background will never get a refresh
 * event.  This is why I check here to see if a dump is pending.
 */
   if (dumppending > 0) {
      if (thisObject->width+thisObject->x >= desi.back.width &&
          thisObject->height+thisObject->y >= desi.back.height &&
          thisObject->x <= 0 &&
          thisObject->y <= 0 ) {
         DumpHandler();
         dumppending = 0;
         /*printf("Dumped desi window with a full size image as background.\n");*/
         }
      }

}


/*
 * This routine is called whenever an image object is resized.
 */
void
ResizeImageCB(w, client_data, call_data)
Widget                  w;
XtPointer               client_data;
GlxDrawCallbackStruct   *call_data;
{
   GenericInfo	*thisObject;
   double	xscale, yscale, scale;
   int		extra;

   thisObject = WidgetToObject(w);
   switch (thisObject->decoration) {
      case DROP_SHADOW:
         extra = thisObject->dec_size;
         break;
      case BORDER:
         extra = 2*thisObject->dec_size;
         break;
      default:
         extra = 0;
      }
   if (thisObject->width+extra != (int)call_data->width ||
       thisObject->height+extra != (int)call_data->height) {
      if (thisObject->u.image.keepaspect) {
         xscale = (double)((int)call_data->width-extra)/
                  thisObject->u.image.orig_width;
         yscale = (double)((int)call_data->height-extra)/
                  thisObject->u.image.orig_height;
         scale = ((xscale < yscale) ? xscale : yscale);
         thisObject->width = scale*thisObject->u.image.orig_width + 0.5;
         thisObject->height = scale*thisObject->u.image.orig_height + 0.5;
         }
      else { /* not keepaspect */
         thisObject->width =(int)call_data->width-extra;
         thisObject->height=(int)call_data->height-extra;
         }
      }
}


/*
 * This routine is called from the ImageHandler if we are creating
 * or if we are editing and a new file name was selected.
 */
static GenericInfo*
ReadHeader(Widget w, XtPointer client_data, char *call_data)
{
   FILE		*pixin, *fp;
   IMAGE	*image;
   GenericInfo	*thisObject;
   char		cmd[128];
   char		*hbuf;
   char		*index;
   char		*rlemapP, *rlealphaP;
   char		*periodP;
   double	xscale, yscale;
   int		nchan;
   int		bytesread;
/*
 * Create space to hold this object.
 */
   if (c_or_e == CREATING) {
      if ((thisObject = (GenericInfo *)malloc(sizeof(GenericInfo))) == NULL) {
         fprintf(stderr, "ERROR -- Unable to get memory for image.\n");
         exit(1);
         }
      }
   else
      thisObject = UmscListGetCurrent(theList);
   XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)call_data)->value, XmSTRING_DEFAULT_CHARSET,
                   &thisObject->u.image.filename);
/*
 * If we are running the automounter we have to get rid of that first part
 * of the pathname.  In other words change /tmp_mnt/circle/pi2/... to
 * /circle/pi2/...
 */
   /*index = strstr(thisObject->u.image.filename, "tmp_mnt");
   if (index) {
      index += 7;
      free(thisObject->u.image.filename);
      thisObject->u.image.filename = (char *)malloc(strlen(index));
      strcpy(thisObject->u.image.filename, index);
      }*/
/*
 * Abort if they didn't select a file name.
 */
   if (strlen(thisObject->u.image.filename) == 0) {
      isimage = -1;
      free(thisObject);
      thisObject = NULL;
      return thisObject;
      }
   if ((int)thisObject->u.image.filename[strlen(thisObject->u.image.filename)-1] == '/') {
      isimage = -1;
      free(thisObject);
      thisObject = NULL;
      return thisObject;
      }
   isimage = 1;
   needtosave = 1;
   if (c_or_e == CREATING) {
      thisObject->selected = False;
      thisObject->frame = currentFrame;
      thisObject->objtype = IMGOBJ;
      thisObject->u.image.keepaspect =
          XmToggleButtonGetState(XtNameToWidget(isb, "warea.frame.rc.keep"));
      thisObject->decoration = defaultInfo.decoration;
      thisObject->dec_size = defaultInfo.dec_size;
      thisObject->dec[0] = defaultInfo.dec[0];
      thisObject->dec[1] = defaultInfo.dec[1];
      thisObject->dec[2] = defaultInfo.dec[2];
      thisObject->u.image.imgbuf = NULL;
/*
 * I have to set the current pointer to the last item in the list
 * so that the new node is placed at the end (after the current).
 */
      UmscListSetCurrent(theList, UmscLAST);
      UmscListInsert(theList, thisObject, UmscNEXT);
      UmscListSetCurrent(theList, UmscLAST);
      }
/*
 * Get the name, etc.
 */
   periodP = strrchr(thisObject->u.image.filename,46);
   if (!periodP) {
      isimage = -2;
      free(thisObject);
      thisObject = NULL;
      return thisObject;
      }
   if (!strcmp(periodP,".rle"))
      sprintf(cmd, "rlehdr -b -h %s", thisObject->u.image.filename);
   else if (!strcmp(periodP,".gif")) {
      if ((fp = fopen(thisObject->u.image.filename, "r")) == NULL) {
         isimage = 0;
         free(thisObject);
         thisObject = NULL;
         return thisObject;
         }
      fread(cmd, 10, 1, fp);
      fclose(fp);
      thisObject->u.image.orig_width = (int)cmd[7]<<8 | (int)cmd[6];
      thisObject->u.image.orig_height = (int)cmd[9]<<8 | (int)cmd[8];
      }
   else if (!strcmp(periodP,".jpg"))
      sprintf(cmd, "djpeg -R %s | rlehdr -b -h", thisObject->u.image.filename);
   else if (!strcmp(periodP,".sgi") || !strcmp(periodP,".rgb")) {
      image = iopen(thisObject->u.image.filename,"r");
      if (!image) {
         isimage = 0;
         free(thisObject);
         thisObject = NULL;
         return thisObject;
         }
      thisObject->u.image.orig_width = image->xsize;
      thisObject->u.image.orig_height = image->ysize;
      iclose(image);
      }
   if (strcmp(periodP,".gif") &&
       strcmp(periodP,".sgi") &&
       strcmp(periodP,".rgb")) { /* not for gifs or sgi files */
      if ((hbuf = (char *) malloc(128)) == NULL)
         fprintf(stderr, "Cannot malloc 128 bytes.\n");
      if ((pixin = popen(cmd, "r")) == NULL)
         fprintf(stderr, "Cannot open pipe.\n");
      bytesread = fread(hbuf, 1, 127, pixin);
      if (bytesread == 0) {
         pclose(pixin);
         free(hbuf);
         isimage = 0;
         free(thisObject);
         thisObject = NULL;
         return thisObject;
         }
      pclose(pixin);
      hbuf[bytesread] = '\0';
      index = strrchr(hbuf, '[');
      sscanf(++index, "%d,%d", &thisObject->u.image.orig_width,
                                 &thisObject->u.image.orig_height);
      index = strchr(index, 'x');
      sscanf(++index, "%d", &nchan);
      if (nchan != 3) {
         free(hbuf);
         isimage = -3;
         free(thisObject);
         thisObject = NULL;
         return thisObject;
         }
      rlemapP = strstr(hbuf, "map");
      rlealphaP = strstr(hbuf, "+A");
      free(hbuf);
      }
   thisObject->width = thisObject->u.image.orig_width;
   thisObject->height = thisObject->u.image.orig_height;
/*
 * Is this image too big?
 */
   if (thisObject->u.image.orig_width > desi.back.width ||
       thisObject->u.image.orig_height > desi.back.height) {
      xscale = (double)desi.back.width/thisObject->u.image.orig_width;
      yscale = (double)desi.back.height/thisObject->u.image.orig_height;
      if (xscale < yscale) {
         thisObject->width  = xscale*thisObject->u.image.orig_width;
         thisObject->height = xscale*thisObject->u.image.orig_height;
         thisObject->x = desi.back.xoffset;
         thisObject->y = desi.back.yoffset +
                        (desi.back.height - thisObject->height)/2;
         }
       else {
         thisObject->width  = yscale*thisObject->u.image.orig_width;
         thisObject->height = yscale*thisObject->u.image.orig_height;
         thisObject->x = desi.back.xoffset +
                        (desi.back.width - thisObject->width)/2;
         thisObject->y = desi.back.yoffset;
         }
      sprintf(cmd, "%f", xscale);
      XmTextSetString(xtxt, cmd);
      sprintf(cmd, "%f", yscale);
      XmTextSetString(ytxt, cmd);
      }
   else {
      thisObject->width  = thisObject->u.image.orig_width;
      thisObject->height = thisObject->u.image.orig_height;
      if (c_or_e == CREATING) {
         thisObject->x = desi.back.xoffset +
                        (desi.back.width - thisObject->width)/2;
         thisObject->y = desi.back.yoffset +
                        (desi.back.height - thisObject->height)/2;
         }
      }
   return thisObject;
}


/*
 * This routine is called from ImageHandler when an image is created
 * or edited.  It checks the X and Y scale text widgets.
 */
void
ScaleHandler(GenericInfo *thisObject)
{
   Arg	args[10];
   int	n, extra;
   char	wxstr[20], wystr[20], *txstr, *tystr;
   double	xscale, yscale;

   thisObject->u.image.keepaspect =
       XmToggleButtonGetState(XtNameToWidget(isb, "warea.frame.rc.keep"));
   xscale = (double)thisObject->width / thisObject->u.image.orig_width;
   sprintf(wxstr, "%f", xscale);
   yscale = (double)thisObject->height/ thisObject->u.image.orig_height;
   sprintf(wystr, "%f", yscale);
   txstr = XmTextGetString(xtxt);
   tystr = XmTextGetString(ytxt);
   xscale = atof(txstr);
   yscale = atof(tystr);
   xscale = (xscale > 10 ? 1.0 : xscale);
   xscale = (xscale < .1 ? 1.0 : xscale);
   yscale = (yscale > 10 ? 1.0 : yscale);
   yscale = (yscale < .1 ? 1.0 : yscale);
   if (thisObject->u.image.keepaspect)
      xscale = yscale = (xscale > yscale ? yscale : xscale);
   if (thisObject->decoration == DROP_SHADOW)
      extra = thisObject->dec_size;
   else if (thisObject->decoration == BORDER)
      extra = 2*thisObject->dec_size;
   else
      extra = 0;
   n = 0;
   if (strcmp(wxstr, txstr)) {	/* is the X scale different? */
      thisObject->width = xscale * thisObject->u.image.orig_width + extra;
      XtSetArg(args[n], XmNwidth, (Dimension)thisObject->width); n++;
      free(thisObject->u.image.imgbuf);
      thisObject->u.image.imgbuf = NULL;
      }
   if (strcmp(wystr, tystr)) {	/* is the Y scale different? */
      thisObject->height = yscale * thisObject->u.image.orig_height+ extra;
      XtSetArg(args[n], XmNheight, (Dimension)thisObject->height); n++;
      free(thisObject->u.image.imgbuf);
      thisObject->u.image.imgbuf = NULL;
      }
   if (n == 0 &&
       thisObject->u.image.keepaspect &&
       strncmp(txstr, tystr, 4)) {
      thisObject->width = xscale * thisObject->u.image.orig_width + extra;
      thisObject->height= yscale * thisObject->u.image.orig_height+ extra;
      XtSetArg(args[n], XmNwidth, (Dimension)thisObject->width); n++;
      XtSetArg(args[n], XmNheight, (Dimension)thisObject->height); n++;
      free(thisObject->u.image.imgbuf);
      thisObject->u.image.imgbuf = NULL;
      }
   XtSetValues(thisObject->w, args, n);
   free(txstr);
   free(tystr);
   DrawImage(thisObject);
}


/*
 * This routine is called when the OK button is clicked after:
 *	- creating a new image
 *	- editing an existing image
 */
static void
ImageHandlerCB(Widget w, XtPointer client_data, char *call_data)
{
   Arg		args[10];
   GenericInfo	*thisObject;
   char		junk[80];
   int		n;
   int		found;

   if (c_or_e == CREATING) {
      thisObject = ReadHeader(w, client_data, call_data);
      if (isimage > 0) {
         CreateImage(thisObject);
         /*thisObject = UmscListGetCurrent(theList);*/
         ScaleHandler(thisObject);
         }
      else if (isimage == -1)
         fprintf(stderr, "No image selected.\n");
      else if (isimage == -2)
         fprintf(stderr, "This image file has no extension.\n");
      else if (isimage == -3) {
         fprintf(stderr, "This is not a 3-channel (RGB) image.  Do one of the following:\n");
         fprintf(stderr, "	- For an 8 bit grayscale image use rleswap -f 0,0,0\n");
         fprintf(stderr, "	- For an 8 bit colormapped image use applymap\n");
         }
      else
         fprintf(stderr, "Can't find that image.\n");
      }
   else { /* if EDITING */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      found = 0;
      while (!found) {
         if (!thisObject->w)
            thisObject = UmscListGetNext(theList);
         else if (XtParent(thisObject->w) != dw)
            thisObject = UmscListGetNext(theList);
         else
            found = 1;
         }
      strcpy(junk, thisObject->u.image.filename);
      XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)call_data)->value, XmSTRING_DEFAULT_CHARSET,
                                            &thisObject->u.image.filename);
/*
 * They removed the file name -- delete it.
 */
      if ((int)thisObject->u.image.filename[strlen(thisObject->u.image.filename)-1] == '/')
         CutCB((Widget)0, (XtPointer)0, (char *)0);
/*
 * Revert to original size.
 */
      else if (XmToggleButtonGetState(XtNameToWidget(isb, "warea.frame.rc.orig"))) {
         int extra;

         n = 0;
         XtSetArg(args[n], XmNsensitive, False); n++;
         XtSetArg(args[n], XmNset, False); n++;
         XtSetValues(XtNameToWidget(isb, "warea.frame.rc.orig"), args, n);
         thisObject->width = thisObject->u.image.orig_width;
         thisObject->height = thisObject->u.image.orig_height;
         if (thisObject->decoration == DROP_SHADOW)
            extra = thisObject->dec_size;
         else if (thisObject->decoration == BORDER)
            extra = 2*thisObject->dec_size;
         else
            extra = 0;
         n = 0;
         XtSetArg(args[n], XmNwidth, (Dimension)(thisObject->width+extra)); n++;
         XtSetArg(args[n], XmNheight, (Dimension)(thisObject->height+extra)); n++;
         XtSetValues(thisObject->w, args, n);
         free(thisObject->u.image.imgbuf);
         thisObject->u.image.imgbuf = NULL;
         DrawImage(thisObject);
         }
/*
 * The image file name has changed.
 */
      else if (strcmp(thisObject->u.image.filename, junk)) {
         thisObject = ReadHeader(w, client_data, call_data);
         n = 0;
         XtSetArg(args[n], XmNwidth, (Dimension)thisObject->width); n++;
         XtSetArg(args[n], XmNheight, (Dimension)thisObject->height); n++;
         XtSetValues(thisObject->w, args, n);
         free(thisObject->u.image.imgbuf);
         thisObject->u.image.imgbuf = NULL;
         DrawImage(thisObject);
         }
/*
 * Check the scales for this image.
 */
      else
         ScaleHandler(thisObject);
      }
}


/*
 * This routine creates the image selection box (isb).
 */
static void
ImageInfoPanelInit(void)
{
   int		n;
   Arg		args[10];
   Widget	warea,
		frame,
		rc,
		keep,
		orig,
		scalerc,
		xlab,
		ylab;
/*
 * Let the user pick an image file.
 */
   n = 0;
   isb = XmCreateFileSelectionDialog(desi.toplevel, "isb", args, n);
   XtUnmanageChild(XmFileSelectionBoxGetChild(isb, XmDIALOG_HELP_BUTTON));
   XtAddCallback(isb, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(isb, XmNokCallback, (XtCallbackProc)BusyCursorCB, NULL);
   XtAddCallback(isb, XmNokCallback, (XtCallbackProc)ImageHandlerCB, NULL);
   XtAddCallback(isb, XmNokCallback, (XtCallbackProc)UnBusyCursorCB, NULL);
   XtAddCallback(isb, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
/*
 * Add a rowcolumn thing to this image selection box.
 */
   n = 0;
   warea = XmCreateWorkArea(isb, "warea", args, n);
   XtManageChild(warea);
/*
 * Inside the work area put some unique things for images.
 */
   frame   = XtCreateManagedWidget("frame",xmFrameWidgetClass,    warea,args,0);
   rc      = XtCreateManagedWidget("rc",   xmRowColumnWidgetClass,frame,args,0);
   keep    = XtCreateManagedWidget("keep", xmToggleButtonWidgetClass,rc,args,0);
   orig    = XtCreateManagedWidget("orig", xmToggleButtonWidgetClass,rc,args,0);
   scalerc = XtCreateManagedWidget("scalerc",xmRowColumnWidgetClass, rc,args,0);
   xlab    = XtCreateManagedWidget("xlab", xmLabelWidgetClass,  scalerc,args,0);
   xtxt    = XtCreateManagedWidget("xtxt", xmTextWidgetClass,   scalerc,args,0);
   ylab    = XtCreateManagedWidget("ylab", xmLabelWidgetClass,  scalerc,args,0);
   ytxt    = XtCreateManagedWidget("ytxt", xmTextWidgetClass,   scalerc,args,0);
}



/*
 * This routine is called:
 *      - by ObjectMenuInit when the menu item is selected.
 *      - by SelfCB when an image object is double clicked.
 */
void
GetImageInfoCB(w, client_data, call_data)
Widget				w;
int				client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   Arg		args[10];
   GenericInfo	*thisObject;
   char		str[20];
   double	xscale, yscale;
   int		n;
   int		found;

   c_or_e = client_data;
   if (isb == NULL)
      ImageInfoPanelInit();
/*
 * If we are editing the image, stuff the info of the selected object into
 * the file selection box.
 */
   if (c_or_e == EDITING) {
      dw = w;	/* this is the sm widget that was double clicked */
/*
 * Find this object in the list.
 */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      found = 0;
      while (!found) {
         if (!thisObject->w)
            thisObject = UmscListGetNext(theList);
         else if (XtParent(thisObject->w) != dw)
            thisObject = UmscListGetNext(theList);
         else
            found = 1;
         }
/*
 * Put the image's filename into the image selection box.
 */
      n = 0;
      XtSetArg(args[n], XmNtextString,
               XmStringCreateSimple(thisObject->u.image.filename)); n++;
      XtSetValues(isb, args, n);
/*
 * If this image has been scaled, allow them to select the "orig" button.
 */
      if (thisObject->width != thisObject->u.image.orig_width ||
          thisObject->height != thisObject->u.image.orig_height) {
         n = 0;
         XtSetArg(args[n], XmNsensitive, True); n++;
         XtSetArg(args[n], XmNset, False); n++;
         XtSetValues(XtNameToWidget(isb, "warea.frame.rc.orig"), args, n);
         }
/*
 * Put the X and Y scales into the selection box.
 */
      xscale = (double)thisObject->width / thisObject->u.image.orig_width;
      yscale = (double)thisObject->height/ thisObject->u.image.orig_height;
      sprintf(str, "%f", xscale);
      XmTextSetString(xtxt, str);
      sprintf(str, "%f", yscale);
      XmTextSetString(ytxt, str);
      n = 0;
      XtSetArg(args[n], XmNsensitive, True); n++;
      XtSetValues(xtxt, args, n);
      XtSetValues(ytxt, args, n);
      }
   else {
      XmTextSetString(xtxt, "1.0");
      XmTextSetString(ytxt, "1.0");
      /*n = 0;
      XtSetArg(args[n], XmNsensitive, False); n++;
      XtSetValues(xtxt, args, n);
      XtSetValues(ytxt, args, n);*/
      }
   XtManageChild(isb);
}


/*
 * This routine will create an image object.
 */
void
CreateImage(GenericInfo *thisObject)
{
   Arg		args[10];
   Widget	selfMoving = CreateSelfM();
   int		n;
/*
 * Create a glx widget for the image.
 */
   n = 0;
   XtSetArg(args[n], GlxNglxConfig, glxConfig); n++;
   XtSetArg(args[n], XmNwidth, thisObject->width); n++;
   XtSetArg(args[n], XmNheight, thisObject->height); n++;
   thisObject->w = GlxCreateMDraw(selfMoving, "image", args, n);
/*
 * Add some callbacks.
 */
   XtAddCallback(selfMoving, XtNselectCallback, (XtCallbackProc)SelectCB, (XtPointer)thisObject);
   XtAddCallback(selfMoving, XtNunselectCallback, (XtCallbackProc)UnselectCB, (XtPointer)thisObject);
   XtAddCallback(selfMoving, XtNdoubleClickCallback, (XtCallbackProc)GetImageInfoCB, (char *)EDITING);
   XtAddCallback(selfMoving, XtNendResizeCallback, (XtCallbackProc)SelfCB, (char *)IMGOBJ);
   XtAddCallback(selfMoving, XtNendMoveCallback, (XtCallbackProc)SelfCB, (char *)NULL);

   /*XtAddCallback(thisObject->w, GlxNginitCallback, GlDrawCB, (char *)NULL);*/
   /*XtAddCallback(thisObject->w, GlxNresizeCallback, GlDrawCB, (char *)NULL)*/
   XtAddCallback(thisObject->w, GlxNresizeCallback, (XtCallbackProc)ResizeImageCB, (char *)NULL);
   XtAddCallback(thisObject->w, GlxNexposeCallback, (XtCallbackProc)BusyCursorCB, (char *)NULL);
   XtAddCallback(thisObject->w, GlxNexposeCallback, (XtCallbackProc)DrawObjectCB, (char *)NULL);
   XtAddCallback(thisObject->w, GlxNexposeCallback, (XtCallbackProc)UnBusyCursorCB, (char *)NULL);
/*
 * Place the image on the background.
 */
   n = 0;
   XtSetArg(args[n], XtNxChild, thisObject->x); n++;
   XtSetArg(args[n], XtNyChild, thisObject->y); n++;
   XtSetValues(selfMoving, args, n);

   XtManageChild(thisObject->w);
   XtManageChild(selfMoving);
}
