/*
 * file:     glcallbacks.c
 * author:   Wes Barris
 * date:     5/05/92
 * purpose:  handles all object/gl drawing
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <gl/gl.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <Xm/Xm.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI		desi;
extern UmscList		theList;
extern int		needtosave;
extern char		systype[10];


/*
 * This routine handles the callbacks for the selfmoving widgets which include:
 *	- after resizing
 *	- after moving
 */
void SelfCB(Widget w, XtPointer client_data, char *call_data)
{
   Arg		args[10];
   GenericInfo	*thisObject;
   int		n, found;

   switch (((HrAnyCallbackStruct *)call_data)->reason) {
      /*case HrCR_DOUBLE_CLICK:
         switch ((int)client_data) {
            case TXTOBJ:
               GetTextInfoCB(w, EDITING);
               break;
            case IMGOBJ:
               GetImageInfoCB(w, EDITING);
               break;
            case MAPOBJ:
               GetCmapInfoCB(w, EDITING);
               break;
            }
         break;*/
      case HrCR_END_RESIZE:	/* an image needs to have its buffer freed */
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         found = 0;
         while (!found) {
            if (!thisObject->w)
               thisObject = UmscListGetNext(theList);
            else if (XtParent(thisObject->w) != w)
               thisObject = UmscListGetNext(theList);
            else
               found = 1;
            }
         switch ((int)client_data) {
            case IMGOBJ:
               free(thisObject->u.image.imgbuf);
               thisObject->u.image.imgbuf = NULL;
               break;
            case MAPOBJ:
               free(thisObject->u.cmap.imgbuf);
               thisObject->u.cmap.imgbuf = NULL;
               break;
            }
      case HrCR_END_MOVE:	/* update origin after resize or move */
/*
 * Update the position of each selected object.
 */
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         while (thisObject) {
            if (thisObject->selected) {
               n = 0;
               XtSetArg(args[n], XtNxChild, &thisObject->x); n++;
               XtSetArg(args[n], XtNyChild, &thisObject->y); n++;
               XtGetValues(XtParent(thisObject->w), args, n);
               if (thisObject->objtype == TXTOBJ)
                  DrawText(thisObject);	/* update the text background */
               }
            thisObject = UmscListGetNext(theList);
            }
         needtosave = 1;
         break;
      case HrCR_DURING_RESIZE:
         break;
      default:
         fprintf(stderr, "unknown self callback\n");
      }
}


/*
 * This routine will create one instance of a selfmoving widget.  It is used
 * by CreateText, CreateImage, CreateCmap, etc.
 */
Widget
CreateSelfM(void)
{
   Arg		args[3];
   int		n;

   n = 0;
   XtSetArg(args[n], XtNshowHorizontalLine, GetXHairToggle()); n++;
   XtSetArg(args[n], XtNshowVerticalLine, GetXHairToggle()); n++;
   return(XtCreateWidget("self", hrSelfMovingWidgetClass, desi.container, args, n));
}


/*
 * This routine will correct a gl window sizing problem on some machines.
 */
void
myortho2(Coord xl, Coord xr, Coord yb, Coord yt)
{
/*
 * There seems to be a bug where only IP7s behave as explained in the
 * ortho2 man page.  All others have to be adjusted.
 */
   if (strncmp(systype, "GL4DPI", 6))	/* It's not a PI -- OK */
      ortho2(xl, xr, yb, yt);
   else					/* It's a PI -- fix the window */
      ortho2(xl+0.5, xr-0.5, yb+0.5, yt-0.5);
}


/*
 * This routine will get the rgb value of the background at any point.
 */
void
getrgb(int x, int y, short cv[3])
{
   int			n;
   /*unsigned char	topc, botc;*/
   int		topc, botc;

   for (n=0; n<=2; n++) {
      topc = ((double)x/(double)desi.back.width) * (desi.back.ur[n]-desi.back.ul[n])
           + desi.back.ul[n];
      botc = ((double)x/(double)desi.back.width) * (desi.back.lr[n]-desi.back.ll[n])
           + desi.back.ll[n];
      cv[n] = ((double)y/(double)desi.back.height) * (botc-topc) + topc;
      }
}


/*
 * This routine will simply draw a gl rectangle.  It is used for object borders
 * and the corners of an image or cmap with a drop shadow.
 */
void
rectangle(short x1, short x2, short y1, short y2)
{
   short vert[2];
   bgnpolygon();
      vert[0]=x1;	vert[1]=y2;	v2s(vert);
      vert[0]=x2;	vert[1]=y2;	v2s(vert);
      vert[0]=x2;	vert[1]=y1;	v2s(vert);
      vert[0]=x1;	vert[1]=y1;	v2s(vert);
   endpolygon();
}


/*
 * Given the object, this routine should be called to draw itself.
 */
void
DrawObject(GenericInfo *thisObject)
{
   switch (thisObject->objtype) {
      case TXTOBJ:
         DrawText(thisObject);
         break;
      case IMGOBJ:
         DrawImage(thisObject);
         break;
      case MAPOBJ:
         DrawCmap(thisObject);
         break;
      default:
         fprintf(stderr, "I don't know how to draw object type: %d\n",
                 thisObject->objtype);
      }
}


/*
 * Given the object type, this routine should be called to create itself.
 */
void
CreateObject(GenericInfo *thisObject)
{
   switch (thisObject->objtype) {
      case TXTOBJ:
         CreateText(thisObject);
         break;
      case IMGOBJ:
         CreateImage(thisObject);
         break;
      case MAPOBJ:
         CreateCmap(thisObject);
         break;
      default:
         fprintf(stderr, "I don't know how to create object type: %d\n",
                 thisObject->objtype);
      }
}


/*
 * Given the widget, this routine will find the object.
 */
GenericInfo*
WidgetToObject(Widget w)
{
   GenericInfo		*thisObject;
/*
 * Find this object in the list.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   while (thisObject->w != w) {
      thisObject = UmscListGetNext(theList);
      if (!thisObject) {
         printf("Null object?!? -- aborting.\n");
         return (GenericInfo *)0;
         }
      }
   return thisObject;
}


/*
 * Given the widget, this routine should be called to draw itself.
 */
void
DrawWidget(Widget w)
{
   DrawObject(WidgetToObject(w));
}


/*
 * This routine is called by Xt whenever an object needs to be refreshed.
 * It removes any extraneous events and calls DrawWidget.
 */
void
DrawObjectCB(Widget w, XtPointer client_data, char *call_data)
{
   while (XCheckWindowEvent(XtDisplay(w),
          ((GlxDrawCallbackStruct *)call_data)->window,
          ExposureMask, ((GlxDrawCallbackStruct *)call_data)->event)) {
      /*printf("Discarded an expose event.\n");*/
      ;
      }
   DrawWidget(w);
}


/*
 * This routine is used to initialize a glx widget.  It only has to set the
 * viewport so it can also be used for resizing.
 */
void
GLInitCB(Widget w, XtPointer client_data, char *call_data)
{
   switch (((GlxDrawCallbackStruct *)call_data)->reason) {
      case GlxCR_GINIT:
         XSetErrorHandler(0);
      case GlxCR_RESIZE:
         GLXwinset(XtDisplay(w), ((GlxDrawCallbackStruct *)call_data)->window);
         viewport(0, (Screencoord)((GlxDrawCallbackStruct *)call_data)->width-1,
                  0, (Screencoord)((GlxDrawCallbackStruct *)call_data)->height-1);
         myortho2(-0.5, (Coord)((GlxDrawCallbackStruct *)call_data)->width-0.5,
                  -0.5, (Coord)((GlxDrawCallbackStruct *)call_data)->height-0.5);
         break;
      default:
         fprintf(stderr, "WARNING -- Unknown reason in GLInitCB.\n");
      }
}
