/*
 * file:     alignMenu.c
 * author:   Wes Barris
 * date:     3/2/92
 * purpose:  creates Align pull-right menu
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/StringDefs.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern UmscList	theList;
extern int	needtosave;

static void
AlignCB(w, alignment)
Widget	w;
caddr_t	alignment;
{
   Arg		args[3];
   GenericInfo	*thisObject;
   Dimension	x, y, width, height;
   int		i, j, n;
   Boolean	selected;
/*
 * Are there any selected text objects?
 */
   /*thisObject = LlSetCurrent(theList, LlSET_FIRST);*/
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->selected == True) {
         needtosave = 1;
/*
 * Allignment needs to be set on only the first one.
 */
         n = 0;
         XtSetArg(args[n], XtNalignment, alignment); n++;
         XtSetValues(XtParent(thisObject->w), args, n);
         n = 0;
         XtSetArg(args[n], XtNxChild, &x); n++;
         XtSetArg(args[n], XtNyChild, &y); n++;
         XtGetValues(XtParent(thisObject->w), args, n);
/*
 * Store the new origin of each selected object.
 */
         for (j=i; j<UmscListGetCount(theList); j++) {
            if (thisObject->selected == True) {
               n = 0;
               XtSetArg(args[n], XtNxChild, &thisObject->x); n++;
               XtSetArg(args[n], XtNyChild, &thisObject->y); n++;
               XtGetValues(XtParent(thisObject->w), args, n);
               }
            /*thisObject = LlNextObj(theList);*/
            thisObject = UmscListGetNext(theList);
            }
         return;
         }
      /*thisObject = LlNextObj(theList);*/
      thisObject = UmscListGetNext(theList);
      }
}

static struct {
	char	*name;			/* name of menu item widget */
	void	(*func)();		/* callback function */
	caddr_t	data;			/* client data */
	} items[] = {
		{ "left",	AlignCB,	(caddr_t)HrALIGN_LEFT},
		{ "right",	AlignCB,	(caddr_t)HrALIGN_RIGHT},
		{ "top",	AlignCB,	(caddr_t)HrALIGN_TOP},
		{ "bottom",	AlignCB,	(caddr_t)HrALIGN_BOTTOM},
		{ "horizCtr",	AlignCB,	(caddr_t)HrALIGN_CENTER},
		{ "verticalCtr",AlignCB,	(caddr_t)HrALIGN_CENTER_VERTICAL},
		};

void
AlignMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	alignMenu,
		w;
/*
 * Create the Align menu.
 */
   n = 0;
   alignMenu = XmCreatePulldownMenu(parent, "alignMenu", arg, n);
/*
 * Create the entries for the align menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreatePushButton(alignMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].func, items[i].data);
         }
      else 
         w = XmCreateSeparator(alignMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the Align cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, alignMenu); n++;
   w = XmCreateCascadeButton(parent, "align", arg, n);
   XtManageChild(w);
}
