/*
 * file:     about.c
 * author:   Wes Barris
 * date:     7/23/92
 * purpose:  handles "about" and "suggestions"
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>

extern DESI	desi;


static Widget	aboutPanel = NULL,
		mailPanel = NULL;

/*
 * This routine mails a message to me.
 */
static void
MailMessageCB(Widget w, XtPointer client_data, char *call_data)
{
   FILE	*fp;
   char	*text;
/*
 * Use a pipe to send the message.
 */
   text = XmTextGetString(XmSelectionBoxGetChild(mailPanel, XmDIALOG_TEXT));
   fp = popen("Mail -s 'Desi Message' wes@msc.edu", "w");
   fprintf(fp, "%s\n", text);
   pclose(fp);
   free(text);
}


/*
 * This routine creates the Mail panel.
 */
static void
MailInit(void)
{
   int		n;
   Arg		args[10];

/*
 * Let the user type in the text.
 */
   n = 0;
   mailPanel = XmCreatePromptDialog(desi.toplevel, "mailPanel", args, n);
   XtUnmanageChild(XmSelectionBoxGetChild(mailPanel, XmDIALOG_HELP_BUTTON));
   n = 0;
   XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
   XtSetArg(args[n], XmNrows, 10); n++;
   XtSetValues(XmSelectionBoxGetChild(mailPanel, XmDIALOG_TEXT), args, n);
   XtAddCallback(mailPanel, XmNokCallback, (XtCallbackProc)MailMessageCB, NULL);
}

/*
 * This routine displays the Mail panel.
 */
void
MailCB(Widget w, XtPointer client_data, char *call_data)
{
   XtUnmanageChild(w);
   if (mailPanel == NULL)
      MailInit();
   XtManageChild(mailPanel);
}



/*
 * AboutInit:  creates (but does not manage) About panel.
 */
static void
AboutInit(void)
{
   int		n;
   Arg		args[10];
   /*Pixmap	desiPixmap;*/
/*
 * Create the panel.
 */
   n = 0;
   aboutPanel = XmCreateInformationDialog(desi.toplevel, "aboutPanel", args, n);
   XtUnmanageChild(XmMessageBoxGetChild(aboutPanel, XmDIALOG_CANCEL_BUTTON));
   /*XtAddCallback(aboutPanel, XmNhelpCallback, XtUnmanageChild, aboutPanel);*/
   /*XtAddCallback(aboutPanel, XmNhelpCallback, XtUnmanageChild, NULL);*/
   XtAddCallback(aboutPanel, XmNhelpCallback, (XtCallbackProc)MailCB, NULL);

   /*desiPixmap = XCreateBitmapFromData(XtDisplay(desi.toplevel),
                                   XtScreen(desi.toplevel)->root,
                                   xrn_bits, xrn_width, xrn_height);*/
   /*n = 0;
   XtSetArg(args[n], XmNsymbolPixmap,
            XmGetPixmap(XtScreen(desi.toplevel), "desiIcon", 0, 0)); n++;
   XtSetValues(aboutPanel, args, n);*/
}



/*
 * Display the about panel.
 */
void
AboutCB(Widget w, XtPointer client_data, char *call_data)
{
   if (aboutPanel == NULL)
      AboutInit();
   XtManageChild(aboutPanel);
}
