/* triangle.c */


/*
 * New triangle rasterizer.  This isn't used yet but may be in the future...
 */


#include <assert.h>
#include <stdio.h>
#include "context.h"
#include "dd.h"
#include "interp.h"
#include "span.h"
#include "vb.h"



#define SWAP( A, B, TMP )  { TMP = A;  A = B;  B = TMP; }


#define LINTERP( T, A, B )  ( (A) + (T) * ((B) - (A)) )



static GLint COMPUTE_PLANE_Z( GLfloat x, GLfloat y )
{
   GLfloat fz;

   fz = (CC.PlaneD - CC.PlaneA*x - CC.PlaneB*y) / CC.PlaneC;

   if (fz<0.0F) {
      return 0;
   }
   else if (fz>1.0F) {
      return MAX_DEPTH;
   }

   return (GLint) (fz * DEPTH_SCALE);
}


#define m_COMPUTE_PLANE_Z( X, Y )			\
   ((GLint) (((CC.PlaneD - CC.PlaneA*(X) - CC.PlaneB*(Y)) / CC.PlaneC) * DEPTH_SCALE))


static void trap_color( GLint y0, GLint y1,
		        GLfloat lx, GLfloat dlx,   GLfloat rx, GLfloat drx,
		        GLfloat lr, GLfloat dlr,   GLfloat rr, GLfloat drr,
		        GLfloat lg, GLfloat dlg,   GLfloat rg, GLfloat drg,
		        GLfloat lb, GLfloat dlb,   GLfloat rb, GLfloat drb,
		        GLfloat la, GLfloat dla,   GLfloat ra, GLfloat dra )
{
   GLint y;

   for (y=y0;y<y1;y++) {
      /* span at y from lx to rx */
      GLint x0 = (GLint) (lx+0.5);
      GLint x1 = (GLint) (rx-0.5);
      GLint len = x1-x0+1;
      if (len>0) {
	 GLint zspan[MAX_WIDTH];
	 GLint z0 = COMPUTE_PLANE_Z( (GLfloat) x0 + 0.5, (GLfloat) y + 0.5 );
	 GLint z1 = COMPUTE_PLANE_Z( (GLfloat) (x0+len-1) + 0.5, (GLfloat) y + 0.5 );
	 GLint r0 = (GLint) lr, r1 = (GLint) rr;
	 GLint g0 = (GLint) lg, g1 = (GLint) rg;
	 GLint b0 = (GLint) lb, b1 = (GLint) rb;
	 GLint a0 = (GLint) la, a1 = (GLint) ra;
	 GLubyte red[MAX_WIDTH], green[MAX_WIDTH];
	 GLubyte blue[MAX_WIDTH], alpha[MAX_WIDTH];
	 GL_INTERPOLATE_I( len, z0, z1, zspan );
	 GL_INTERPOLATE_UB( len, r0, r1, red );
	 GL_INTERPOLATE_UB( len, g0, g1, green );
	 GL_INTERPOLATE_UB( len, b0, b1, blue );
	 GL_INTERPOLATE_UB( len, a0, a1, alpha );
	 gl_write_color_span( len, x0, y, zspan,
			      red, green, blue, alpha, GL_POLYGON );
      }
      lx += dlx;   rx += drx;
      lr += dlr;   rr += drr;
      lg += dlg;   rg += drg;
      lb += dlb;   rb += drb;
      la += dla;   ra += dra;
   }
}





/*
 * Newest as of July 29, 1995
 */
void gl_color_triangle5( GLuint v0, GLuint v1, GLuint v2, GLuint pv )
{
   GLuint min, mid, max;
   GLint ymin, ymid, ymax;
   GLfloat dy_mid_min, dy_max_min, dy_max_mid;

   dd_color( VB.Color[pv] );

#define WinX(i)  VB.Win[i][0]
#define WinY(i)  VB.Win[i][1]
#define WinZ(i)  VB.Win[i][2]


   /* find the order of the 3 vertices along the Y axis */
   {
      register GLfloat y0, y1, y2;

      y0 = WinY(v0);
      y1 = WinY(v1);
      y2 = WinY(v2);

      if (y0<=y1) {
	 if (y1<=y2) {	 /* y0<=y1<=y2 */
	    min = v0;   mid = v1;   max = v2;
	 }
	 else if (y2<=y0) {
	    /* y2<=y0<=y1 */
	    min = v2;   mid = v0;   max = v1;
	 }
	 else {
	    /* y0<=y2<=y1 */
	    min = v0;   mid = v2;   max = v1;
	 }
      }
      else {
	 /* y1<y0... */
	 if (y0<=y2) {
	    /* y1<=y0<=y2 */
	    min = v1;   mid = v0;   max = v2;
	 }
	 else if (y2<=y1) {
	    /* y2<=y1<=y0 */
	    min = v2;   mid = v1;   max = v0;
	 }
	 else {
	    /* y1<=y2<=y0 */
	    min = v1;   mid = v2;   max = v0;
	 }
      }

      assert( WinY(min) <= WinY(min) );
      assert( WinY(mid) <= WinY(max) );
   }

   ymin = (GLint) (WinY(min)+0.5);      /* add .5??? */
   ymid = (GLint) (WinY(mid) + 0.5);
   ymax = (GLint) (WinY(max)+0.5);      /* add .5??? */

   dy_mid_min = WinY(mid) - WinY(min);
   dy_max_min = WinY(max) - WinY(min);
   dy_max_mid = WinY(max) - WinY(mid);

/* Assume we have a triangle with vertices like:

   Y
   |        *max
   |
   | mid*
   |
   |          *min
   +----------------X
*/
   /*
    * Draw bottom half (from ymin up to ymid)
    */
   if (dy_mid_min>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat fudge;
      GLfloat red0, green0, blue0, alpha0;
      GLfloat dlr, drr, dlg, drg, dlb, drb, dla, dra;

/*      printf("drawing bottom\n");*/

      /* compute left and right edges' dx/dy */
      /* assume mid is left of max */
      dlx = (WinX(mid)-WinX(min)) / dy_mid_min;
      drx = (WinX(max)-WinX(min)) / dy_max_min;

      /* color */
      red0 = VB.Color[min][0] * CC.RedScale;
      dlr = (VB.Color[mid][0]-VB.Color[min][0]) / dy_mid_min * CC.RedScale;
      drr = (VB.Color[max][0]-VB.Color[min][0]) / dy_max_min * CC.RedScale;
      green0 = VB.Color[min][1] * CC.GreenScale;
      dlg = (VB.Color[mid][1]-VB.Color[min][1]) / dy_mid_min * CC.GreenScale;
      drg = (VB.Color[max][1]-VB.Color[min][1]) / dy_max_min * CC.GreenScale;
      blue0 = VB.Color[min][2] * CC.BlueScale;
      dlb = (VB.Color[mid][2]-VB.Color[min][2]) / dy_mid_min * CC.BlueScale;
      drb = (VB.Color[max][2]-VB.Color[min][2]) / dy_max_min * CC.BlueScale;
      alpha0 = VB.Color[min][3] * CC.AlphaScale;
      dla = (VB.Color[mid][3]-VB.Color[min][3]) / dy_mid_min * CC.AlphaScale;
      dra = (VB.Color[max][3]-VB.Color[min][3]) / dy_max_min * CC.AlphaScale;

      if (dlx>drx) {
	 /* wrong assumption */
	 GLfloat tmp;
	 SWAP( dlx, drx, tmp );
	 SWAP( dlr, drr, tmp );
	 SWAP( dlg, drg, tmp );
	 SWAP( dlb, drb, tmp );
	 SWAP( dla, dra, tmp );
      }

      assert( dlx<=drx );   /* edges should diverge */

      fudge = ymin + 0.5 - WinY(min);  /* adjust to pixel centers */
      lx = WinX(min) + dlx * fudge;
      rx = WinX(min) + drx * fudge;

      trap_color( ymin, ymid, lx, dlx, rx, drx,
		  red0, dlr, red0, drr,
		  green0, dlg, green0, drg,
		  blue0, dlb, blue0, drb,
		  alpha0, dla, alpha0, dra );
   }


   /*
    * Draw top half (from ymid up to ymax)
    */
   if (dy_max_mid>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat fudge;

      GLfloat t = (dy_mid_min) / (dy_max_min);
      GLfloat newx = LINTERP( t, WinX(min), WinX(max) );

      GLfloat lr, rr, lb, rb, lg, rg, la, ra;
      GLfloat dlr, drr, dlg, drg, dlb, drb, dla, dra;

/*      printf("drawing top\n");*/

      /* this adjusts values to pixel centers */
      fudge = ymid + 0.5 - WinY(mid);
/*      printf("fudge %f\n", fudge);*/
      if (fudge<0.0) {
	 fudge = 0.0;
      }

      if (WinX(mid) < newx) {
	 /* mid is left side of triangle */
	 dlx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 lx = WinX(mid) + dlx * fudge;
	 drx = (WinX(max)-WinX(min)) / dy_max_min;
	 rx = newx + drx * fudge;

	 /* color */
	 lr = VB.Color[mid][0] * CC.RedScale;
	 dlr = (VB.Color[max][0]-VB.Color[mid][0]) / dy_max_mid * CC.RedScale;
	 rr = LINTERP( t, VB.Color[min][0], VB.Color[max][0] ) * CC.RedScale;
	 drr = (VB.Color[max][0]-VB.Color[min][0]) / dy_max_min * CC.RedScale;

	 lg = VB.Color[mid][1] * CC.GreenScale;
	 dlg = (VB.Color[max][1]-VB.Color[mid][1]) / dy_max_mid * CC.GreenScale;
	 rg = LINTERP( t, VB.Color[min][1], VB.Color[max][1] ) * CC.GreenScale;
	 drg = (VB.Color[max][1]-VB.Color[min][1]) / dy_max_min * CC.GreenScale;

	 lb = VB.Color[mid][2] * CC.BlueScale;
	 dlb = (VB.Color[max][2]-VB.Color[mid][2]) / dy_max_mid * CC.GreenScale;
	 rb = LINTERP( t, VB.Color[min][2], VB.Color[max][2] ) * CC.BlueScale;
	 drb = (VB.Color[max][2]-VB.Color[min][2]) / dy_max_min * CC.GreenScale;

	 la = VB.Color[mid][3] * CC.AlphaScale;
	 dla = (VB.Color[max][3]-VB.Color[mid][3]) / dy_max_mid * CC.AlphaScale;
	 ra = LINTERP( t, VB.Color[min][3], VB.Color[max][3] ) * CC.AlphaScale;
	 dra = (VB.Color[max][3]-VB.Color[min][3]) / dy_max_min * CC.AlphaScale;
      }
      else {
	 /* mid is on right side of triangle */
	 dlx = (WinX(max)-WinX(min)) / dy_max_min;
	 lx = newx + dlx * fudge;
	 drx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 rx = WinX(mid) + drx * fudge;

	 /* color */
	 lr = LINTERP( t, VB.Color[min][0], VB.Color[max][0] ) * CC.RedScale;
	 dlr = (VB.Color[max][0]-VB.Color[min][0]) / dy_max_min * CC.RedScale;
	 rr = VB.Color[mid][0] * CC.RedScale;
	 drr = (VB.Color[max][0]-VB.Color[mid][0]) / dy_max_mid * CC.RedScale;

	 lg = LINTERP( t, VB.Color[min][1], VB.Color[max][1] ) * CC.GreenScale;
	 dlg = (VB.Color[max][1]-VB.Color[min][1]) / dy_max_min * CC.GreenScale;
	 rg = VB.Color[mid][1] * CC.GreenScale;
	 drg = (VB.Color[max][1]-VB.Color[mid][1]) / dy_max_mid * CC.GreenScale;

	 lb = LINTERP( t, VB.Color[min][2], VB.Color[max][2] ) * CC.BlueScale;
	 dlb = (VB.Color[max][2]-VB.Color[min][2]) / dy_max_min * CC.BlueScale;
	 rb = VB.Color[mid][2] * CC.BlueScale;
	 drb = (VB.Color[max][2]-VB.Color[mid][2]) / dy_max_mid * CC.BlueScale;

	 la = LINTERP( t, VB.Color[min][3], VB.Color[max][3] ) * CC.AlphaScale;
	 dla = (VB.Color[max][3]-VB.Color[min][3]) / dy_max_min * CC.AlphaScale;
	 ra = VB.Color[mid][3] * CC.AlphaScale;
	 dra = (VB.Color[max][3]-VB.Color[mid][3]) / dy_max_mid * CC.AlphaScale;
      }

/*      assert( dlx >= drx ); */  /* slopes should converge */

      trap_color( ymid, ymax, lx, dlx, rx, drx,
		  lr, dlr, rr, drr,
		  lg, dlg, rg, drg,
		  lb, dlb, rb, drb,
		  la, dla, ra, dla );
   }

}




static void trap_monocolor( GLint y0, GLint y1,
			    GLfloat lx, GLfloat dlx,   GLfloat rx, GLfloat drx,
			    GLfloat color[4] )
{
   GLint y;

/*   printf("trap slopes: %f %f\n", dlx, drx );*/

   for (y=y0;y<y1;y++) {
      /* span at y from lx to rx */
      GLint x0 = (GLint) (lx+0.5);
      GLint x1 = (GLint) (rx-0.5);
      GLint len = x1-x0+1;
      if (len>0) {
	 GLint zspan[MAX_WIDTH];
	 GLint z0 = COMPUTE_PLANE_Z( (GLfloat) x0 + 0.5, (GLfloat) y + 0.5 );
	 GLint z1 = COMPUTE_PLANE_Z( (GLfloat) (x0+len-1) + 0.5, (GLfloat) y + 0.5 );

	 GL_INTERPOLATE_I( len, z0, z1, zspan );
	 gl_write_monocolor_span( len, x0, y, zspan, color, GL_POLYGON );
      }
      lx += dlx;   rx += drx;
   }
}





/*
 * Newest as of July 29, 1995
 */
void gl_triangle5( GLuint v0, GLuint v1, GLuint v2, GLuint pv )
{
   GLuint min, mid, max;
   GLint ymin, ymid, ymax;
   GLfloat dy_mid_min, dy_max_min, dy_max_mid;

   dd_color( VB.Color[pv] );

#define WinX(i)  VB.Win[i][0]
#define WinY(i)  VB.Win[i][1]
#define WinZ(i)  VB.Win[i][2]


   /* find the order of the 3 vertices along the Y axis */
   {
      register GLfloat y0, y1, y2;

      y0 = WinY(v0);
      y1 = WinY(v1);
      y2 = WinY(v2);

      if (y0<=y1) {
	 if (y1<=y2) {	 /* y0<=y1<=y2 */
	    min = v0;   mid = v1;   max = v2;
	 }
	 else if (y2<=y0) {
	    /* y2<=y0<=y1 */
	    min = v2;   mid = v0;   max = v1;
	 }
	 else {
	    /* y0<=y2<=y1 */
	    min = v0;   mid = v2;   max = v1;
	 }
      }
      else {
	 /* y1<y0... */
	 if (y0<=y2) {
	    /* y1<=y0<=y2 */
	    min = v1;   mid = v0;   max = v2;
	 }
	 else if (y2<=y1) {
	    /* y2<=y1<=y0 */
	    min = v2;   mid = v1;   max = v0;
	 }
	 else {
	    /* y1<=y2<=y0 */
	    min = v1;   mid = v2;   max = v0;
	 }
      }

      assert( WinY(min) <= WinY(min) );
      assert( WinY(mid) <= WinY(max) );
   }

   ymin = (GLint) (WinY(min)+0.5);      /* add .5??? */
   ymid = (GLint) (WinY(mid) + 0.5);
   ymax = (GLint) (WinY(max)+0.5);      /* add .5??? */

   dy_mid_min = WinY(mid) - WinY(min);
   dy_max_min = WinY(max) - WinY(min);
   dy_max_mid = WinY(max) - WinY(mid);

/* Assume we have a triangle with vertices like:

   Y
   |        *max
   |
   | mid*
   |
   |          *min
   +----------------X
*/
   /*
    * Draw bottom half (from ymin up to ymid)
    */
   if (dy_mid_min>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat fudge;

/*      printf("drawing bottom\n");*/

      /* compute left and right edges' dx/dy */
      /* assume mid is left of max */
      dlx = (WinX(mid)-WinX(min)) / dy_mid_min;
      drx = (WinX(max)-WinX(min)) / dy_max_min;

      if (dlx>drx) {
	 /* wrong assumption */
	 GLfloat tmp;
	 SWAP( dlx, drx, tmp );
      }

      assert( dlx<=drx );   /* edges should diverge */

      fudge = ymin + 0.5 - WinY(min);  /* adjust to pixel centers */
      lx = WinX(min) + dlx * fudge;
      rx = WinX(min) + drx * fudge;

      trap_monocolor( ymin, ymid, lx, dlx, rx, drx, VB.Color[pv] );
   }


   /*
    * Draw top half (from ymid up to ymax)
    */
   if (dy_max_mid>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat fudge;

      GLfloat t = (dy_mid_min) / (dy_max_min);
      GLfloat newx = LINTERP( t, WinX(min), WinX(max) );

/*      printf("drawing top\n");*/

      /* this adjusts values to pixel centers */
      fudge = ymid + 0.5 - WinY(mid);
/*      printf("fudge %f\n", fudge);*/
      if (fudge<0.0) {
	 fudge = 0.0;
      }

      if (WinX(mid) < newx) {
	 /* mid is left side of triangle */
	 dlx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 lx = WinX(mid) + dlx * fudge;
	 drx = (WinX(max)-WinX(min)) / dy_max_min;
	 rx = newx + drx * fudge;
      }
      else {
	 /* mid is on right side of triangle */
	 dlx = (WinX(max)-WinX(min)) / dy_max_min;
	 lx = newx + dlx * fudge;
	 drx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 rx = WinX(mid) + drx * fudge;
      }

/*      assert( dlx >= drx ); */  /* slopes should converge */

      trap_monocolor( ymid, ymax, lx, dlx, rx, drx, VB.Color[pv] );
   }

}





static void trap_z_monocolor( GLint y0, GLint y1,
			   GLfloat lx, GLfloat dlx,   GLfloat rx, GLfloat drx,
			   GLfloat lz, GLfloat dlz,   GLfloat rz, GLfloat drz,
			   GLfloat color[4] )
{
   GLint y;

   printf("trap slopes: %f %f\n", dlx, drx );

   for (y=y0;y<y1;y++) {
      /* span at y from lx to rx */
      GLint x0 = (GLint) (lx+0.5);
      GLint x1 = (GLint) (rx-0.5);
      GLint len = x1-x0+1;
      if (len>0) {
	 GLint zspan[MAX_WIDTH];
	 GLfloat dzdx = (rz-lz) / (rx-lx);
	 GLfloat lfudge = (x0 + 0.5 - lx) * dzdx;
	 GLfloat rfudge = (x1 + 0.5 - rx) * dzdx;

	 GLint z0 = (GLint) ((lz+lfudge) * DEPTH_SCALE);
	 GLint z1 = (GLint) ((rz+rfudge) * DEPTH_SCALE);

/*
	 GLint z0 = COMPUTE_PLANE_Z( (GLfloat) x0 + 0.5, (GLfloat) y + 0.5 );
	 GLint z1 = COMPUTE_PLANE_Z( (GLfloat) (x0+len-1) + 0.5, (GLfloat) y + 0.5 );
*/

	 GL_INTERPOLATE_I( len, z0, z1, zspan );
	 gl_write_monocolor_span( len, x0, y, zspan, color, GL_POLYGON );
      }
      lx += dlx;   rx += drx;
      lz += dlz;   rz += drz;
   }
}




/*
 * Newest as of Jun 13, 1995
 */
void gl_triangle4( GLuint v0, GLuint v1, GLuint v2, GLuint pv )
{
   GLuint min, mid, max;
   GLint ymin, ymid, ymax;
   GLfloat dy_mid_min, dy_max_min, dy_max_mid;
   GLfloat X[1000], Y[1000], Z[1000];

   dd_color( VB.Color[pv] );


#ifdef TRUNC
   X[v0] = (GLfloat) (VB.WinX[v0] >> SUB_PIX_SHIFT);
   Y[v0] = (GLfloat) (VB.WinY[v0] >> SUB_PIX_SHIFT);
   Z[v0] = (GLfloat) VB.WinZ[v0];

   X[v1] = (GLfloat) (VB.WinX[v1] >> SUB_PIX_SHIFT);
   Y[v1] = (GLfloat) (VB.WinY[v1] >> SUB_PIX_SHIFT);
   Z[v1] = (GLfloat) VB.WinZ[v1];

   X[v2] = (GLfloat) (VB.WinX[v2] >> SUB_PIX_SHIFT);
   Y[v2] = (GLfloat) (VB.WinY[v2] >> SUB_PIX_SHIFT);
   Z[v2] = (GLfloat) VB.WinZ[v2];
#endif
#ifdef TRUNC2
   X[v0] = (GLfloat) (VB.WinX[v0] >> 6) / 4.0;
   Y[v0] = (GLfloat) (VB.WinY[v0] >> 6) / 4.0;
   Z[v0] = (GLfloat) VB.WinZ[v0];

   X[v1] = (GLfloat) (VB.WinX[v1] >> 6) / 4.0;
   Y[v1] = (GLfloat) (VB.WinY[v1] >> 6) / 4.0;
   Z[v1] = (GLfloat) VB.WinZ[v1];

   X[v2] = (GLfloat) (VB.WinX[v2] >> 6) / 4.0;
   Y[v2] = (GLfloat) (VB.WinY[v2] >> 6) / 4.0;
   Z[v2] = (GLfloat) VB.WinZ[v2];
#endif
#define NORM
#ifdef NORM
   X[v0] = VB.WinX[v0] / SUB_PIX_SCALE;
   Y[v0] = VB.WinY[v0] / SUB_PIX_SCALE;
   Z[v0] = (GLfloat) VB.WinZ[v0];

   X[v1] = VB.WinX[v1] / SUB_PIX_SCALE;
   Y[v1] = VB.WinY[v1] / SUB_PIX_SCALE;
   Z[v1] = (GLfloat) VB.WinZ[v1];

   X[v2] = VB.WinX[v2] / SUB_PIX_SCALE;
   Y[v2] = VB.WinY[v2] / SUB_PIX_SCALE;
   Z[v2] = (GLfloat) VB.WinZ[v2];
#endif


/*
#define WinX(i)  X[i]
#define WinY(i)  Y[i]
#define WinZ(i)  Z[i]
*/
#define WinX(i)  VB.Win[i][0]
#define WinY(i)  VB.Win[i][1]
#define WinZ(i)  VB.Win[i][2]


   /* find the order of the 3 vertices along the Y axis */
   {
      register GLfloat y0, y1, y2;

      y0 = WinY(v0);
      y1 = WinY(v1);
      y2 = WinY(v2);

      if (y0<=y1) {
	 if (y1<=y2) {	 /* y0<=y1<=y2 */
	    min = v0;   mid = v1;   max = v2;
	 }
	 else if (y2<=y0) {
	    /* y2<=y0<=y1 */
	    min = v2;   mid = v0;   max = v1;
	 }
	 else {
	    /* y0<=y2<=y1 */
	    min = v0;   mid = v2;   max = v1;
	 }
      }
      else {
	 /* y1<y0... */
	 if (y0<=y2) {
	    /* y1<=y0<=y2 */
	    min = v1;   mid = v0;   max = v2;
	 }
	 else if (y2<=y1) {
	    /* y2<=y1<=y0 */
	    min = v2;   mid = v1;   max = v0;
	 }
	 else {
	    /* y1<=y2<=y0 */
	    min = v1;   mid = v2;   max = v0;
	 }
      }

      assert( WinY(min) <= WinY(min) );
      assert( WinY(mid) <= WinY(max) );
   }

   ymin = (GLint) (WinY(min)+0.5);      /* add .5??? */
   ymid = (GLint) (WinY(mid) + 0.5);
   ymax = (GLint) (WinY(max)+0.5);      /* add .5??? */

   dy_mid_min = WinY(mid) - WinY(min);
   dy_max_min = WinY(max) - WinY(min);
   dy_max_mid = WinY(max) - WinY(mid);

/* Assume we have a triangle with vertices like:

   Y
   |        *max
   |
   | mid*
   |
   |          *min
   +----------------X
*/
   /*
    * Draw bottom half (from ymin up to ymid)
    */
   if (dy_mid_min>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat lz, rz, dlz, drz;
      GLfloat fudge;

      printf("drawing bottom\n");

      /* compute left and right edges' dx/dy */
      /* assume mid is left of max */
      dlx = (WinX(mid)-WinX(min)) / dy_mid_min;
      dlz = (WinZ(mid)-WinZ(min)) / dy_mid_min;
      drx = (WinX(max)-WinX(min)) / dy_max_min;
      drz = (WinZ(max)-WinZ(min)) / dy_max_min;

      if (dlx>drx) {
	 /* wrong assumption */
	 GLfloat tmp;
	 SWAP( dlx, drx, tmp );
	 SWAP( dlz, drz, tmp );
      }

      assert( dlx<=drx );   /* edges should diverge */

      fudge = ymin + 0.5 - WinY(min);  /* adjust to pixel centers */
      lx = WinX(min) + dlx * fudge;
      lz = WinZ(min) + dlz * fudge;
      rx = WinX(min) + drx * fudge;
      rz = WinZ(min) + drz * fudge;

      trap_z_monocolor( ymin, ymid, lx, dlx, rx, drx, lz, dlz, rz, drz,
		        VB.Color[pv] );
   }


   /*
    * Draw top half (from ymid up to ymax)
    */
   if (dy_max_mid>0.0) {
      GLfloat lx, rx, dlx, drx;
      GLfloat lz, rz, dlz, drz;
      GLfloat fudge;

      GLfloat t = (dy_mid_min) / (dy_max_min);
      GLfloat newx = LINTERP( t, WinX(min), WinX(max) );
      GLfloat newz = LINTERP( t, WinZ(min), WinZ(max) );

      printf("drawing top\n");

      /* this adjusts values to pixel centers */
      fudge = ymid + 0.5 - WinY(mid);
      printf("fudge %f\n", fudge);
      if (fudge<0.0) {
	 fudge = 0.0;
      }

      if (WinX(mid) < newx) {
	 /* mid is left side of triangle */
	 dlx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 lx = WinX(mid) + dlx * fudge;
	 dlz = (WinZ(max)-WinZ(mid)) / dy_max_mid;
	 lz = WinZ(mid) + dlz * fudge;
/*	 drx = (WinX(max)-newx) / dy_max_mid;*/
	 drx = (WinX(max)-WinX(min)) / dy_max_min;
	 rx = newx + drx * fudge;
	 drz = (WinZ(max)-newz) / dy_max_mid;
	 rz = newz + drz * fudge;
      }
      else {
	 /* mid is on right side of triangle */
/*	 dlx = (WinX(max)-newx) / dy_max_mid;*/
	 dlx = (WinX(max)-WinX(min)) / dy_max_min;
	 lx = newx + dlx * fudge;
	 dlz = (WinZ(max)-newz) / dy_max_mid;
	 lz = newz + drz * fudge;
	 drx = (WinX(max)-WinX(mid)) / dy_max_mid;
	 rx = WinX(mid) + drx * fudge;
	 drz = (WinZ(max)-WinZ(mid)) / dy_max_mid;
	 rz = WinZ(mid) + dlz * fudge;
      }

      assert( dlx >= drx );   /* slopes should converge */

      trap_z_monocolor( ymid, ymax, lx, dlx, rx, drx, lz, dlz, rz, drz,
		        VB.Color[pv] );
   }

}


