/* macros.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: macros.h,v 1.9 1995/07/24 20:34:46 brianp Exp $

$Log: macros.h,v $
 * Revision 1.9  1995/07/24  20:34:46  brianp
 * better MEMSET and MEMCPY macros per Asif Khan
 *
 * Revision 1.8  1995/07/20  15:35:32  brianp
 * added casts to UBYTE_TO_FLOAT, USHORT_TO_FLOAT, UINT_TO_FLOAT
 *
 * Revision 1.7  1995/05/30  15:07:30  brianp
 * added ROUND()
 *
 * Revision 1.6  1995/05/22  20:59:34  brianp
 * Release 1.2
 *
 * Revision 1.5  1995/05/17  13:17:22  brianp
 * changed default CC.Mode value to allow use of real OpenGL headers
 * removed need for CC.MajorMode variable
 *
 * Revision 1.4  1995/05/12  19:18:55  brianp
 * added INSIDE_BEGIN_END macro
 *
 * Revision 1.3  1995/03/17  19:15:14  brianp
 * added ABS macro
 *
 * Revision 1.2  1995/03/04  19:25:29  brianp
 * 1.1 beta revision
 *
 * Revision 1.1  1995/02/24  14:24:52  brianp
 * Initial revision
 *
 */


/*
 * A collection of useful macros.
 */


#ifndef MACROS_H
#define MACROS_H



/* Limits: */
#define MAX_GLUSHORT	0xffff
#define MAX_GLUINT	0xffffffff



/* Copy short vectors: */

#define COPY_3V( DST, SRC )	DST[0] = SRC[0];	\
				DST[1] = SRC[1];	\
				DST[2] = SRC[2];

#define COPY_4V( DST, SRC )	DST[0] = SRC[0];	\
				DST[1] = SRC[1];	\
				DST[2] = SRC[2];	\
				DST[3] = SRC[3];


/* Assign scalers to short vectors: */
#define ASSIGN_3V( V, V0, V1, V2 )  V[0] = V0;  V[1] = V1;  V[2] = V2;

#define ASSIGN_4V( V, V0, V1, V2, V3 )  V[0] = V0;	\
				        V[1] = V1;	\
				        V[2] = V2;	\
				        V[3] = V3;


/* Test if we're inside a glBegin / glEnd pair: */
#define INSIDE_BEGIN_END  (CC.Mode!=GL_BITMAP)


/* Absolute value: */
#define ABS(X)  ((X) < 0 ? -(X) : (X))


/* Round a floating-point value to the nearest integer: */
#define ROUND(X)   ( (X)<0.0 ? ((GLint) ((X)-0.5)) : ((GLint) ((X)+0.5)) )


/* Clamp X to [MIN,MAX]: */
#define CLAMP( X, MIN, MAX )  ( (X)<(MIN) ? (MIN) : ((X)>(MAX) ? (MAX) : (X)) )


/* Min of two values: */
#define MIN2( A, B )   ( (A)<(B) ? (A) : (B) )


/* MAX of two values: */
#define MAX2( A, B )   ( (A)>(B) ? (A) : (B) )


/* Dot product of two 3-element vectors */
#define DOT3( a, b )  ( a[0]*b[0] + a[1]*b[1] + a[2]*b[2] )


/* Dot product of two 4-element vectors */
#define DOT4( a, b )  ( a[0]*b[0] + a[1]*b[1] + a[2]*b[2] + a[3]*b[3] )


/*
 * Integer / float conversion for colors, normals, etc.
 */

/* Convert GLubyte in [0,255] to GLfloat in [0.0,1.0] */
#define UBYTE_TO_FLOAT(B)	((GLfloat) (B) * (1.0F / 255.0F))

/* Convert GLfloat in [0.0,1.0] to GLubyte in [0,255] */
#define FLOAT_TO_UBYTE(X)	((GLubyte) (GLint) (((X)) * 255.0F))


/* Convert GLbyte in [-128,127] to GLfloat in [-1.0,1.0] */
#define BYTE_TO_FLOAT(B)	((2.0F * (B) + 1.0F) * (1.0F/255.0F))

/* Convert GLfloat in [-1.0,1.0] to GLbyte in [-128,127] */
#define FLOAT_TO_BYTE(X)	( (((GLint) (255.0F * (X))) - 1) / 2 )


/* Convert GLushort in [0,65536] to GLfloat in [0.0,1.0] */
#define USHORT_TO_FLOAT(S)	((GLfloat) (S) * (1.0F / 65535.0F))

/* Convert GLfloat in [0.0,1.0] to GLushort in [0,65536] */
#define FLOAT_TO_USHORT(X)	((GLushort) (GLint) ((X) * 65535.0F))


/* Convert GLshort in [-32768,32767] to GLfloat in [-1.0,1.0] */
#define SHORT_TO_FLOAT(S)	((2.0F * (S) + 1.0F) * (1.0F/65535.0F))

/* Convert GLfloat in [0.0,1.0] to GLshort in [-32768,32767] */
#define FLOAT_TO_SHORT(X)	( (((GLint) (65535.0F * (X))) - 1) / 2 )


/* Convert GLuint in [0,4294967295] to GLfloat in [0.0,1.0] */
#define UINT_TO_FLOAT(U)	((GLfloat) (U) * (1.0F / 4294967295.0F))

/* Convert GLfloat in [0.0,1.0] to GLuint in [0,4294967295] */
#define FLOAT_TO_UINT(X)	((GLuint) (GLint) ((X) * 4294967295.0))


/* Convert GLint in [-2147483648,2147483647] to GLfloat in [-1.0,1.0] */
#define INT_TO_FLOAT(I)		((2.0F * (I) + 1.0F) * (1.0F/4294967294.0F))

/* Convert GLfloat in [-1.0,1.0] to GLint in [-2147483648,2147483647] */
#define FLOAT_TO_INT(X)		( (((GLint) (4294967294.0F * (X))) - 1) / 2 )


/* Memory copy: */
#ifdef SUNOS4
#define MEMCPY( DST, SRC, BYTES) \
	memcpy( (char *) (DST), (char *) (SRC), (int) (BYTES) )
#else
#define MEMCPY( DST, SRC, BYTES) \
	memcpy( (void *) (DST), (void *) (SRC), (size_t) (BYTES) )
#endif


/* Memory set: */
#ifdef SUNOS4
#define MEMSET( DST, VAL, N ) \
	memset( (char *) (DST), (int) (VAL), (int) (N) )
#else
#define MEMSET( DST, VAL, N ) \
	memset( (void *) (DST), (int) (VAL), (size_t) (N) )
#endif


#endif /*MACROS_H*/
