/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/VideoFrame.c,v 1.1 92/07/14 14:38:08 drapeau Exp $ */
/* $Log:	VideoFrame.c,v $
 * Revision 1.1  92/07/14  14:38:08  drapeau
 * Initial revision
 *  */

/*
 * Parts of this file were generated by `gxv' from `VideoFrame.G'.
 */

static char videoFrameRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/VideoFrame.c,v 1.1 92/07/14 14:38:08 drapeau Exp $";

#include "VideoFrame.h"

VideoFrame_mainWindow_objects	*VideoFrame_mainWindow;		    /* Global object definitions. */
VideoFrame_inputWindow1_objects	*VideoFrame_inputWindow1;
VideoFrame_inputWindow2_objects	*VideoFrame_inputWindow2;

VideoIn		videoIn1 = (VideoIn)NULL;
VideoIn		videoIn2 = (VideoIn)NULL;
EditList	editList;
Edit		currentSelection;
int		numEdits = 0;
int		unsavedChanges = False;
int		currentEdit = NoCurrentEdit;
char*		editListFileName;     
Sender*		sender;
Receiver*	receiver;
Port		senderPort;
int		receiverPortNumber;

void	HideWindow(Panel_item, int, Event *);
void	ShowWindow(Panel_item, int, Event *);
void	CropWindow(Panel_item, int, Event *);
void	SqueezeWindow(Panel_item, int, Event *);
void	SetAspectAny(Panel_item, int, Event *);
void	SetAspect4to3(Panel_item, int, Event *);
void	ResizeHandler(Xv_window, Event *, Notify_arg, Notify_event_type);


#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

main(argc, argv)
     int	argc;
     char	**argv;
{
  Rect			tempRect;
  static DispatchTable  DT = 
  {
    OpenDoc,
    GetDoc,
    GetSelection,
    SetSelection,						    /* SetSelection */
    PerformSelection,						    /* PerformSelection */
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,							    /* HaltSelection */
    NULL,							    /* PauseSelection */
    NULL,							    /* ResumeSelection */
    HideApplication,
    ShowApplication,
    GetAppIcon
    };
  
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);		    /* Initialize XView. */
  INSTANCE = xv_unique_key();
  
  VideoFrame_mainWindow =					    /* Initialize user interface components. */
    VideoFrame_mainWindow_objects_initialize(NULL, NULL);	    /* Do NOT edit the object initializations by hand. */
  
  VideoFrame_inputWindow1 =
    VideoFrame_inputWindow1_objects_initialize(NULL, NULL);
  
  VideoFrame_inputWindow2 =
    VideoFrame_inputWindow2_objects_initialize(NULL, NULL);

  frame_get_rect(VideoFrame_mainWindow->mainWindow, &tempRect);
  tempRect.r_left = 215;
  tempRect.r_top = 370;
  frame_set_rect(VideoFrame_mainWindow->mainWindow, &tempRect);

  frame_get_rect(VideoFrame_inputWindow1->inputWindow1, &tempRect);
  tempRect.r_left = 10;
  tempRect.r_top = 40; 
  frame_set_rect(VideoFrame_inputWindow1->inputWindow1, &tempRect);
  xv_set(VideoFrame_inputWindow1->inputWindow1,
	 FRAME_SHOW_HEADER, FALSE, NULL);

  frame_get_rect(VideoFrame_inputWindow2->inputWindow2, &tempRect);
  tempRect.r_left = 500;
  tempRect.r_top = 215; 
  frame_set_rect(VideoFrame_inputWindow2->inputWindow2, &tempRect);
  xv_set(VideoFrame_inputWindow2->inputWindow2,
	 FRAME_SHOW_HEADER, FALSE, NULL);

  editListFileName = malloc(MAXPATHLEN);
  sprintf(editListFileName, "Untitled");
  sender = (Sender*)NULL;
  receiver = (Receiver*)NULL;
  senderPort.hostName = (char *) malloc(MAXPATHLEN);
  sprintf(senderPort.hostName, "localhost");			    /* Set default values for hostname and port number */
  senderPort.portNumber = PortMgrPortNumber;
  receiverPortNumber = AnyPort;
  sender = NewSender(&senderPort);
  if (sender != (Sender*)NULL)
    receiver = NewReceiver(sender, "VideoFrame", receiverPortNumber);
  BuildDispatchTable (&DT);
  (void) notify_enable_rpc_svc (TRUE);				    /* Tell the toolkit to listen for network messages */
  notify_interpose_destroy_func(VideoFrame_mainWindow->mainWindow,  /* Interpose the destroy function */
				QuitHandler);
  notify_interpose_destroy_func(VideoFrame_inputWindow1->inputWindow1, /* Interpose the destroy function */
				QuitHandler);
  notify_interpose_destroy_func(VideoFrame_inputWindow2->inputWindow2, /* Interpose the destroy function */
				QuitHandler);
  CreateBrowse(OpenEditList, SaveEditList,
	       VideoFrame_mainWindow->mainWindow);
  InitXVideoCanvases();						    /* Initialize the Parallax XVideo board inputs */
  xv_main_loop(VideoFrame_mainWindow->mainWindow);
  exit(0);
}

#endif



/*
 * Menu handler for `documentMenu (New)'.
 */
Menu_item
  NewHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    fputs("VideoFrame: NewHandler: MENU_NOTIFY\n", stderr);
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Menu handler for `documentMenu (Open...)'.
 */
Menu_item
  OpenHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    Browse(NULL, BrowseOpen, 0, VideoFrameDocument, "VideoFrame");
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Menu handler for `documentMenu (Save)'.
 */
Menu_item
  SaveHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    if (strcmp(editListFileName, "Untitled") == 0)
    {
      Browse(NULL, BrowseSave, 0, VideoFrameDocument, "VideoFrame");
    }
    else
    {
      Browse(editListFileName, BrowseCheckSave, 0, VideoFrameDocument, "VideoFrame");
    }
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Menu handler for `documentMenu (Save As...)'.
 */
Menu_item
  SaveAsHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    Browse(NULL, BrowseSave, 0, VideoFrameDocument, "VideoFrame");
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Menu handler for `documentMenu (Close)'.
 */
Menu_item
  CloseHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    fputs("VideoFrame: CloseHandler: MENU_NOTIFY\n", stderr);
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Menu handler for `documentMenu (Quit)'.
 */
Menu_item
  QuitHandler(Menu_item item, Menu_generate op)
{
  VideoFrame_mainWindow_objects * ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    if ((sender != (Sender*)NULL)  && (receiver != (Receiver*)NULL))
      DestroyReceiver(sender, receiver);
    xv_destroy_safe(VideoFrame_mainWindow->mainWindow);
    xv_destroy_safe(VideoFrame_inputWindow1->inputWindow1);
    xv_destroy_safe(VideoFrame_inputWindow2->inputWindow2);
    exit(0);
    
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}



/*
 * Notify callback function for `editList'.
 */
int
EditListHandler(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
  int	editNumber;
  
  switch(op)
  {
   case PANEL_LIST_OP_DESELECT:
    xv_set(VideoFrame_mainWindow->modifyButton, PANEL_INACTIVE, TRUE, NULL); /* Set the modify, delete buttons to inactive */
    xv_set(VideoFrame_mainWindow->deleteButton, PANEL_INACTIVE, TRUE, NULL);
    break;
    
   case PANEL_LIST_OP_SELECT:
    sscanf(string, "%d", &editNumber);
    LoadCurrentSelection(editNumber - 1);
    xv_set(VideoFrame_mainWindow->modifyButton, PANEL_INACTIVE, FALSE, NULL); /* Set the modify, delete buttons to active */
    xv_set(VideoFrame_mainWindow->deleteButton, PANEL_INACTIVE, FALSE, NULL);
    break;
    
   case PANEL_LIST_OP_VALIDATE:
    break;
    
   case PANEL_LIST_OP_DELETE:
    break;
  }
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
  return XV_OK;
}



/*
 * Notify callback function for `addButton'.
 */
void
  AddHandler(Panel_item item, Event *event)
{
  Rect	tempRect;
  char	theString[LabelLength + 16];
  
  if (numEdits >= MaxNumberEditListItems)
    return;
  if (videoIn1 != (VideoIn)NULL)				    /* Get rect for input 1 */
  {
    frame_get_rect(VideoFrame_inputWindow1->inputWindow1,	    /* Get the size of 1st video input window */
		   &tempRect);
    currentSelection.input1.x = tempRect.r_left;
    currentSelection.input1.y = tempRect.r_top;
    currentSelection.input1.width = tempRect.r_width;
    currentSelection.input1.height = tempRect.r_height;
  }
  if (videoIn2 != (VideoIn)NULL)				    /* Get rect for input 2 */
  {
    frame_get_rect(VideoFrame_inputWindow2->inputWindow2,	    /* Get the size of 2nd video input window */
		   &tempRect);
    currentSelection.input2.x = tempRect.r_left;
    currentSelection.input2.y = tempRect.r_top;
    currentSelection.input2.width = tempRect.r_width;
    currentSelection.input2.height = tempRect.r_height;
  }
  sprintf(editList.item[numEdits].label, "%s",
	  xv_get(VideoFrame_mainWindow->labelField, PANEL_VALUE));
  
  editList.item[numEdits].input1.shown = currentSelection.input1.shown;
  editList.item[numEdits].input1.cropped = currentSelection.input1.cropped;
  editList.item[numEdits].input1.aspectRatio = currentSelection.input1.aspectRatio;
  editList.item[numEdits].input1.brightness = currentSelection.input1.brightness;
  editList.item[numEdits].input1.contrast = currentSelection.input1.contrast;
  editList.item[numEdits].input1.saturation = currentSelection.input1.saturation;
  editList.item[numEdits].input1.hue = currentSelection.input1.hue;
  editList.item[numEdits].input1.width = currentSelection.input1.width;
  editList.item[numEdits].input1.height = currentSelection.input1.height;
  editList.item[numEdits].input1.x = currentSelection.input1.x;
  editList.item[numEdits].input1.y = currentSelection.input1.y;
  
  editList.item[numEdits].input2.shown = currentSelection.input2.shown;
  editList.item[numEdits].input2.cropped = currentSelection.input2.cropped;
  editList.item[numEdits].input2.aspectRatio = currentSelection.input2.aspectRatio;
  editList.item[numEdits].input2.brightness = currentSelection.input2.brightness;
  editList.item[numEdits].input2.contrast = currentSelection.input2.contrast;
  editList.item[numEdits].input2.saturation = currentSelection.input2.saturation;
  editList.item[numEdits].input2.hue = currentSelection.input2.hue;
  editList.item[numEdits].input2.width = currentSelection.input2.width;
  editList.item[numEdits].input2.height = currentSelection.input2.height;
  editList.item[numEdits].input2.x = currentSelection.input2.x;
  editList.item[numEdits].input2.y = currentSelection.input2.y;
  
  FormatEntry(numEdits, &(editList.item[numEdits]), theString);
  
  xv_set (VideoFrame_mainWindow->editList,
	  PANEL_LIST_INSERT, numEdits,
	  PANEL_LIST_STRING, numEdits, theString,
	  NULL);
  xv_set(VideoFrame_mainWindow->editList,
	 PANEL_LIST_SELECT, numEdits, TRUE,
	 NULL);
  numEdits++;							    /* Indicate that an edit was added to the list */
  editList.numEdits = numEdits;
  unsavedChanges = True;
  UpdateHeader();
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  /* gxv_end_connections */
}								    /* end function AddHandler */



/*
 * Notify callback function for `modifyButton'.
 */
void
  ModifyHandler(Panel_item item, Event *event)
{
  Rect	tempRect;
  
  if (videoIn1 != (VideoIn)NULL)				    /* Get rect for input 1 */
  {
    frame_get_rect(VideoFrame_inputWindow1->inputWindow1, &tempRect); /* Get the size of 1st video input window */
    currentSelection.input1.x = tempRect.r_left;
    currentSelection.input1.y = tempRect.r_top;
    currentSelection.input1.width = tempRect.r_width;
    currentSelection.input1.height = tempRect.r_height;
  }
  if (videoIn2 != (VideoIn)NULL)				    /* Get rect for input 2 */
  {
    frame_get_rect(VideoFrame_inputWindow2->inputWindow2, &tempRect); /* Get the size of 2nd video input window */
    currentSelection.input2.x = tempRect.r_left;
    currentSelection.input2.y = tempRect.r_top;
    currentSelection.input2.width = tempRect.r_width;
    currentSelection.input2.height = tempRect.r_height;
  }
  
  editList.item[currentEdit].input1.shown = currentSelection.input1.shown;
  editList.item[currentEdit].input1.cropped = currentSelection.input1.cropped;
  editList.item[currentEdit].input1.aspectRatio = currentSelection.input1.aspectRatio;
  editList.item[currentEdit].input1.brightness = currentSelection.input1.brightness;
  editList.item[currentEdit].input1.contrast = currentSelection.input1.contrast;
  editList.item[currentEdit].input1.saturation = currentSelection.input1.saturation;
  editList.item[currentEdit].input1.hue = currentSelection.input1.hue;
  editList.item[currentEdit].input1.width = currentSelection.input1.width;
  editList.item[currentEdit].input1.height = currentSelection.input1.height;
  editList.item[currentEdit].input1.x = currentSelection.input1.x;
  editList.item[currentEdit].input1.y = currentSelection.input1.y;
  
  editList.item[currentEdit].input2.shown = currentSelection.input2.shown;
  editList.item[currentEdit].input2.cropped = currentSelection.input2.cropped;
  editList.item[currentEdit].input2.aspectRatio = currentSelection.input2.aspectRatio;
  editList.item[currentEdit].input2.brightness = currentSelection.input2.brightness;
  editList.item[currentEdit].input2.contrast = currentSelection.input2.contrast;
  editList.item[currentEdit].input2.saturation = currentSelection.input2.saturation;
  editList.item[currentEdit].input2.hue = currentSelection.input2.hue;
  editList.item[currentEdit].input2.width = currentSelection.input2.width;
  editList.item[currentEdit].input2.height = currentSelection.input2.height;
  editList.item[currentEdit].input2.x = currentSelection.input2.x;
  editList.item[currentEdit].input2.y = currentSelection.input2.y;
  unsavedChanges = True;
  UpdateHeader();

  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
}								    /* end function ModifyHandler */



/*
 * Notify callback function for `deleteButton'.
 */
void
  DeleteHandler(Panel_item item, Event *event)
{
  VideoFrame_mainWindow_objects *ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  fputs("VideoFrame: DeleteHandler\n", stderr);
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
}



/*
 * Notify callback function for `deleteAllButton'.
 */
void
  DeleteAllHandler(Panel_item item, Event *event)
{
  VideoFrame_mainWindow_objects *ip = (VideoFrame_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  fputs("VideoFrame: DeleteAllHandler\n", stderr);
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
}



/*
 * Notify callback function for `input1ShownChoice'.
 */
void
  VideoFrame_mainWindow_input1ShownChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 1)
  {
    HideWindow(item, value, event);
  }
  
  if (value == 0)
  {
    ShowWindow(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * User-defined action for `input1ShownChoice'.
 */
void
  HideWindow(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1ShownChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
      xv_set(VideoFrame_inputWindow1->inputWindow1,
	     XV_SHOW, FALSE,
	     NULL);
    currentSelection.input1.shown = False;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
      xv_set(VideoFrame_inputWindow2->inputWindow2,
	     XV_SHOW, FALSE,
	     NULL);
    currentSelection.input2.shown = False;
  }
}								    /* end function HideWindow */



/*
 * User-defined action for `input1ShownChoice'.
 */
void
  ShowWindow(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1ShownChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      if (xv_get(VideoFrame_inputWindow1->inputWindow1,		    /*  If the 1st video window is closed, open it... */
		 FRAME_CLOSED) == TRUE)
      {
	xv_set(VideoFrame_inputWindow1->inputWindow1,
	       FRAME_CLOSED, FALSE, NULL);
      }
      xv_set(VideoFrame_inputWindow1->inputWindow1,
	     XV_SHOW, TRUE, NULL);
    }
    currentSelection.input1.shown = True;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      if (xv_get(VideoFrame_inputWindow2->inputWindow2,		    /*  If the 2nd video window is closed, open it... */
		 FRAME_CLOSED) == TRUE)
      {
	xv_set(VideoFrame_inputWindow2->inputWindow2,
	       FRAME_CLOSED, FALSE, NULL);
      }
      xv_set(VideoFrame_inputWindow2->inputWindow2,
	     XV_SHOW, TRUE, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.shown = True;
  }								    /* end else... */
}								    /* end function ShowWindow */



/*
 * Notify callback function for `input1CroppedChoice'.
 */
void
  VideoFrame_mainWindow_input1CroppedChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 0)
  {
    CropWindow(item, value, event);
  }
  
  if (value == 1)
  {
    SqueezeWindow(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * User-defined action for `input1CroppedChoice'.
 */
void
  CropWindow(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1CroppedChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_SQUEEZE, FALSE, NULL);		    /* Set video window to crop instead of squeeze */
    }
    currentSelection.input1.cropped = True;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_SQUEEZE, FALSE, NULL);		    /* Set video window to crop instead of squeeze */
    }								    /* end if (videoIn2... */
    currentSelection.input2.cropped = True;
  }								    /* end else... */
}								    /* end function CropWindow */




/*
 * User-defined action for `input1CroppedChoice'.
 */
void
  SqueezeWindow(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1CroppedChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_SQUEEZE, TRUE, NULL);		    /* Set video window to crop instead of squeeze */
    }
    currentSelection.input1.cropped = False;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_SQUEEZE, TRUE, NULL);		    /* Set video window to crop instead of squeeze */
    }								    /* end if (videoIn2... */
    currentSelection.input2.cropped = False;
  }								    /* end else... */
}



/*
 * Notify callback function for `input1AspectChoice'.
 */
void
  VideoFrame_mainWindow_input1AspectChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 0)
  {
    SetAspectAny(item, value, event);
  }
  
  if (value == 1)
  {
    SetAspect4to3(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * User-defined action for `input1AspectChoice'.
 */
void
  SetAspectAny(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1AspectChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_NORMAL_ASPECT, FALSE, NULL);
    }
    currentSelection.input1.aspectRatio = Any;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_NORMAL_ASPECT, FALSE, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.aspectRatio = Any;
  }								    /* end else... */
}								    /* end function SetAspectAny */



/*
 * User-defined action for `input1AspectChoice'.
 */
void
SetAspect4to3(Panel_item item, int	 value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1AspectChoice)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_NORMAL_ASPECT, TRUE, NULL);
    }
    currentSelection.input1.aspectRatio = Fixed;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_NORMAL_ASPECT, TRUE, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.aspectRatio = Fixed;
  }								    /* end else... */
}								    /* end function SetAspect4to3 */



/*
 * Notify callback function for `input1BrightSlider'.
 */
void
  BrightnessHandler(Panel_item item, int value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1BrightSlider)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_BRIGHTNESS, value, NULL);
    }
    currentSelection.input1.brightness = value;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_BRIGHTNESS, value, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.brightness = value;
  }								    /* end else... */
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
}								    /* end function BrightnessHandler */



/*
 * Notify callback function for `input1ContrastSlider'.
 */
void
  ContrastHandler(Panel_item item, int value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1ContrastSlider)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_CONTRAST, value, NULL);
    }
    currentSelection.input1.contrast = value;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_CONTRAST, value, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.contrast = value;
  }								    /* end else... */
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
}



/*
 * Notify callback function for `input1SaturationSlider'.
 */
void
  SaturationHandler(Panel_item item, int value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1SaturationSlider)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_SATURATION, value, NULL);
    }
    currentSelection.input1.saturation = value;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_SATURATION, value, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.saturation = value;
  }								    /* end else... */
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
}								    /* end function SaturationHandler */



/*
 * Notify callback function for `input1HueSlider'.
 */
void
  HueHandler(Panel_item item, int value, Event *event)
{
  if (item == (Panel_item)VideoFrame_mainWindow->input1HueSlider)
  {
    if (videoIn1 != (VideoIn)NULL)
    {
      xv_set(videoIn1, VIDEO_HUE, value, NULL);
    }
    currentSelection.input1.hue = value;
  }
  else
  {
    if (videoIn2 != (VideoIn)NULL)
    {
      xv_set(videoIn2, VIDEO_HUE, value, NULL);
    }								    /* end if (videoIn2... */
    currentSelection.input2.hue = value;
  }								    /* end else... */
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
}								    /* end function HueHandler */



/*
 * Notify callback function for `input2ShownChoice'.
 */
void
  VideoFrame_mainWindow_input2ShownChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 0)
  {
    ShowWindow(item, value, event);
  }
  
  if (value == 1)
  {
    HideWindow(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * Notify callback function for `input2CroppedChoice'.
 */
void
  VideoFrame_mainWindow_input2CroppedChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 0)
  {
    CropWindow(item, value, event);
  }
  
  if (value == 1)
  {
    SqueezeWindow(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * Notify callback function for `input2AspectChoice'.
 */
void
  VideoFrame_mainWindow_input2AspectChoice_notify_callback(Panel_item item, int	 value, Event *event)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (value == 0)
  {
    SetAspectAny(item, value, event);
  }
  
  if (value == 1)
  {
    SetAspect4to3(item, value, event);
  }
  
  /* gxv_end_connections */
}



/*
 * Event callback function for `inputWindow1'.
 */
Notify_value
  VideoFrame_inputWindow1_event_callback(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
  
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (event_action(event) == WIN_RESIZE)
  {
    ResizeHandler(win, event, arg, type);
  }
  
  /* gxv_end_connections */
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}



/*
 * User-defined action for `inputWindow1'.
 */
void
  ResizeHandler(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
  Rect					tempRect;
  VideoFrame_inputWindow1_objects*	ip =
    (VideoFrame_inputWindow1_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
  
  if (win == (Xv_window)VideoFrame_inputWindow1->inputWindow1)	    /* Get rect for input 1 */
  {
    frame_get_rect(VideoFrame_inputWindow1->inputWindow1,	    /* Get new size & position of input1 window */
		   &tempRect);
    currentSelection.input1.x = tempRect.r_left;
    currentSelection.input1.y = tempRect.r_top;
    currentSelection.input1.width = tempRect.r_width;
    currentSelection.input1.height = tempRect.r_height;
  }
  else
  {
    frame_get_rect(VideoFrame_inputWindow2->inputWindow2,	    /* Get new size & position of input2 window */
		   &tempRect);
    currentSelection.input2.x = tempRect.r_left;
    currentSelection.input2.y = tempRect.r_top;
    currentSelection.input2.width = tempRect.r_width;
    currentSelection.input2.height = tempRect.r_height;
  }
}								    /* end function ResizeHandler */



/*
 * Event callback function for `inputWindow2'.
 */
Notify_value
  VideoFrame_inputWindow2_event_callback(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  if (event_action(event) == WIN_RESIZE)
  {
    ResizeHandler(win, event, arg, type);
  }
  
  /* gxv_end_connections */
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}



/*
 * Notify callback function for `labelField'.
 */
Panel_setting
  LabelFieldHandler(Panel_item item, Event *event)
{
  AddHandler(item, event);
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
  
  return panel_text_notify(item, event);
}
