/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstroClient.c,v 1.17 92/09/24 14:00:37 drapeau Exp Locker: drapeau $ */
/* $Log:	MAEstroClient.c,v $
 * Revision 1.17  92/09/24  14:00:37  drapeau
 * Modified code to support asynchronous messaging (actually, to be precise,
 * the code now supports one-way RPC's, but conceptually the programmer should
 * think of the messaging as non-blocking).  In Sun RPC, if an RPC call has
 * a timeout value of zero, the sender will not block waiting for a return.
 * To support this model, a new method was added to the Sender object, called
 * "SenderAsynchronousMessaging()".  It will enable or disable synchronous
 * messaging for the sender passed in as argument.  It does this by modifying
 * the Sender's "timeOut" field.  Also, each message in the Sender object
 * modifies a variable global to the NetworkProtocol library; this variable
 * is called "SenderTimeOut" and is used by each message in the Sender class.
 * When a message is sent, the responsible method first sets the SenderTimeOut
 * variable to the timeOut field of the current Sender.
 * Because of these changes, it is no longer necessary to create default
 * timeout values when a New Sender is created (via the NewSender() method).
 * Thus, the code to do so was removed.
 * A final note: the "sender->timeOut" field is new to this version of the code.
 * 
 * Revision 1.16  92/05/29  12:40:32  drapeau
 * Changed the name of the "Selection" structure to "MAESelection",
 * to avoid name conflicts with other software packages and toolkits
 * that might also define a "Selection" structure.
 * 
 * Revision 1.15  91/09/18  12:49:42  drapeau
 * Modified the getportfromname_1() function so that it returns a PortArray* instead of a Port*.
 * Also, changed the name of the major include file from LinkProtocol.h to MAEstro.h, in keeping with
 * the project name.
 * 
 * Revision 1.14  91/09/03  16:55:27  drapeau
 * Modified definition of the "GetPortFromName" message so that it returns
 * a Port* instead of a void*.
 * 
 * Revision 1.13  91/06/19  14:00:01  drapeau
 * Added support for five new messages:
 *  - PauseSelection
 *  - ResumeSelection
 *  - HideApplication
 *  - ShowApplication
 *  - GetAppIcon
 * Also, replaced the "PerformPartialSelection" message with
 * "HaltSelection" message.
 * 
 * Revision 1.12  91/06/17  18:17:16  drapeau
 * Added copyright notice.
 * 
 * Revision 1.11  1991/02/28  07:14:23  drapeau
 * No code changes; this version uses a new version numbering scheme and a new
 * version of RCS.
 *
 * Revision 1.1  90/10/24  18:20:27  drapeau
 * Initial revision
 *  */

static char maestroClientRcsid[] = "$Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstroClient.c,v 1.17 92/09/24 14:00:37 drapeau Exp Locker: drapeau $";

#include <rpc/rpc.h>
#include <sys/time.h>
#include <MAEstro.h>

static struct timeval	myTIMEOUT = { 5, 0 };
struct timeval*		SenderTimeOut = &myTIMEOUT;

void* opendocument_1(char** argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, OpenDocumentProc, xdr_wrapstring,
		(caddr_t)argp, xdr_void, &res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((void *)&res);
}


char** getcurrentdocname_1(void* argp, CLIENT* clnt)
{
  static char* res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, GetCurrentDocNameProc, xdr_void,
		(caddr_t)argp, xdr_wrapstring, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return (&res);
}


MAESelection* getselection_1(void* argp, CLIENT* clnt)
{
  static MAESelection res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, GetSelectionProc, xdr_void,
		(caddr_t)argp, xdr_MAESelection, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return (&res);
}


void* setselection_1(MAESelection* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, SetSelectionProc, xdr_MAESelection,
		(caddr_t)argp, xdr_void, &res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((void *)&res);
}


void* performselection_1(void* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, PerformSelectionProc, xdr_void,
		(caddr_t)argp, xdr_void, &res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((void *)&res);
}


void* connectwithportmgr_1(Port* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, ConnectWithPortMgrProc, xdr_Port,
		(caddr_t)argp, xdr_void, &res, SenderTimeOut) != RPC_SUCCESS)
    {
      return ((void*)NULL);
    }
  return ((void *)&res);
}



PortArray* getopenapps_1(void* argp, CLIENT* clnt)
{
  static PortArray res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, GetOpenAppsProc, xdr_void,
		(caddr_t)argp, xdr_PortArray, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((PortArray*)&res);
}


PortArray* getportfromname_1(Port* argp, CLIENT* clnt)
{
  static PortArray res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, GetPortFromNameProc, xdr_Port,
		(caddr_t)argp, xdr_PortArray, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
    {
      return ((PortArray*) NULL);
    }
  return ((PortArray*)&res);
}


void* disconnectfromportmgr_1(Port* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, DisconnectFromPortMgrProc, xdr_Port,
		(caddr_t)argp, xdr_void, &res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((void *)&res);
}


void* ping_1(void* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, PingProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
    {
      return (NULL);
    }
  return ((void *)&res);
}


void* haltselection_1(void* argp, CLIENT* clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, HaltSelectionProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return ((void *)&res);
}


void*	pauseselection_1(void *argp, CLIENT *clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, PauseSelectionProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return ((void *)&res);
}


void*	resumeselection_1(void *argp, CLIENT *clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, ResumeSelectionProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return ((void *)&res);
}


void*	hideapplication_1(void *argp, CLIENT *clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, HideApplicationProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return ((void *)&res);
}



void*	showapplication_1(void *argp, CLIENT *clnt)
{
  static char res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, ShowApplicationProc, xdr_void,
		(caddr_t)argp, xdr_void, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return ((void *)&res);
}



IconData*	getappicon_1(void *argp, CLIENT *clnt)
{
  static IconData res;
  
  bzero((char *)&res, sizeof(res));
  if (clnt_call(clnt, GetAppIconProc, xdr_void,
		(caddr_t)argp, xdr_IconData, (caddr_t)&res, SenderTimeOut) != RPC_SUCCESS)
  {
    return (NULL);
  }
  return (&res);
}
