/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header $ */
/* $Log $ */
static char imageiorcsid[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/imageio.c,v 1.2 92/10/29 13:57:50 drapeau Exp Locker: drapeau $";

#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <fcntl.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/frame.h>
#include <xview/svrimage.h>
#include <xview/icon.h>
#include <xview/notify.h>
#include <Sender.h>
#include <Receiver.h>
#include "xvimage.h"

#define IconX 64
#define IconY 64
#define Depth 8
#define Permissions 0666

char *FilenameToFileData(filename, length)
char *filename;
int *length;
{
  FILE *fp;
  char *fileData;
  if ((fp=fopen(filename, "r"))==NULL)
    {
      printf("Can't open %s for reading\n", filename);
      return 0;
    }
 /* find the size of the file */
  fseek(fp, 0L, 2);
  *length = ftell(fp);
  fseek(fp, 0L, 0);
  fileData = (char *)malloc(*length);
  if (fread(fileData, *length, 1, fp) != 1) 
    {
      printf("Can't read %s\n", filename);
      *length = 0;
      fclose(fp);
      return NULL;
    }
  fclose(fp);
  return fileData;
}
  

void
  CreateIcon(Xv_opaque owner, char *iconFile, IconData *iconData)
{
  Display*		rootDpy = (Display *)XOpenDisplay(NULL);
  Server_image		iconImage;
  static unsigned short	window1_bits[] = {
#include "DisplayTool.icon"
  };
  
  iconImage = (Server_image)xv_create(XV_NULL, SERVER_IMAGE,
				      SERVER_IMAGE_BITS, window1_bits,
				      XV_WIDTH, IconX,
				      XV_HEIGHT, IconY,
				      SERVER_IMAGE_DEPTH, 1,
				      NULL); 
  xv_set(owner, FRAME_ICON,
	 (Icon)xv_create(XV_NULL, ICON, 
			 ICON_IMAGE, iconImage, NULL), NULL); 
  return;
}								    /* end function CreateIcon */
