;GIL-3
(
(
	:type                   :menu
	:name                   imagesMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Images:"
	:menu-item-labels       ("Load Images ..." "Clear Selected Images" "Clear Gallery" )
	:menu-item-label-types  (:string :string :string )
	:menu-item-states       (:active :active :active )
	:menu-item-defaults     (nil nil nil )
	:initial-selections     (nil nil nil )
	:menu-item-handlers     (LoadImages ClearSelectedImages ClearGallery )
	:menu-item-menus        (nil nil nil )
	:menu-item-colors       ("" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (imagesMenu "Load Images ...")
		:when                   (Notify )
		:to                     (imagesMenu "Load Images ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (LoadImages)
		)
		(
		:from                   (imagesMenu "Clear Selected Images")
		:when                   (Notify )
		:to                     (imagesMenu "Clear Selected Images")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearSelectedImages)
		)
		(
		:from                   (imagesMenu "Clear Gallery")
		:when                   (Notify )
		:to                     (imagesMenu "Clear Gallery")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearGallery)
		)
	)
)
(
	:type                   :menu
	:name                   documentMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Document:"
	:menu-item-labels       ("Open ..." "Info ..." "Save Sequence" "Save Sequence As ..." "Help ..." "Close" "Quit" )
	:menu-item-label-types  (:string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil )
	:menu-item-handlers     (OpenSequence Info SaveSequence SaveSequenceAs Help Close QuitDisplayTool )
	:menu-item-menus        (nil nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (documentMenu "Open ...")
		:when                   (Notify )
		:to                     (documentMenu "Open ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (OpenSequence)
		)
		(
		:from                   (documentMenu "Info ...")
		:when                   (Notify )
		:to                     (documentMenu "Info ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Info)
		)
		(
		:from                   (documentMenu "Save Sequence")
		:when                   (Notify )
		:to                     (documentMenu "Save Sequence")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveSequence)
		)
		(
		:from                   (documentMenu "Save Sequence As ...")
		:when                   (Notify )
		:to                     (documentMenu "Save Sequence As ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveSequenceAs)
		)
		(
		:from                   (documentMenu "Help ...")
		:when                   (Notify )
		:to                     (documentMenu "Help ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Help)
		)
		(
		:from                   (documentMenu "Close")
		:when                   (Notify )
		:to                     (documentMenu "Close")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Close)
		)
		(
		:from                   (documentMenu "Quit")
		:when                   (Notify )
		:to                     (documentMenu "Quit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (QuitDisplayTool)
		)
	)
)
(
	:type                   :menu
	:name                   slidesMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Slides:"
	:menu-item-labels       ("Slide Info ..." "Redraw Slides" "Copy Slide" "Cut Slide" "Insert Clipboard Slide" "Insert New Slide" "Clear Slide" "Clear All" )
	:menu-item-label-types  (:string :string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil nil )
	:menu-item-handlers     (SlideInfo RedrawSlides CopySlide CutSlide InsertClipboardSlide InsertNewSlide ClearSlide ClearAll )
	:menu-item-menus        (nil nil nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (slidesMenu "Slide Info ...")
		:when                   (Notify )
		:to                     (slidesMenu "Slide Info ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SlideInfo)
		)
		(
		:from                   (slidesMenu "Redraw Slides")
		:when                   (Notify )
		:to                     (slidesMenu "Redraw Slides")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (RedrawSlides)
		)
		(
		:from                   (slidesMenu "Copy Slide")
		:when                   (Notify )
		:to                     (slidesMenu "Copy Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CopySlide)
		)
		(
		:from                   (slidesMenu "Cut Slide")
		:when                   (Notify )
		:to                     (slidesMenu "Cut Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CutSlide)
		)
		(
		:from                   (slidesMenu "Insert Clipboard Slide")
		:when                   (Notify )
		:to                     (slidesMenu "Insert Clipboard Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InsertClipboardSlide)
		)
		(
		:from                   (slidesMenu "Insert New Slide")
		:when                   (Notify )
		:to                     (slidesMenu "Insert New Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InsertNewSlide)
		)
		(
		:from                   (slidesMenu "Clear Slide")
		:when                   (Notify )
		:to                     (slidesMenu "Clear Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearSlide)
		)
		(
		:from                   (slidesMenu "Clear All")
		:when                   (Notify )
		:to                     (slidesMenu "Clear All")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearAll)
		)
	)
)
(
	:type                   :menu
	:name                   imageEditMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Edit Image:"
	:menu-item-labels       ("Duplicate Image" "Cut" "Resize" "Resize + 10%" "Resize - 10%" "Set To Original Size" )
	:menu-item-label-types  (:string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil )
	:menu-item-handlers     (DuplicateImage CutImage ResizeImageGeneral ResizeImagePlus10Percent ResizeImageMinus10Percent ImageEditSetToOriginalSize )
	:menu-item-menus        (nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (imageEditMenu "Duplicate Image")
		:when                   (Notify )
		:to                     (imageEditMenu "Duplicate Image")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DuplicateImage)
		)
		(
		:from                   (imageEditMenu "Cut")
		:when                   (Notify )
		:to                     (imageEditMenu "Cut")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CutImage)
		)
		(
		:from                   (imageEditMenu "Resize")
		:when                   (Notify )
		:to                     (imageEditMenu "Resize")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ResizeImageGeneral)
		)
		(
		:from                   (imageEditMenu "Resize + 10%")
		:when                   (Notify )
		:to                     (imageEditMenu "Resize + 10%")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ResizeImagePlus10Percent)
		)
		(
		:from                   (imageEditMenu "Resize - 10%")
		:when                   (Notify )
		:to                     (imageEditMenu "Resize - 10%")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ResizeImageMinus10Percent)
		)
		(
		:from                   (imageEditMenu "Set To Original Size")
		:when                   (Notify )
		:to                     (imageEditMenu "Set To Original Size")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageEditSetToOriginalSize)
		)
	)
)
(
	:type                   :menu
	:name                   selectSlideMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Select Slide:"
	:menu-item-labels       ("Next Slide" "Previous Slide" "First Slide" "Last Slide" "Slide Number ..." )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (NextSlide PreviousSlide FirstSlide LastSlide SlideNumberPopup )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (selectSlideMenu "Next Slide")
		:when                   (Notify )
		:to                     (selectSlideMenu "Next Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (NextSlide)
		)
		(
		:from                   (selectSlideMenu "Previous Slide")
		:when                   (Notify )
		:to                     (selectSlideMenu "Previous Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PreviousSlide)
		)
		(
		:from                   (selectSlideMenu "First Slide")
		:when                   (Notify )
		:to                     (selectSlideMenu "First Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FirstSlide)
		)
		(
		:from                   (selectSlideMenu "Last Slide")
		:when                   (Notify )
		:to                     (selectSlideMenu "Last Slide")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (LastSlide)
		)
		(
		:from                   (selectSlideMenu "Slide Number ...")
		:when                   (Notify )
		:to                     (selectSlideMenu "Slide Number ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SlideNumberPopup)
		)
	)
)
(
	:type                   :base-window
	:name                   baseWindow
	:owner                  nil
	:width                  645
	:height                 619
	:background-color       ""
	:foreground-color       ""
	:label                  "Display Tool Document :  \"untitled\""
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              t
	:icon-file              "DisplayTool.icon"
	:icon-label             ""
	:icon-mask-file         "DisplayTool.icon"
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls1
	:owner                  baseWindow
	:help                   ""
	:x                      0
	:y                      0
	:width                  645
	:height                 54
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message1
	:owner                  controls1
	:help                   ""
	:x                      224
	:y                      8
	:width                  310
	:height                 13
	:foreground-color       ""
	:label                  "IMAGE GALLERY:  Drag images onto the slides"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   documentButton
	:owner                  controls1
	:help                   ""
	:x                      16
	:y                      20
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   documentMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   imagesButton
	:owner                  controls1
	:help                   ""
	:x                      128
	:y                      20
	:width                  75
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Images"
	:label-type             :string
	:initial-state          :active
	:menu                   imagesMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   currentImageMsg
	:owner                  controls1
	:help                   ""
	:x                      224
	:y                      32
	:width                  126
	:height                 13
	:foreground-color       ""
	:label                  "Current Image: None"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :canvas-pane
	:name                   gallery
	:owner                  baseWindow
	:help                   ""
	:x                      0
	:y                      53
	:width                  645
	:height                 211
	:background-color       "White"
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       645
	:vertical-scrollbar     nil
	:scrollable-height      211
	:repaint-proc           GalleryRepaint
	:event-handler          nil
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (baseWindow gallery)
		:when                   (Repaint )
		:to                     (baseWindow gallery)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GalleryRepaint)
		)
		(
		:from                   (baseWindow gallery)
		:when                   (Select )
		:to                     (baseWindow gallery)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GalleryEventProc)
		)
		(
		:from                   (baseWindow gallery)
		:when                   (Adjust )
		:to                     (baseWindow gallery)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GalleryEventProc)
		)
		(
		:from                   (baseWindow gallery)
		:when                   (Menu )
		:to                     (baseWindow gallery)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GalleryEventProc)
		)
	)
)
(
	:type                   :control-area
	:name                   borderControls
	:owner                  baseWindow
	:help                   ""
	:x                      0
	:y                      263
	:width                  645
	:height                 48
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   showFullSizeMessage
	:owner                  borderControls
	:help                   ""
	:x                      144
	:y                      8
	:width                  101
	:height                 13
	:foreground-color       ""
	:label                  "Show Full Size:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message4
	:owner                  borderControls
	:help                   ""
	:x                      288
	:y                      8
	:width                  50
	:height                 13
	:foreground-color       ""
	:label                  "SLIDES:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   currentSlideMessage
	:owner                  borderControls
	:help                   ""
	:x                      352
	:y                      8
	:width                  130
	:height                 13
	:foreground-color       ""
	:label                  "Current Slide    # 1 "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   slidesButton
	:owner                  borderControls
	:help                   ""
	:x                      16
	:y                      16
	:width                  68
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Slides"
	:label-type             :string
	:initial-state          :active
	:menu                   slidesMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   showFullSize
	:owner                  borderControls
	:help                   ""
	:x                      144
	:y                      18
	:width                  116
	:height                 23
	:value-x                144
	:value-y                18
	:rows                   0
	:columns                3
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         ShowFullSize
	:event-handler          nil
	:choices                ("Yes" "No" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (baseWindow showFullSize)
		:when                   (Notify )
		:to                     (baseWindow showFullSize)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowFullSize)
		)
	)
)
(
	:type                   :message
	:name                   totalNumberOfSlidesMessage
	:owner                  borderControls
	:help                   ""
	:x                      288
	:y                      24
	:width                  189
	:height                 13
	:foreground-color       ""
	:label                  "Total Number of Slides :  0  "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :canvas-pane
	:name                   slides
	:owner                  baseWindow
	:help                   ""
	:x                      0
	:y                      310
	:width                  597
	:height                 309
	:background-color       "White"
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       597
	:vertical-scrollbar     nil
	:scrollable-height      309
	:repaint-proc           nil
	:event-handler          nil
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (baseWindow slides)
		:when                   (Menu )
		:to                     (baseWindow slides)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SlidesEventProc)
		)
	)
)
(
	:type                   :control-area
	:name                   controls2
	:owner                  baseWindow
	:help                   ""
	:x                      595
	:y                      310
	:width                  50
	:height                 309
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   infoPopup
	:owner                  baseWindow
	:width                  532
	:height                 292
	:background-color       "Light Gray"
	:foreground-color       ""
	:label                  "Display Tool Info"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   InfoControlPanel
	:owner                  infoPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  532
	:height                 292
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appNameMessage
	:owner                  InfoControlPanel
	:help                   ""
	:x                      144
	:y                      12
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "Display Tool"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appNameMessage1
	:owner                  InfoControlPanel
	:help                   ""
	:x                      256
	:y                      12
	:width                  76
	:height                 13
	:foreground-color       ""
	:label                  "Version 1.3"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appDescriptionMessage1
	:owner                  InfoControlPanel
	:help                   ""
	:x                      92
	:y                      40
	:width                  336
	:height                 13
	:foreground-color       ""
	:label                  "An application for displaying and manipulating images"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   appDescriptionMessage2
	:owner                  InfoControlPanel
	:help                   ""
	:x                      48
	:y                      64
	:width                  430
	:height                 13
	:foreground-color       ""
	:label                  "designed for use with the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   developerMessage
	:owner                  InfoControlPanel
	:help                   ""
	:x                      136
	:y                      96
	:width                  244
	:height                 13
	:foreground-color       ""
	:label                  "by Bryant Marks and Janylyn Marks"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message5
	:owner                  InfoControlPanel
	:help                   ""
	:x                      160
	:y                      120
	:width                  202
	:height                 13
	:foreground-color       ""
	:label                  "Modifications by George Drapeau"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyrightMessage
	:owner                  InfoControlPanel
	:help                   ""
	:x                      80
	:y                      160
	:width                  379
	:height                 13
	:foreground-color       ""
	:label                  "Copyright (C) 1992 Libraries and Information Resources (L&IR)"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyrightMessage2
	:owner                  InfoControlPanel
	:help                   ""
	:x                      196
	:y                      180
	:width                  118
	:height                 13
	:foreground-color       ""
	:label                  "Stanford University"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   copyrightMessage3
	:owner                  InfoControlPanel
	:help                   ""
	:x                      196
	:y                      200
	:width                  119
	:height                 13
	:foreground-color       ""
	:label                  "Stanford, California"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   moreInfoMessage
	:owner                  InfoControlPanel
	:help                   ""
	:x                      96
	:y                      224
	:width                  357
	:height                 13
	:foreground-color       ""
	:label                  "For more information, contact maestro@sioux.stanford.edu"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   info
	:owner                  InfoControlPanel
	:help                   ""
	:x                      232
	:y                      256
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         DoneHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (infoPopup info)
		:when                   (Notify )
		:to                     (infoPopup info)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DoneHandler)
		)
	)
)
(
	:type                   :popup-window
	:name                   helpPopup
	:owner                  baseWindow
	:width                  544
	:height                 579
	:background-color       ""
	:foreground-color       ""
	:label                  "Display Tool Help"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls3
	:owner                  helpPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  544
	:height                 579
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   info2
	:owner                  controls3
	:help                   ""
	:x                      216
	:y                      16
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         DoneHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (helpPopup info2)
		:when                   (Notify )
		:to                     (helpPopup info2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DoneHandler)
		)
	)
)
(
	:type                   :message
	:name                   message2
	:owner                  controls3
	:help                   ""
	:x                      16
	:y                      48
	:width                  488
	:height                 13
	:foreground-color       ""
	:label                  "To resize images, use the rightmost mouse button and drag the image from one"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message3
	:owner                  controls3
	:help                   ""
	:x                      16
	:y                      64
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "of the corners."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message6
	:owner                  controls3
	:help                   ""
	:x                      16
	:y                      96
	:width                  475
	:height                 13
	:foreground-color       ""
	:label                  "Set the duration field in seconds to the desired length of time to display each"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message7
	:owner                  controls3
	:help                   ""
	:x                      16
	:y                      112
	:width                  478
	:height                 13
	:foreground-color       ""
	:label                  "slide, or press the \"Until Next Slide\" button.  This puts the slide in \"indefinite\""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message8
	:owner                  controls3
	:help                   ""
	:x                      16
	:y                      128
	:width                  447
	:height                 13
	:foreground-color       ""
	:label                  "mode, so that it will display indefinitely until the next slide is displayed."
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   slidePopup
	:owner                  baseWindow
	:width                  437
	:height                 507
	:background-color       ""
	:foreground-color       ""
	:label                  "Slide Information"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls5
	:owner                  slidePopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  437
	:height                 507
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   selectSlideButton
	:owner                  controls5
	:help                   ""
	:x                      304
	:y                      20
	:width                  102
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Select Slide"
	:label-type             :string
	:initial-state          :active
	:menu                   selectSlideMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   currentSlideInfoMessage
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      24
	:width                  130
	:height                 13
	:foreground-color       ""
	:label                  "Current Slide    # 1 "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   label
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      64
	:width                  277
	:height                 15
	:value-x                69
	:value-y                64
	:value-length           28
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Label :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          LabelEventProc
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup label)
		:when                   (AnyEvent )
		:to                     (slidePopup label)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (LabelEventProc)
		)
	)
)
(
	:type                   :button
	:name                   indefiniteButton
	:owner                  controls5
	:help                   ""
	:x                      248
	:y                      100
	:width                  114
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Until Next Slide"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Indefinite
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup indefiniteButton)
		:when                   (Notify )
		:to                     (slidePopup indefiniteButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Indefinite)
		)
	)
)
(
	:type                   :text-field
	:name                   duration
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      104
	:width                  226
	:height                 15
	:value-x                178
	:value-y                104
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Display Time (in sec) :"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          DurationEventProc
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup duration)
		:when                   (AnyEvent )
		:to                     (slidePopup duration)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DurationEventProc)
		)
	)
)
(
	:type                   :scrolling-list
	:name                   imageList
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      152
	:width                  390
	:height                 134
	:value-x                16
	:value-y                152
	:rows                   5
	:foreground-color       ""
	:label                  ""
	:title                  "Images:"
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         ImageList
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup imageList)
		:when                   (Notify )
		:to                     (slidePopup imageList)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageList)
		)
	)
)
(
	:type                   :message
	:name                   imageNameMessage
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      312
	:width                  92
	:height                 13
	:foreground-color       ""
	:label                  "Image Name: "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   imageName
	:owner                  controls5
	:help                   ""
	:x                      120
	:y                      312
	:width                  0
	:height                 0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   imageFormatMessage
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      336
	:width                  100
	:height                 13
	:foreground-color       ""
	:label                  "Image Format: "
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   imageFormat
	:owner                  controls5
	:help                   ""
	:x                      128
	:y                      336
	:width                  0
	:height                 0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   imageOriginalSizeMessage
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      360
	:width                  135
	:height                 13
	:foreground-color       ""
	:label                  "Original Size (WxH):"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   imageOriginalSize
	:owner                  controls5
	:help                   ""
	:x                      168
	:y                      360
	:width                  0
	:height                 0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   imageWidth
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      392
	:width                  198
	:height                 15
	:value-x                139
	:value-y                392
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Displayed Width:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              1200
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         ImageWidth
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup imageWidth)
		:when                   (Notify )
		:to                     (slidePopup imageWidth)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageWidth)
		)
	)
)
(
	:type                   :button
	:name                   imageEditButton
	:owner                  controls5
	:help                   ""
	:x                      280
	:y                      392
	:width                  97
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Edit Image"
	:label-type             :string
	:initial-state          :active
	:menu                   imageEditMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   imageHeight
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      416
	:width                  204
	:height                 15
	:value-x                145
	:value-y                416
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Displayed Height:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              1200
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         ImageHeight
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup imageHeight)
		:when                   (Notify )
		:to                     (slidePopup imageHeight)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageHeight)
		)
	)
)
(
	:type                   :text-field
	:name                   imageXPosition
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      440
	:width                  155
	:height                 15
	:value-x                96
	:value-y                440
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "X Position:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              1200
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         ImageXPosition
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup imageXPosition)
		:when                   (Notify )
		:to                     (slidePopup imageXPosition)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageXPosition)
		)
	)
)
(
	:type                   :text-field
	:name                   imageYPosition
	:owner                  controls5
	:help                   ""
	:x                      16
	:y                      464
	:width                  155
	:height                 15
	:value-x                96
	:value-y                464
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Y Position:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              1200
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         ImageYPosition
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slidePopup imageYPosition)
		:when                   (Notify )
		:to                     (slidePopup imageYPosition)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ImageYPosition)
		)
	)
)
(
	:type                   :popup-window
	:name                   slideNumberPopup
	:owner                  baseWindow
	:width                  380
	:height                 86
	:background-color       ""
	:foreground-color       ""
	:label                  "Slide Number"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls4
	:owner                  slideNumberPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  380
	:height                 86
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   slideNumber
	:owner                  controls4
	:help                   ""
	:x                      24
	:y                      32
	:width                  175
	:height                 15
	:value-x                128
	:value-y                32
	:value-length           4
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Slide Number:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         SlideNumber
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slideNumberPopup slideNumber)
		:when                   (Notify )
		:to                     (slideNumberPopup slideNumber)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SlideNumber)
		)
	)
)
(
	:type                   :popup-window
	:name                   resizePopup
	:owner                  baseWindow
	:width                  400
	:height                 150
	:background-color       ""
	:foreground-color       ""
	:label                  "Resize Information"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              t
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls6
	:owner                  resizePopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  400
	:height                 150
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message9
	:owner                  controls6
	:help                   ""
	:x                      24
	:y                      40
	:width                  345
	:height                 13
	:foreground-color       ""
	:label                  "To resize images, use the rightmost mouse button"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message11
	:owner                  controls6
	:help                   ""
	:x                      24
	:y                      56
	:width                  296
	:height                 13
	:foreground-color       ""
	:label                  "and drag the image from one of its corners."
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   info1
	:owner                  controls6
	:help                   ""
	:x                      144
	:y                      104
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         DoneHandler
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (resizePopup info1)
		:when                   (Notify )
		:to                     (resizePopup info1)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DoneHandler)
		)
	)
)
)
